/**
 * Start time zone widget script
 */

(function ($, elementor) {
    'use strict';
    var widgetTimeZone = function ($scope, $) {
        var $TimeZone = $scope.find('.bdt-time-zone');

        if (!$TimeZone.length) {
            return;
        }
        elementorFrontend.waypoint($TimeZone, function () {
            var $this = $(this);
            var $settings = $this.data('settings');
            var timeFormat;

            if ($settings.timeHour == '12h') {
                timeFormat = '%I:%M:%S %p';
            } else {
                timeFormat = '%H:%M:%S';
            }
            // dateFormat
            var dateFormat = $settings.dateFormat;
            if (dateFormat != 'emptyDate') {
                dateFormat = '<div class=\"bdt-time-zone-date\"> ' + $settings.dateFormat + ' </div>'
            } else {
                dateFormat = '';
            }
            var country;
            if ($settings.country != 'emptyCountry') {
                country = '<div  class=\"bdt-time-zone-country\">' + $settings.country + '</div>';
            } else {
                country = ' ';
            }
            var timeZoneFormat;
            timeZoneFormat = '<div class=\"bdt-time-zone-dt\"> ' + country + ' ' + dateFormat + ' <div class=\"bdt-time-zone-time\">' + timeFormat + ' </div> </div>';
            var offset = $settings.gmt;
            if (offset == '') return;
            var options = {
                format: timeZoneFormat,
                timeNotation: $settings.timeHour, //'24h',
                am_pm: true,
                utc: (offset == 'local') ? false : true,
                utcOffset: (offset == 'local') ? null : offset,
            }

            if ('digital' == $settings.clock_style) {
                $('#' + $settings.id).jclock(options);
            } else {
                var analogClock = {
                    convertToTimeZoneAndFormat: function (date, offset) {
                        // Get the UTC time in milliseconds
                        const utcTime = date.getTime() + (date.getTimezoneOffset() * 60000);

                        // Calculate the target time using the offset
                        const targetTime = new Date(utcTime + (offset * 3600000));

                        // Extract hours, minutes, and seconds
                        let hours = targetTime.getHours();
                        let minutes = targetTime.getMinutes();
                        let seconds = targetTime.getSeconds();
                        const ampm = hours >= 12 ? 'PM' : 'AM';
                        hours = hours % 12 || 12; // Convert to 12-hour format and handle midnight (0 AM)

                        // Add leading zeros to single-digit minutes and seconds
                        minutes = minutes < 10 ? '0' + minutes : minutes;
                        seconds = seconds < 10 ? '0' + seconds : seconds;

                        return {
                            hours,
                            minutes,
                            seconds,
                            ampm,
                        };
                    },
                    updateTime: function () {
                        setInterval(function () {
                            let localDate = new Date(); // Your local date and time
                            let targetOffset = offset;
                            let result = analogClock.convertToTimeZoneAndFormat(localDate, targetOffset);

                            var second = result.seconds * 6,
                                minute = result.minutes * 6 + second / 60,
                                hour = ((result.hours % 12) / 12) * 360 + 90 + minute / 12;

                            $($TimeZone).find('.bdt-clock-hour').css("transform", "rotate(" + hour + "deg)");
                            $($TimeZone).find('.bdt-clock-minute').css("transform", "rotate(" + minute + "deg)");
                            $($TimeZone).find('.bdt-clock-second').css("transform", "rotate(" + second + "deg)");
                            $($TimeZone).find('.bdt-clock-am-pm').text(result.ampm);

                        }, 1000);
                    },
                    init: function () {
                        this.updateTime();
                    }
                }
                analogClock.init();

            }
        }, {
            offset: 'bottom-in-view'
        });
    };
    jQuery(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction('frontend/element_ready/bdt-time-zone.default', widgetTimeZone);
    });
}(jQuery, window.elementorFrontend));

/**
 * End time zone widget script
 */