<?php
/**
 * Class for the Custom Theme
 *
 * @package thebase
 */

namespace TheBase\Custom_Theme;


use TheBase\Theme_Customizer;
use function TheBase\thebase;
use TheBase_Blocks_Frontend;
use TheBase\Component_Interface;
use TheBase\Templating_Component_Interface;
use TheBase\TheBase_CSS;
use LearnDash_Settings_Section;
use function TheBase\get_webfont_url;
use function TheBase\print_webfont_preload;
use function add_action;
use function add_filter;
use function wp_enqueue_style;
use function wp_register_style;
use function wp_style_add_data;
use function get_theme_file_uri;
use function get_theme_file_path;
use function wp_styles;
use function esc_attr;
use function esc_url;
use function wp_style_is;
use function _doing_it_wrong;
use function wp_print_styles;
use function post_password_required;
use function is_singular;
use function comments_open;
use function get_comments_number;
use function apply_filters;
use function add_query_arg;
use function wp_add_inline_style;

/**
 * Main plugin class
 */
class Custom_Theme {
	/**
	 * Instance Control
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Holds theme array sections.
	 *
	 * @var the theme settings sections.
	 */
	private $update_options = array();

	/**
	 * Instance Control.
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Throw error on object clone.
	 *
	 * The whole idea of the singleton design pattern is that there is a single
	 * object therefore, we don't want the object to be cloned.
	 *
	 * @return void
	 */
	public function __clone() {
		// Cloning instances of the class is forbidden.
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cloning instances of the class is Forbidden', 'basetheme' ), '1.0' );
	}

	/**
	 * Disable un-serializing of the class.
	 *
	 * @return void
	 */
	public function __wakeup() {
		// Unserializing instances of the class is forbidden.
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Unserializing instances of the class is forbidden', 'basetheme' ), '1.0' );
	}
	/**
	 * Constructor function.
	 */
	public function __construct() {
		
		add_filter( 'thebase_theme_options_defaults', array( $this, 'add_option_defaults' ), 10 );
		add_filter( 'thebase_global_palette_defaults', array( $this, 'add_color_option_defaults' ), 50 );
		add_filter( 'thebase_addons_theme_options_defaults', array( $this, 'add_addon_option_defaults' ), 10 );
		add_action( 'thebase_hero_header', array( $this, 'shop_filter' ), 5 );
		add_action( 'thebase_before_sidebar', array( $this, 'close_shop_filter' ),  5 );
		add_filter( 'thebase_dynamic_css', array( $this, 'child_dynamic_css' ), 30 );
	}
	public function child_dynamic_css( $css ) {
		$generated_css = $this->generate_child_css();
		if ( ! empty( $generated_css ) ) {
		$css .= "\n/* Base Pro Header CSS */\n" . $generated_css;
		}
		return $css;
	}
	public function generate_child_css () {
		$css = new TheBase_CSS();
		
		$css->set_selector( '.primary-sidebar.widget-area .widget-title, .widget_block h2,.widget_block .widgettitle,.widget_block .widgettitle,.primary-sidebar h2' );
		$css->render_font( thebase()->option( 'sidebar_widget_title' ), $css );
		return $css->css_output();
	}
	/**
	 * set child theme Default color.
	 */
	public function add_color_option_defaults( $defaults ) {
		$default_palette = '';
		if ( is_null( $default_palette ) ) {
		$default_palette = '{"palette":[{"color":"#222222","slug":"palette1","name":"Palette Color 1"},{"color":"#1fa7b9","slug":"palette2","name":"Palette Color 2"},{"color":"#222222","slug":"palette3","name":"Palette Color 3"},{"color":"#2e2e2e","slug":"palette4","name":"Palette Color 4"},{"color":"#666666","slug":"palette5","name":"Palette Color 5"},{"color":"#1c1c1c","slug":"palette6","name":"Palette Color 6"},{"color":"#edf2f2","slug":"palette7","name":"Palette Color 7"},{"color":"#e5e5e5","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],
		"second-palette":[{"color":"#2B6CB0","slug":"palette1","name":"Palette Color 1"},{"color":"#215387","slug":"palette2","name":"Palette Color 2"},{"color":"#1A202C","slug":"palette3","name":"Palette Color 3"},{"color":"#2D3748","slug":"palette4","name":"Palette Color 4"},{"color":"#4A5568","slug":"palette5","name":"Palette Color 5"},{"color":"#718096","slug":"palette6","name":"Palette Color 6"},{"color":"#EDF2F7","slug":"palette7","name":"Palette Color 7"},{"color":"#FFFFFF","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],
		"third-palette":[{"color":"#2B6CB0","slug":"palette1","name":"Palette Color 1"},{"color":"#215387","slug":"palette2","name":"Palette Color 2"},{"color":"#1A202C","slug":"palette3","name":"Palette Color 3"},{"color":"#2D3748","slug":"palette4","name":"Palette Color 4"},{"color":"#4A5568","slug":"palette5","name":"Palette Color 5"},{"color":"#718096","slug":"palette6","name":"Palette Color 6"},{"color":"#EDF2F7","slug":"palette7","name":"Palette Color 7"},{"color":"#F7FAFC","slug":"palette8","name":"Palette Color 8"},{"color":"#ffffff","slug":"palette9","name":"Palette Color 9"}],"active":"palette"}';
		}
		return $default_palette;
	}

	/**
	 * Shop Filter
	 */
	public function shop_filter() {
		if (  thebase()->has_sidebar() ) {	
		echo '<div class="thebase-show-sidebar-btn thebase-action-btn thebase-style-text">';
		echo '<span class="drawer-overlay" data-drawer-target-string="#mobile-drawer"></span>';
		echo '<span class="menu-toggle-icon 00">'.thebase()->print_icon( 'menu', '', false ).'</span>';
		echo '</div>';
		}
	}
	/**
	 * Shop Filter Close
	 */
	public function close_shop_filter($sale) {
		if (  thebase()->has_sidebar() ) {
		echo '<div class="thebase-hide-sidebar-btn">';
		echo '<span class="menu-toggle-icon">'.thebase()->print_icon( 'close', '', false ).'</span>';
		echo '</div>';
		}
	}
	public function add_option_defaults( $defaults ) {

		$update_options = array(
			'page_layout'             => 'normal',
			'page_title'              => true,
			'page_content_style'      => 'unboxed',
			//background
			'site_background'                => array(
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			// Logo.
			'logo_width' => array(
				'size' => array(
					'mobile'  => 158,
					'tablet'  => 188,
					'desktop' => 198,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'logo_layout'     => array(
				'include' => array(
					'mobile'  => 'logo_only',
					'tablet'  => 'logo_only',
					'desktop' => 'logo_only',
				),
			),
			'brand_typography' => array(
				'size' => array(
					'desktop' => 30,
				),
				'lineHeight' => array(
					'desktop' => 1.2,
				),
				'family'  => 'inherit',
				'transform' => 'uppercase',
				'google'  => false,
				'weight'  => '500',
				'variant' => '500',
				'color'   => 'palette9',
			),
			'brand_typography_color'  => array(
				'hover'  => 'palette9',
				'active' => 'palette9',
			),
			'brand_tag_typography' => array(
				'size' => array(
					'desktop' => 16,
				),
				'lineHeight' => array(
					'desktop' => 1.4,
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '500',
				'variant' => '500',
				'color'   => 'palette5',
			),
			'header_logo_padding' => array(
				'size'   => array( 
					'desktop' => array( '', '', '', '' ),
				),
				'unit'   => array(
					'desktop' => 'px',
				),
				'locked' => array(
					'desktop' => false,
				),
			),
			//button
			'buttons_padding' => array(
				'size'   => array( 
					'mobile' => array( '7', '20', '7', '20' ),
					'tablet' => array( '12', '35', '12', '35' ),
					'desktop' => array( '14', '47', '14', '47' ),
				),
				'unit'   => array(
					'mobile' => 'px',
					'tablet' => 'px',
					'desktop' => 'px',
				),
				'locked' => array(
					'desktop' => false,
				),
			),
			'buttons_border' => array(
				'desktop' => array(
					'width' => '',
					'unit'  => 'px',
					'style' => 'solid',
					'color'  => 'palette1',
					'hover'  => 'palette1',
				),
			),
			'buttons_shadow' => array(
				'color'   => 'rgba(0,0,0,0)',
				'hOffset' => 0,
				'vOffset' => 0,
				'blur'    => 0,
				'spread'  => 0,
				'inset'   => false,
			),
			'buttons_shadow_hover' => array(
				'color'   => 'rgba(0,0,0,0)',
				'hOffset' => 0,
				'vOffset' => 0,
				'blur'    => 0,
				'spread'  => 0,
				'inset'   => false,
			),
			'buttons_background' => array(
				'color'  => 'palette2',
				'hover'  => 'palette1',
			),
			'buttons_color' => array(
				'color'  => 'palette9',
				'hover'  => 'palette9',
			),
			'buttons_border' => array(
				'desktop' => array(
					'width' => '',
					'unit'  => 'px',
					'style' => '',
					'color'  => 'palette1',
					'hover'  => 'palette1',
				),
			),
			'buttons_typography'    => array(
				'google'  => true,
				'transform' => 'uppercase',
			),
			'buttons_border_radius' => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => '0',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'buttons_typography' => array(
				'size' => array(
					'mobile'  => '14',
					'tablet'  => '',
					'desktop' => '15',
				),
				'lineHeight' => array(
					'desktop' => '25',
				),
				'lineType' =>  'px',
				'letterSpacing' => array(
					'desktop' => '0.5',
				),
				'spacingType'=> 'px',
				'transform' => 'uppercase',
				'family'  => 'Poppins',
				'google'  => false,
				'weight'  => '500',
				'variant' => '500',
			),
			//Search
			'search_archive_title_color' => array(
				'color' => 'palette9',
			),
			'search_archive_title_height'       => array(
				'size' => array(
					'mobile'  => '200',
					'tablet'  => '350',
					'desktop' => '350',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'search_archive_title_align' => array(
				'mobile'  => 'center',
				'tablet'  => 'center',
				'desktop' => 'center',
			),
			'search_archive_item_meta_font'   => array(
				'size' => array(
					'mobile' => '14',
					'tablet' => '14',
					'desktop' => '14',
				),
				'lineHeight' => array(
					'mobile' => '1.3',
					'tablet' => '1.6',
					'desktop' => '1.6',
				),
				'lineType' =>  'px',
				'letterSpacing' => array(
					'mobile' => '3.2',
					'tablet' => '3.2',
					'desktop' => '3.2',
				),
				'spacingType'=> 'px',
				'transform' => 'inherit',
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'search_archive_item_category_font'   => array(
				'size' => array(
					'mobile' => '14',
					'tablet' => '14',
					'desktop' => '14',
				),
				'lineHeight' => array(
					'mobile' => '1.3',
					'tablet' => '1.6',
					'desktop' => '1.6',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '400',
				'variant' => '400',
			),
			'search_archive_item_category_color' => array(
				'color' => 'palette5',
				'hover' => 'palette5',
			),
			'search_archive_item_meta_color' => array(
				'color' => 'palette5',
				'hover' => 'palette5',
			),
			'search_archive_title_background'    => array(
				'desktop' => array(
					'color' => 'palette7',
				),
			),
			'search_archive_element_excerpt' => array(
				'enabled'     => false,
				'words'       => 18,
				'fullContent' => false,
			),
			'search_archive_element_categories'   => array(
				'enabled' => false,
				'style'   => 'normal',
				'divider' => 'vline',
			),
			'search_archive_element_meta' => array(
				'id'                     => 'meta',
				'enabled'                => true,
				'divider'                => 'dot',
				'author'                 => false,
				'authorLink'             => true,
				'authorImage'            => false,
				'authorImageSize'        => 25,
				'authorEnableLabel'      => true,
				'authorLabel'            => '',
				'date'                   => true,
				'dateEnableLabel'        => false,
				'dateLabel'              => '',
				'dateUpdated'            => false,
				'dateUpdatedEnableLabel' => false,
				'dateUpdatedLabel'       => '',
				'categories'             => false,
				'categoriesEnableLabel'  => false,
				'categoriesLabel'        => '',
				'comments'               => false,
			),
			'search_archive_content_style'        => 'unboxed',
			'search_archive_title_layout' => 'above',
			'search_archive_item_title_font'   => array(
				'size' => array(
					'desktop' => '22',
				),
				'lineHeight' => array(
					'desktop' => '1.3',
				),
				'family'  => '',
				'google'  => false,
				'weight'  => '500',
				'variant' => '500',
			),
			// Scroll To Top.
			'scroll_up'               => true,
			'scroll_up_side'          => 'right',
			'scroll_up_icon'          => 'chevron-up',
			'scroll_up_color'                     => array(
				'color'  => 'palette9',
				'hover'  => 'palette9',
			),
			'scroll_up_style' => 'filled',
			'scroll_up_icon_size'   => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => 1.2,
				),
				'unit' => array(
					'mobile'  => 'em',
					'tablet'  => 'em',
					'desktop' => 'em',
				),
			),
			'scroll_up_border_colors'         => array(
				'color'  => 'palette2',
				'hover'  => 'palette1',
			),
			'scroll_up_background'                     => array(
				'color'  => 'palette2',
				'hover'  => 'palette1',
			),
			'scroll_up_border'    => array(),


			// Product Controls.

			'product_above_layout'       => 'title',
			'product_title_elements'           => array('above_title','breadcrumb', 'category'),
			'product_title_element_category' => array(
				'enabled' => false,
			),
			'product_title_element_above_title' => array(
				'enabled' => false,
			),
			'product_title_element_breadcrumb' => array(
				'enabled' => true,
				'show_title' => true,
			),
			'product_title_height'       => array(
				'size' => array(
					'mobile'  => 150,
					'tablet'  => 180,
					'desktop' => 200,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'product_above_title_font'   => array(
				'size' => array(
					'mobile'  => '30',
					'tablet'  => '35',
					'desktop' => '40',
				),
				'lineHeight' => array(
					'desktop' => '2.4',
				),
				'family'  => 'Playfair Display',
				'google'  => false,
				'weight'  => '700',
				'variant' => '700',
				'color'   => 'palette1',
			),
			
			//single-product
			'product_tab_title'   => false,
			'product_tab_style'   => 'center',
			'custom_quantity' => true,
			//content-width
			'content_width' => array(
				'size' => 1348,
				'unit' => 'px',
			),
			'content_background' => array(
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			'content_spacing'   => array(
				'size' => array(
					'mobile'  => 1,
					'tablet'  => 2,
					'desktop' => 3,
				),
				'unit' => array(
					'mobile'  => 'rem',
					'tablet'  => 'rem',
					'desktop' => 'rem',
				),
			),
			// Header Top.
			'header_top_height'       => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => 55,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'header_top_background'    => array(
				'desktop' => array(
					'color' => 'palette7',
				),
			),
			'header_top_trans_background'    => array(
				'desktop' => array(
					'color' => 'palette1',
					'opacity' => '0.6',
				),				
			),
			//header-main-layout
			'page_title_background'   => array(
				'desktop' => array(
					'color' => 'palette7',
				),
			),
			'page_title_font'   => array(
				'color' => 'palette1',
			),
			'page_title_breadcrumb_color' => array(
				'color' => 'palette1',
				'hover' => 'palette1',
			),
			'page_title_height'       => array(
				'size' => array(
					'mobile'  => '150',
					'tablet'  => '180',
					'desktop' => '200',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'header_main_top_border'    => array(
						'desktop' => array(
							'width' => '1',
							'unit'  => 'px',
							'style' => 'solid',
							'color'  => '#363636',
						),
					),
			'header_main_layout' => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => 'standard',
			),
			'primary_navigation_vertical_spacing'   => array(
				'size' => 42,
				'unit' => 'px',
			),
			'page_title_layout' => 'above',
			'dropdown_navigation_typography'            => array(
				'size' => array(
					'desktop' => 14,
				),
				'lineHeight' => array(
					'desktop' => '1.5',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'dropdown_navigation_color'              => array(
				'color'  => 'palette1',
				'hover'  => 'palette9',
				'active' => 'palette9',
			),
			'dropdown_navigation_width'  => array(
				'size' => 250,
				'unit' => 'px',
			),
			'dropdown_navigation_background'              => array(
				'color'  => 'palette9',
				'hover'  => 'palette2',
				'active' => 'palette2',
			),
			'dropdown_navigation_vertical_spacing'   => array(
				'size' => 1,
				'unit' => 'em',
			),
			'dropdown_navigation_divider'              => array(
				'width' => 1,
				'unit'  => 'px',
				'style' => 'solid',
				'color' => 'rgba(0,0,0,0.1)',
			),
			'mobile_navigation_color'              => array(
				'color'  => 'palette1',
				'hover'  => 'palette2',
				'active' => 'palette2',
			),
			'mobile_navigation_background'              => array(
				'color'  => 'palette9',
				'hover'  => '',
				'active' => '',
			),
			'mobile_navigation_divider'              => array(
				'width' => 1,
				'unit'  => 'px',
				'style' => 'solid',
				'color' => 'rgba(0,0,0,0.1)',
			),
			'header_search_modal_color'  => array(
				'color' => 'palette1',
				'hover' => 'palette1',
			),
			'header_search_modal_background'                => array(
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			'header_sticky' => 'main',
			'mobile_header_sticky' => 'main',
			'header_sticky_background' => array(
				'mobile' => array(
					'color' => 'palette9',
				),
				'tablet' => array(
					'color' => 'palette9',
				),
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			'header_search_icon_size' => array(
				'size' => array(
					'mobile'  => 13,
					'tablet'  => 13,
					'desktop' => 15,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'header_search_icon'   => 'search2',
			'header_desktop_items' => array(
				'top' => array(
					'top_left'         => array('contact'),
					'top_left_center'  => array(),
					'top_center'       => array(),
					'top_right_center' => array(),
					'top_right'        => array('button'),
				),
				'main' => array(
					'main_left' => array( 'logo' ),
					'main_center' => array(),
					'main_right' => array( 'navigation','search' ),
				),
				'bottom' => array(
					'bottom_left'         => array(),
					'bottom_left_center'  => array(),
					'bottom_center'       => array(),
					'bottom_right_center' => array(),
					'bottom_right'        => array(),
				),
			),
			'header_main_height' => array(
				'size' => array(
					'mobile'  => 80,
					'tablet'  => 80,
					'desktop' => 100,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			// Header Button.
			'header_button_label'      => __( 'Donate Now', 'basetheme' ),
			// Mobile Header.
			'header_mobile_items' => array(
				'popup' => array(
					'popup_content' => array( 'mobile-navigation' ),
				),
				'top' => array(
					'top_left'   => array(),
					'top_center' => array(),
					'top_right'  => array(),
				),
				'main' => array(
					'main_left'   => array( 'mobile-logo' ),
					'main_center' => array(),
					'main_right'  => array( 'popup-toggle','search' ),
				),
				'bottom' => array(
					'bottom_left'   => array(),
					'bottom_center' => array(),
					'bottom_right'  => array(),
				),
			),
			'mobile_trigger_icon_size'   => array(
				'size' => 20,
				'unit' => 'px',
			),
			'mobile_trigger_padding' => array(
				'size'   => array( 0, 5, 0, 0 ),
				'unit'   => 'px',
				'locked' => false,
			),
			// Navigation.
			'primary_navigation_typography' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.5',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 15,
					'tablet' => 15,
					'desktop' => 15,
				),
				'unit' => array(
					'mobile' => 'px',
					'tablet' => 'px',
					'desktop' => 'px',
				),
				'lineHeight' => array(
					'mobile' => 1.4,
					'tablet' => 1.6,
					'desktop' => 1.5,
				),
				'linetype' => 'em',			
				'google'  => true,
				'family'  => 'Poppins',
				'weight'  => '500',
				'transform' => 'capitalize',
				'variant' => '500',								
			),
			'transparent_header_enable' => false,
			'transparent_header_post' => true,
			'primary_navigation_color' => array(
				'color'  => 'palette1',
				'hover'  => 'palette2',
				'active' => 'palette2',
			),
			'header_wrap_background' => array(
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			'primary_navigation_spacing' => array(
				'size' => 45,
				'unit' => 'px',
			),
			'header_search_color' => array(
				'color' => 'palette1',
				'hover' => 'palette2',
			),
			'header_main_padding' => array(
				'size'   => array( 
					'mobile' => array( '', '20', '', '20' ),
					'desktop' => array( '', '24', '', '24' ),
				),
			),
			'header_main_background' => array(
				'desktop' => array(
					'color' => 'palette9',
				),
			),
			// Footer.
			'footer_items'       => array(
				'top' => array(
					'top_1' => array(),
					'top_2' => array(),
					'top_3' => array(),
					'top_4' => array(),
					'top_5' => array(),
				),
				'middle' => array(
					'middle_1' => array('footer-widget1','footer-social'),
					'middle_2' => array('footer-widget2'),
					'middle_3' => array('footer-widget3'),
					'middle_4' => array('footer-widget4'),
					'middle_5' => array(),
				),
				'bottom' => array(
					'bottom_1' => array( 'footer-html' ),
					'bottom_2' => array(),
					'bottom_3' => array(),
					'bottom_4' => array(),
					'bottom_5' => array(),
				),
			),
			'footer_middle_columns' => '4',
			'footer_middle_widget_title'  => array(
				'size' => array(
					'mobile' => '20',
					'tablet' => '20',
					'desktop' => '22',
				),
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
				'lineHeight' => array(
					'mobile' => 1.3,
					'tablet' => 1.3,
					'desktop' => 1.3,
				),
				'linetype' => 'em',	
				'family'  => 'Playfair Display',
				'transform' => 'capitalize',
				'google'  => true,
				'weight'  => '600',
				'variant' => '600',
				'color'   => 'palette2',
			),
			'footer_wrap_background' => array(
				'desktop' => array(
					'color' => 'palette6',
				),
			),
			'footer_social_vertical_align' => array(
				'desktop' => 'middle',
			),
			'footer_bottom_top_border' => array(
				'desktop' => array(
					'width' => 1,
					'unit'  => 'px',
					'style' => 'solid',
					'color'  => 'palette4',
				),
			),
			'footer_middle_column_spacing' => array(
				'size' => array(
					'mobile'  => '0',
					'tablet'  => '0',
					'desktop' => '0',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'footer_middle_link_style' => 'noline',
			'footer_middle_height' => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => '',
				),
			),
			'footer_middle_top_spacing' => array(
				'size' => array(
					'mobile'  => '55',
					'tablet'  => '55',
					'desktop' => '136',
				),
			),
			'footer_middle_bottom_spacing' => array(
				'size' => array(
					'mobile'  => '35',
					'tablet'  => '55',
					'desktop' => '136',
				),
			),
			'footer_social_margin' => array(
				'size'   => array( '30', '', '', '' ),
				'unit'   => 'px',
				'locked' => false,
			),
			//footer-bottom
			'footer_bottom_top_spacing' => array(
				'size' => array(
					'mobile'  => '5',
					'tablet'  => '5',
					'desktop' => '5',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'footer_bottom_bottom_spacing' => array(
				'size' => array(
					'mobile'  => '5',
					'tablet'  => '5',
					'desktop' => '5',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			//Footer HTML
			'footer_html_content'    => '{copyright} {year} All Rights Reserved. Developed By Codezeel',
			'footer_html_align'  => array(
						'mobile'  => 'center',
						'tablet'  => 'center',
						'desktop' => 'center',
					),
			// Footer Social.
			'footer_social_items' => array(
				'items' => array(
					array(
						'id'      => 'facebook',
						'enabled' => true,
						'source'  => 'icon',
						'url'     => '',
						'imageid' => '',
						'width'   => 20,
						'icon'    => 'facebookAlt2',
						'label'   => 'Facebook',
					),
					array(
						'id'      => 'twitter',
						'enabled' => true,
						'source'  => 'icon',
						'url'     => '',
						'imageid' => '',
						'width'   => 20,
						'icon'    => 'twitter',
						'label'   => 'Twitter',
					),
					array(
						'id'      => 'instagram',
						'enabled' => true,
						'source'  => 'icon',
						'url'     => '',
						'imageid' => '',
						'width'   => 20,
						'icon'    => 'instagramAlt',
						'label'   => 'Instagram',
					),
					array(
						'id'      => 'linkedin',
						'enabled' => true,
						'source'  => 'icon',
						'url'     => '',
						'imageid' => '',
						'width'   => 20,
						'icon'    => 'linkedinAlt',
						'label'   => 'linkedin',
					),
					array(
						'id'      => 'google_reviews',
						'enabled' => true,
						'source'  => 'icon',
						'url'     => '',
						'imageid' => '',
						'width'   => 20,
						'icon'    => 'google_reviews',
						'label'   => 'Google Reviews',
					),
				),
			),
			'footer_middle_widget_spacing' => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => '20',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'footer_social_icon_size' => array(
				'size' => 20,
				'unit' => 'px',
			),
			'footer_social_border_radius' => array(
				'size' => 50,
				'unit' => 'px',
			),
			'footer_social_item_spacing' => array(
				'size' => 0.5,
				'unit' => 'em',
			),
			'footer_social_color' => array(
				'color' => '#868686',
				'hover' => 'palette9',
			),
			'footer_social_background' => array(
				'color' => '#363636',
				'hover' => 'palette2',
			),
			'footer_middle_layout'  => array(
				'mobile'  => 'row',
				'tablet'  => '',
				'desktop' => 'left-forty',
			),
			'footer_middle_direction' => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => 'column',
			),
			'footer_middle_widget_content' => array(
				'size' => array(
					'desktop' => '15',
				),
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.5',
				),
				'spacingType'=> 'px',
				'lineHeight' => array(
					'desktop' => '1.3',
				),
				'family'  => 'Poppins',
				'google'  => true,
				'weight'  => '400',
				'color'   => 'palette9',
				'transform' => 'capitalize',
			),
			'footer_middle_link_colors' => array(
				'color' => 'palette9',
				'hover' => 'palette2',	
			),
			'footer_html_typography' => array(
				'size' => array(
					'desktop' => '15',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'Poppins',
				'google'  => true,
				'weight'  => '400',
				'variant' => '400',
				'color'   => 'palette9',
				'transform' => 'capitalize'
			),
			'footer_html_link_color' => array(
				'color' => '#b9b9b9',
				'hover' => 'palette9',
			),
			'footer_html_link_style' => 'plain',
			// Typography.
			'base_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.5',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 14,
					'tablet' => 15,
					'desktop' => 15,
				),
				'unit' => array(
					'mobile' => 'px',
					'tablet' => 'px',
					'desktop' => 'px',
				),
				'lineHeight' => array(
					'mobile' => 1.5,
					'tablet' => 1.7,
					'desktop' => 1.7,
				),
				'linetype' => 'em',
				// 'family'  => '-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"',
				'google'  => true,
				'family'  => 'Poppins',
				'weight'  => '400',
				'transform' => 'none',
				'variant' => 'normal',
				'color'   => 'palette5',
			),
			'link_color' => array(
				'highlight'      => 'palette1',
				'highlight-alt'  => 'palette5',
				'highlight-alt2' => 'palette5',
				'style'          => 'no-underline',
			),
			'heading_font' => array(
				'family' => 'Poppins',
			),
			'h1_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 26,
					'tablet' => 35,
					'desktop' => 40,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.0,
					'tablet' => 1.2,
					'desktop' => 1.2,
				),
				'linetype' => 'em',
				'weight'  => '700',
				'variant' => '700',
				'transform' => 'capitalize',
				'family'  => 'Playfair Display',
				'color'   => 'palette1',
			),
			'h2_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 24,
					'tablet' => 30,
					'desktop' => 30,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.0,
					'tablet' => 1.3,
					'desktop' => 1.3,
				),
				'linetype' => 'em',
				'weight'  => '700',
				'variant' => '700',
				'transform' => 'capitalize',
				'family'  => 'Playfair Display',
				'color'   => 'palette9'
			),
			'h3_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.5',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 14,
					'tablet' => 15,
					'desktop' => 15,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.0,
					'tablet' => 1.2,
					'desktop' => 1.2,
				),
				'linetype' => 'em',
				'weight'  => '500',
				'variant' => '500',
				'transform' => 'uppercase',
				'family'  => 'inherit',
				'color'   => 'palette2',
			),
			'h4_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
				'size' => array(
					'mobile' => 20,
					'tablet' => 22,
					'desktop' => 22,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.0,
					'tablet' => 1.2,
					'desktop' => 1.5,
				),
				'linetype' => 'em',
				'weight'  => '700',
				'variant' => '700',
				'transform' => 'capitalize',
				'family'  => 'Playfair Display',
				'color'   => 'palette1',
			),
			'h5_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
				'size' => array(
					'desktop' => 18,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.0,
					'tablet' => 1.2,
					'desktop' => 1.2,
				),
				'linetype' => 'em',
				'weight'  => '600',
				'variant' => '600',
				'transform' => 'capitalize',
				'family'  => 'inherit',
				'color'   => 'palette4',
			),
			'h6_font' => array(
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
				'size' => array(
					'desktop' => 18,
				),
				'lineHeight' => array(
					'unit' => 'em',
					'mobile' => 1.2,
					'tablet' => 1.4,
					'desktop' => 1.4,
				),
				'linetype' => 'em',
				'weight'  => '500',
				'variant' => '500',
				'transform' => 'capitalize',
				'family'  => 'inherit',
				'color'   => 'palette5',
			),
			'mobile_trigger_color' => array(
				'color' => 'palette1',
				'hover' => 'palette2',
			),
			//Page-Layout
			'page_title_align'         => array(
				'mobile'  => 'center',
				'tablet'  => 'center',
				'desktop' => 'center',
			),
			'page_title_element_breadcrumb' => array(
				'enabled' => true,
				'show_title' => true,
			),
			//blog
			'post_archive_title_background'    => array(
				'desktop' => array(
					'color' => 'palette7',
				),
			),
			'post_archive_title_height'       => array(
				'size' => array(
					'mobile'  => '150',
					'tablet'  => '180',
					'desktop' => '200',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'post_archive_title_color' => array(
				'color' => 'palette1',
				'hover' => 'palette1',
			),
			'post_archive_title_breadcrumb_color' => array(
				'color' => 'palette1',
				'hover' => 'palette1',
			),
			'post_author_box'         => false,
			'post_author_box_style'   => 'normal',
			'post_archive_layout' => 'normal',
			'post_archive_sidebar_id' => 'sidebar-primary',
			'post_archive_columns' => '2',
			'post_archive_title_align' => array(
				'mobile'  => 'center',
				'tablet'  => 'center',
				'desktop' => 'center',
			),
			'post_archive_elements'             => array( 'meta', 'feature', 'title', 'categories', 'excerpt', 'readmore' ),
			'post_archive_element_categories'   => array(
				'enabled' => true,
				'style'   => 'normal',
				'divider' => 'vline',
			),
			'post_archive_element_title' => array(
				'enabled' => true,
			),
			'post_archive_element_meta' => array(
				'id'                     => 'meta',
				'enabled'                => true,
				'divider'                => 'dot',
				'author'                 => false,
				'authorLink'             => false,
				'authorImage'            => false,
				'authorImageSize'        => 25,
				'authorEnableLabel'      => true,
				'authorLabel'            => '',
				'date'                   => true,
				'dateEnableLabel'        => false,
				'dateLabel'              => '',
				'dateUpdated'            => false,
				'dateUpdatedEnableLabel' => false,
				'dateUpdatedLabel'       => '',
				'categories'             => false,
				'categoriesEnableLabel'  => false,
				'categoriesLabel'        => '',
				'comments'               => false,
			),
			'boxed_grid_shadow' => array(
				'color'   => 'rgba(0,0,0,0.1)',
				'hOffset' => 0,
				'vOffset' => 0,
				'blur'    => 6,
				'spread'  => 0,
				'inset'   => false,
			),
			'product_archive_sidebar_id' => 'sidebar-secondary',
			'post_archive_title_elements' => array( 'title' , 'breadcrumb' , 'description' ),
			'post_archive_title_element_breadcrumb' => array(
				'enabled' => true,
				'show_title' => true,
			),
			'product_archive_title_height'       => array(
				'size' => array(
					'mobile'  => '150',
					'tablet'  => '180',
					'desktop' => '200',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'page_title_breadcrumb_font'   => array(
				'size' => array(
					'desktop' => '14',
				),
				'lineHeight' => array(
					'desktop' => '1.6',
				),
				'linetype' => 'em',
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '400',
				'variant' => '400',
			),
			'post_archive_title_element_description' => array(
				'enabled' => false,
			),
			'post_archive_element_categories'   => array(
				'enabled' => false,
				'style'   => 'normal',
				'divider' => 'vline',
			),
			'post_archive_element_feature' => array(
				'enabled'   => true,
				'ratio'     => '3-4',
				'size'      => 'medium_large',
				'imageLink' => true,
			),			
			'post_archive_element_excerpt' => array(
				'enabled' => false,
			),
			'post_archive_item_title_font'   => array(
				'size' => array(
					'desktop' => '22',
				),
				'family'  => 'Playfair Display',
				'weight'  => '700',
				'variant' => '700',
				'color' => 'palette1',
			),
			'post_archive_content_style' => 'unboxed',
			'post_archive_item_meta_font'   => array(
				'size' => array(
					'desktop' => '14',
				),
				'letterSpacing' => array(
					'mobile' => '',
					'tablet' => '',
					'desktop' => '0.3',
				),
				'spacingType'=> 'px',
			),
			'post_title_meta_font'   => array(
				'size' => array(
					'desktop' => '14',
				),				
			),
			'post_archive_item_meta_color' => array(
				'color' => 'palette2',
				'hover' => '',
			),
			// Post Layout.
			'post_author_box_style'   => 'center',
			'product_archive_layout' => 'left',
			'post_vertical_padding' => 'hide',
			'post_feature_width' => 'full',
			'post_layout' => 'normal',
			'post_content_style' => 'boxed',
			'post_feature_position'   => 'behind',
			'post_feature_ratio' => '9-16',
			'post_related_columns' => '3',
			//archive
			'product_archive_title_font'   => array(
				'size' => array(
					'mobile' => '18',
					'tablet' => '18',
					'desktop' => '18',
				),
				'unit' => array(
					'mobile' => 'px',
					'tablet' => 'px',
					'desktop' => 'px',
				),
				'family'  => 'Poppins',
				'weight'  => '500',
				'variant' => '500',
				'lineHeight' => array(
					'desktop' => '1.4',
				),
				'unit' => array(
					'mobile' => 'em',
					'tablet' => 'em',
					'desktop' => 'em',
				),
				'color'   => 'palette1',
			),
			// Sidebar.
			'sidebar_width'   => array(
				'size' => '24',
				'unit' => '%',
			),
			'sidebar_padding'        => array(
				'size'   => array( 
					'desktop' => array( '0', '1.5', '1.5', '1.5' ),
				),
				'unit'   => array(
					'desktop' => 'em',
				),
				'locked' => array(
					'desktop' => false,
				),
			),
			'sidebar_link_style' => 'plain',
			'sidebar_link_colors' => array(
				'color' => 'palette5',
				'hover' => 'palette2',
			),
			'sidebar_widget_spacing'   => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => 1.5,
					'desktop' => 1.6,
				),
				'unit' => array(
					'mobile'  => 'em',
					'tablet'  => 'em',
					'desktop' => 'em',
				),
			),
			'sidebar_widget_title' => array(
				'size' => array(
					'desktop' => 20,
				),
				'family'  => 'Playfair Display',
				'google'  => true,
				'transform' => 'capitalize',
				'weight'  => '700',
				'variant' => '700',
				'color'   => 'palette1',
			),
			'sidebar_widget_content' => array(
				'size' => array(
					'desktop' => '15',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'weight'  => '400',
				'variant' => '400',
				'family'  => 'Poppins',
				'color'   => 'palette5',
				'transform' => 'capitalize'
			),
			//single-blog
			'boxed_spacing'   => array(
				'size' => array(
					'mobile'  => 1.5,
					'tablet'  => 2.8,
					'desktop' => 2.8,
				),
				'unit' => array(
					'mobile'  => 'rem',
					'tablet'  => 'rem',
					'desktop' => 'rem',
				),
			),
			'post_title_height'       => array(
				'size' => array(
					'mobile'  => '250',
					'tablet'  => '250',
					'desktop' => '350',
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'post_title_background'   => array(
				'desktop' => array(
					'color' => 'palette7',
				),
			),
			'post_title_element_meta' => array(
				'id'                     => 'meta',
				'enabled'                => true,
				'divider'                => 'vline',
				'author'                 => true,
				'authorLink'             => true,
				'authorImage'            => false,
				'authorImageSize'        => 25,
				'authorEnableLabel'      => true,
				'authorLabel'            => '',
				'date'                   => false,
				'dateEnableLabel'        => false,
				'dateLabel'              => '',
				'dateUpdated'            => false,
				'dateUpdatedEnableLabel' => false,
				'dateUpdatedLabel'       => '',
				'categories'             => false,
				'categoriesEnableLabel'  => false,
				'categoriesLabel'        => '',
				'comments'               => false,
			),
			'post_title_element_excerpt' => array(
				'enabled' => true,
			),
			'post_archive_element_excerpt' => array(
				'enabled'     => true,
				'words'       => 18,
				'fullContent' => false,
			),
			'post_title_category_font'   => array(
				'size' => array(
					'desktop' => '14',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '500',
				'variant' => '',
			),
			'post_archive_element_readmore' => array(
				'enabled' => false,
				'label'   => '',
			),
			'post_title_category_color' => array(
				'color' => 'palette5',
				'hover' => 'palette5',
			),
			'post_title_align' => array(
				'mobile'  => 'left',
				'tablet'  => 'left',
				'desktop' => 'left',
			),
			'boxed_shadow' => array(
				'color'   => 'rgba(0, 0, 0, 0)',
				'hOffset' => 0,
				'vOffset' => 0,
				'blur'    => 0,
				'spread'  => 0,
				'inset'   => false,
			),
			'boxed_border_radius' => array(
				'size'   => array( '0', '0', '0', '0' ),
				'unit'   => 'px',
				'locked' => true,
			),
			'post_title_element_categories' => array(
				'enabled' => true,
				'style'   => 'normal',
				'divider' => 'vline',
			),
			//404 Pgae
			'404_content_style' => 'unboxed',
			//woocommerce
			'product_archive_title_element_breadcrumb' => array(
				'enabled' => true,
				'show_title' => true,
			),
			'product_archive_title_elements'      => array( 'title', 'breadcrumb', 'description' ),
			'woo_account_navigation_layout' => 'left',
			'product_archive_button_style' => 'text',
		);
		$defaults = array_merge(
			$defaults,
			$update_options
		);
		return $defaults;
	}
	public function add_addon_option_defaults( $defaults ) {
		$addon_update_options = array(
		'header_button_size' =>('custom'),
		'header_button_padding'   => array(
			'size'   => array( '15', '33', '15', '33' ),
			'unit'   => 'px',
			'locked' => false,
		),
		'header_button_typography' => array(
			'size' => array(
				'desktop' => '15',
			),
			'lineHeight' => array(
				'desktop' => '25',
			),
			'letterSpacing' => array(
				'desktop' => '0.3',
			),
			'lineType' =>  'px',
			'spacingType'=> 'px',
			'family'  => 'inherit',
			'google'  => false,
			'weight'  => '',
			'variant' => '',
		),
		'header_button_color'              => array(
			'color' => 'palette9',
			'hover' => '',
		),
		'header_button_background'              => array(
			'color' => '',
			'hover' => 'palette2',
		),
		// Header Contact.
		'header_contact_items' => array(
			'items' => array(
				array(
					'id'      => 'phone',
					'enabled' => true,
					'source'  => 'icon',
					'url'     => '',
					'imageid' => '',
					'width'   => 24,
					'link'     => '',
					'icon'    => 'phone',
					'label'   => '+1-2345-2345-54',
				),
				array(
					'id'      => 'email',
					'enabled' => true,
					'source'  => 'icon',
					'url'     => '',
					'imageid' => '',
					'width'   => 24,
					'link'     => '',
					'icon'    => 'email',
					'label'   => 'example@gmail.com',
				),
				array(
					'id'      => 'hours',
					'enabled' => true,
					'source'  => 'icon',
					'url'     => '',
					'imageid' => '',
					'width'   => 24,
					'link'     => '',
					'icon'    => 'hours',
					'label'   => 'Mon - Fri: 09:00 - 17:00',
				),
			),
		),
		'header_contact_item_spacing' => array(
			'size' => 30,
			'unit' => 'px',
		),
		'header_contact_icon_size' => array(
			'size' => '1.3',
			'unit' => 'em',
		),
		'header_contact_color' => array(
			'color' => 'palette1',
			'hover' => '',
		),	
		'header_contact_typography'	=> array(
			'size' => array(
				'desktop' => '14',
			),
		),
		);
		$defaults = array_merge(
			$defaults,
			$addon_update_options
		);
		return $defaults;
	}
}

Custom_Theme::get_instance();
