<?php
/**
 * NGO Social Services functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package NGO Social Services
 */

if ( ! defined( 'CHARITY_ZONE_URL' ) ) {
    define( 'CHARITY_ZONE_URL', esc_url( 'https://www.themagnifico.net/themes/social-services-wordpress-theme/', 'ngo-social-services') );
}
if ( ! defined( 'CHARITY_ZONE_TEXT' ) ) {
    define( 'CHARITY_ZONE_TEXT', __( 'Social Services Pro','ngo-social-services' ));
}
if ( ! defined( 'CHARITY_ZONE_BUY_TEXT' ) ) {
    define( 'CHARITY_ZONE_BUY_TEXT', __( 'Buy NGO Social Services Pro','ngo-social-services' ));
}

function ngo_social_services_enqueue_styles() {
    wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');
    $ngo_social_services_parentcss = 'charity-zone-style';
    $ngo_social_services_theme = wp_get_theme(); wp_enqueue_style( $ngo_social_services_parentcss, get_template_directory_uri() . '/style.css', array(), $ngo_social_services_theme->parent()->get('Version'));
    wp_enqueue_style( 'ngo-social-services-style', get_stylesheet_uri(), array( $ngo_social_services_parentcss ), $ngo_social_services_theme->get('Version'));

    wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true );
}

add_action( 'wp_enqueue_scripts', 'ngo_social_services_enqueue_styles' );

function ngo_social_services_admin_scripts() {
    // demo CSS
    wp_enqueue_style( 'ngo-social-services-demo-css', get_theme_file_uri( 'assets/css/demo.css' ) );
}
add_action( 'admin_enqueue_scripts', 'ngo_social_services_admin_scripts' );

/**
 * Enqueue theme color style.
 */
function ngo_social_services_theme_color() {

    $ngo_social_services_theme_color_css = '';
    $charity_zone_theme_color = get_theme_mod('charity_zone_theme_color');
    $charity_zone_theme_color_2 = get_theme_mod('charity_zone_theme_color_2');
    $charity_zone_preloader_bg_color = get_theme_mod('charity_zone_preloader_bg_color');
    $charity_zone_preloader_dot_1_color = get_theme_mod('charity_zone_preloader_dot_1_color');
    $charity_zone_preloader_dot_2_color = get_theme_mod('charity_zone_preloader_dot_2_color');

    if(get_theme_mod('charity_zone_preloader_bg_color') == '') {
        $charity_zone_preloader_bg_color = '#000';
    }
    if(get_theme_mod('charity_zone_preloader_dot_1_color') == '') {
        $charity_zone_preloader_dot_1_color = '#fff';
    }
    if(get_theme_mod('charity_zone_preloader_dot_2_color') == '') {
        $charity_zone_preloader_dot_2_color = '#03b664';
    }

    $ngo_social_services_theme_color_css = '
        .navbar-brand, .sticky .entry-title::before, .donate-btn a, .main-navigation .menu > li > a:hover, .main-navigation .sub-menu, #button, .sidebar input[type="submit"], .comment-respond input#submit, .post-navigation .nav-previous a:hover, .post-navigation .nav-next a:hover, posts-navigation .nav-previous a:hover, .posts-navigation .nav-next a:hover, .woocommerce .woocommerce-ordering select, .woocommerce ul.products li.product .onsale, .woocommerce span.onsale, .pro-button a, .woocommerce #respond input#submit, .woocommerce a.button,.woocommerce input.button, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce input.button.alt, .wp-block-button__link, .serv-box:hover, .woocommerce-account .woocommerce-MyAccount-navigation ul li, .btn-primary, .toggle-nav.mobile-menu button,.sidebar button[type="submit"],.sidebar .tagcloud a:hover,a.added_to_cart.wc-forward{
                background: '.esc_attr($charity_zone_theme_color).';
        }
        @media screen and (min-width: 320px) and (max-width: 1000px)
      		.sidenav {
      				background: '.esc_attr($charity_zone_theme_color).';
      		}
        .woocommerce button.button, woocommerce button.button.alt,thead{
                background: '.esc_attr($charity_zone_theme_color).'!important;
        }
        a,.sidebar a:hover, #colophon a:hover,#colophon a:focus, p.price, .woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce div.product span.price, .woocommerce-message::before, .woocommerce-info::before,.donate-btn a:hover,.causes-inner-box li a {
            color: '.esc_attr($charity_zone_theme_color).';
        }
        .woocommerce-message, .woocommerce-info,.wp-block-pullquote,.wp-block-quote, .wp-block-quote:not(.is-large):not(.is-style-large), .wp-block-pullquote,.btn-primary,#causes-sec h3{
            border-color: '.esc_attr($charity_zone_theme_color).' !important;
        }
        .sidebar h5,#button:active,#button:hover,.donate-btn a:hover,.socialmedia,#colophon,.main-navigation .sub-menu > li > a:hover, .main-navigation .sub-menu > li > a:focus{
                background: '.esc_attr($charity_zone_theme_color_2).';
        }
        .woocommerce button.button:hover, woocommerce button.button.alt:hover{
                background: '.esc_attr($charity_zone_theme_color_2).'!important;
        }
        a:hover, h1, h2, h3, h4, h5, h6,.main-navigation .menu > li > a,{
                color: '.esc_attr($charity_zone_theme_color_2).';
        }
       .wp-block-quote, .wp-block-quote:not(.is-large):not(.is-style-large),.wp-block-pullquote,.btn-primary {
                border-color: '.esc_attr($charity_zone_theme_color_2).'!important;
        }
        .loading{
            background-color: '.esc_attr($charity_zone_preloader_bg_color).';
         }
         @keyframes loading {
          0%,
          100% {
            transform: translatey(-2.5rem);
            background-color: '.esc_attr($charity_zone_preloader_dot_1_color).';
          }
          50% {
            transform: translatey(2.5rem);
            background-color: '.esc_attr($charity_zone_preloader_dot_2_color).';
          }
        }
    ';
    wp_add_inline_style( 'ngo-social-services-style',$ngo_social_services_theme_color_css );

}
add_action( 'wp_enqueue_scripts', 'ngo_social_services_theme_color' );

function ngo_social_services_customize_register($wp_customize){

    // Pro Version
    class Ngo_Social_Services_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>For More <strong>'. esc_html( $this->label ) .'</strong>?</span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( CHARITY_ZONE_BUY_TEXT,'ngo-social-services' ) .'<strong></a>';
            echo '</a>';
        }
    }

    //Our Causes section
    $wp_customize->add_section( 'ngo_social_services_causes_section' , array(
        'title'      => __( 'Causes Settings', 'ngo-social-services' ),
        'priority'   => null
    ) );

    $wp_customize->add_setting('ngo_social_services_causes_setting', array(
        'default' => false,
        'sanitize_callback' => 'charity_zone_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'ngo_social_services_causes_setting',array(
        'label'          => __( 'Enable Disable Causes', 'ngo-social-services' ),
        'section'        => 'ngo_social_services_causes_section',
        'settings'       => 'ngo_social_services_causes_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('ngo_social_services_causes_title', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('ngo_social_services_causes_title', array(
        'label' => __('Section Title', 'ngo-social-services'),
        'section' => 'ngo_social_services_causes_section',
        'type' => 'text',
    ));

    $wp_customize->add_setting('ngo_social_services_causes_text', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('ngo_social_services_causes_text', array(
        'label' => __('Section Text', 'ngo-social-services'),
        'section' => 'ngo_social_services_causes_section',
        'type' => 'text',
    ));

    $ngo_social_services_categories = get_categories();
    $ngo_social_services_cat_post = array();
    $ngo_social_services_cat_post[]= 'select';
    $i = 0;
    foreach($ngo_social_services_categories as $category){
        if($i==0){
            $default = $category->slug;
            $i++;
        }
        $ngo_social_services_cat_post[$category->slug] = $category->name;
    }

    $wp_customize->add_setting('ngo_social_services_causes',array(
        'default'   => 'select',
        'sanitize_callback' => 'charity_zone_sanitize_choices',
    ));
    $wp_customize->add_control('ngo_social_services_causes',array(
        'type'    => 'select',
        'choices' => $ngo_social_services_cat_post,
        'label' => __('Select Category to Display Causes','ngo-social-services'),
        'section' => 'ngo_social_services_causes_section',
    ));

     // Pro Version
    $wp_customize->add_setting( 'pro_version_services_causes', array(
        'sanitize_callback' => 'Charity_Zone_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Ngo_Social_Services_Customize_Pro_Version ( $wp_customize,'pro_version_services_causes', array(
        'section'     => 'ngo_social_services_causes_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Customizer Options', 'ngo-social-services' ),
        'description' => esc_url( CHARITY_ZONE_URL ),
        'priority'    => 100
    )));

}
add_action('customize_register', 'ngo_social_services_customize_register');

if ( ! function_exists( 'ngo_social_services_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function ngo_social_services_setup() {

        add_theme_support( 'responsive-embeds' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        add_image_size('ngo-social-services-featured-header-image', 2000, 660, true);

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );

        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'charity_zone_custom_background_args', array(
            'default-color' => '',
            'default-image' => '',
        ) ) );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support( 'custom-logo', array(
            'height'      => 50,
            'width'       => 50,
            'flex-width'  => true,
        ) );

        add_editor_style( array( '/editor-style.css' ) );

        add_theme_support( 'align-wide' );

        add_theme_support( 'wp-block-styles' );
    }
endif;
add_action( 'after_setup_theme', 'ngo_social_services_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ngo_social_services_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'ngo-social-services' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'ngo-social-services' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h5 class="widget-title">',
        'after_title'   => '</h5>',
    ) );

}
add_action( 'widgets_init', 'ngo_social_services_widgets_init' );

if ( ! defined( 'CHARITY_ZONE_CONTACT_SUPPORT' ) ) {
define('CHARITY_ZONE_CONTACT_SUPPORT',__('https://wordpress.org/support/theme/ngo-social-services','ngo-social-services'));
}
if ( ! defined( 'CHARITY_ZONE_REVIEW' ) ) {
define('CHARITY_ZONE_REVIEW',__('https://wordpress.org/support/theme/ngo-social-services/reviews/#new-post','ngo-social-services'));
}
if ( ! defined( 'CHARITY_ZONE_LIVE_DEMO' ) ) {
define('CHARITY_ZONE_LIVE_DEMO',__('https://themagnifico.net/demo/social-services/','ngo-social-services'));
}
if ( ! defined( 'CHARITY_ZONE_GET_PREMIUM_PRO' ) ) {
define('CHARITY_ZONE_GET_PREMIUM_PRO',__('https://www.themagnifico.net/themes/social-services-wordpress-theme/','ngo-social-services'));
}
if ( ! defined( 'CHARITY_ZONE_PRO_DOC' ) ) {
define('CHARITY_ZONE_PRO_DOC',__('https://www.themagnifico.net/eard/wathiqa/charity-pro-doc/','ngo-social-services'));
}
