<?php
/**
 * Displays top navigation
 *
 * @package NGO Non Profit
 */
?>

<div class="container">
    <div class="row">
        <div class="col-lg-3 col-md-3 self-align">
            <div class="navbar-brand">
                <?php if ( has_custom_logo() ) : ?>
                    <div class="site-logo"><?php the_custom_logo(); ?></div>
                <?php endif; ?>
                <?php $ngo_non_profit_blog_info = get_bloginfo( 'name' ); ?>
                    <?php if ( ! empty( $ngo_non_profit_blog_info ) ) : ?>
                        <?php if ( is_front_page() && is_home() ) : ?>
                          <?php if( get_theme_mod('charity_zone_logo_title_text',true) != ''){ ?>
                            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                            <?php } ?>
                        <?php else : ?>
                          <?php if( get_theme_mod('charity_zone_logo_title_text',true) != ''){ ?>
                            <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                            <?php } ?>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php
                        $ngo_non_profit_description = get_bloginfo( 'description', 'display' );
                        if ( $ngo_non_profit_description || is_customize_preview() ) :
                    ?>
                    <?php if( get_theme_mod('charity_zone_theme_description',false) != ''){ ?>
                    <p class="site-description"><?php echo esc_html($ngo_non_profit_description); ?></p>
                  <?php } ?>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-lg-7 col-md-6 col-4 self-align">
            <div class="toggle-nav mobile-menu">
                <?php if(has_nav_menu('primary')){ ?>
                    <button onclick="charity_zone_openNav()" class="mobiletoggle"><i class="fas fa-bars"></i></button>
                <?php }?>
            </div>
            <div id="mySidenav" class="nav sidenav">
                <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'ngo-non-profit' ); ?>">
                    <?php if(has_nav_menu('primary')){
                        wp_nav_menu(
                            array(
                                'theme_location' => 'primary',
                                'menu_class'     => 'menu',
                                'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                            )
                        );
                    } ?>
                </nav>
                <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="charity_zone_closeNav()"><i class="fas fa-times"></i></a>
            </div>
        </div>
        <div class="col-lg-2 col-md-3 col-8 donate-btn self-align">
            <?php if(get_theme_mod('charity_zone_donate_button') != ''){ ?>
                <a href="<?php echo esc_url(get_theme_mod('charity_zone_donate_button','')); ?>"><?php esc_html_e('Donate Now','ngo-non-profit'); ?></a>
            <?php }?>
        </div>
    </div>
</div>
