<?php
/**
 * NGO Non Profit functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package NGO Non Profit
 */

if ( ! defined( 'CHARITY_ZONE_URL' ) ) {
    define( 'CHARITY_ZONE_URL', esc_url( 'https://www.themagnifico.net/themes/nonprofit-wordpress-theme/', 'ngo-non-profit') );
}
if ( ! defined( 'CHARITY_ZONE_TEXT' ) ) {
    define( 'CHARITY_ZONE_TEXT', __( 'NGO Non Profit Pro','ngo-non-profit' ));
}
if ( ! defined( 'CHARITY_ZONE_CONTACT_SUPPORT' ) ) {
define('CHARITY_ZONE_CONTACT_SUPPORT',__('https://wordpress.org/support/theme/ngo-non-profit','ngo-non-profit'));
}
if ( ! defined( 'CHARITY_ZONE_REVIEW' ) ) {
define('CHARITY_ZONE_REVIEW',__('https://wordpress.org/support/theme/ngo-non-profit/reviews/#new-post','ngo-non-profit'));
}
if ( ! defined( 'CHARITY_ZONE_LIVE_DEMO' ) ) {
define('CHARITY_ZONE_LIVE_DEMO',__('https://www.themagnifico.net/demo/ngo-nonprofit/','ngo-non-profit'));
}
if ( ! defined( 'CHARITY_ZONE_GET_PREMIUM_PRO' ) ) {
define('CHARITY_ZONE_GET_PREMIUM_PRO',__('https://www.themagnifico.net/themes/nonprofit-wordpress-theme/','ngo-non-profit'));
}
if ( ! defined( 'CHARITY_ZONE_PRO_DOC' ) ) {
define('CHARITY_ZONE_PRO_DOC',__('https://www.themagnifico.net/eard/wathiqa/ngo-nonprofit-pro-doc/','ngo-non-profit'));
}
if ( ! defined( 'CHARITY_ZONE_BUY_TEXT' ) ) {
    define( 'CHARITY_ZONE_BUY_TEXT', __( 'Buy NGO Non Profit Pro','ngo-non-profit' ));
}


function ngo_non_profit_enqueue_styles() {
    wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri()) . '/assets/css/bootstrap.css');
    $ngo_non_profit_parentcss = 'ngo-non-profit-style';
    $ngo_non_profit_theme = wp_get_theme(); wp_enqueue_style( $ngo_non_profit_parentcss, get_template_directory_uri() . '/style.css', array(), $ngo_non_profit_theme->parent()->get('Version'));
    wp_enqueue_style( 'ngo-non-profit-style', get_stylesheet_uri(), array( $ngo_non_profit_parentcss ), $ngo_non_profit_theme->get('Version'));

    wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true );
}

add_action( 'wp_enqueue_scripts', 'ngo_non_profit_enqueue_styles' );

function ngo_non_profit_admin_scripts() {
    // demo CSS
    wp_enqueue_style( 'ngo-non-profit-demo-css', get_theme_file_uri( 'assets/css/demo.css' ) );
}
add_action( 'admin_enqueue_scripts', 'ngo_non_profit_admin_scripts' );

if ( ! function_exists( 'ngo_non_profit_setup' ) ) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function ngo_non_profit_setup() {

        add_theme_support( 'responsive-embeds' );

        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support( 'title-tag' );

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support( 'post-thumbnails' );

        add_image_size('ngo-non-profit-featured-header-image', 2000, 660, true);

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         * to output valid HTML5.
         */
        add_theme_support( 'html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ) );

        // Set up the WordPress core custom background feature.
        add_theme_support( 'custom-background', apply_filters( 'charity_zone_custom_background_args', array(
            'default-color' => '',
            'default-image' => '',
        ) ) );

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support( 'custom-logo', array(
            'height'      => 50,
            'width'       => 50,
            'flex-width'  => true,
        ) );

        add_editor_style( array( '/editor-style.css' ) );

        add_theme_support( 'align-wide' );

        add_theme_support( 'wp-block-styles' );
    }
endif;
add_action( 'after_setup_theme', 'ngo_non_profit_setup' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ngo_non_profit_widgets_init() {
    register_sidebar( array(
        'name'          => esc_html__( 'Sidebar', 'ngo-non-profit' ),
        'id'            => 'sidebar-1',
        'description'   => esc_html__( 'Add widgets here.', 'ngo-non-profit' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h5 class="widget-title">',
        'after_title'   => '</h5>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 1', 'ngo-non-profit' ),
        'id'            => 'charity-zone-footer1',
        'description'   => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h5 class="footer-column-widget-title">',
        'after_title'   => '</h5>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 2', 'ngo-non-profit' ),
        'id'            => 'charity-zone-footer2',
        'description'   => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h5 class="footer-column-widget-title">',
        'after_title'   => '</h5>',
    ) );

    register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 3', 'ngo-non-profit' ),
        'id'            => 'charity-zone-footer3',
        'description'   => '',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h5 class="footer-column-widget-title">',
        'after_title'   => '</h5>',
    ) );
}
add_action( 'widgets_init', 'ngo_non_profit_widgets_init' );

function ngo_non_profit_sanitize_image( $file, $setting ) {

    $ngo_non_profit_mimes = array(
        'jpg|jpeg|jpe' => 'image/jpeg',
        'gif'          => 'image/gif',
        'png'          => 'image/png',
        'bmp'          => 'image/bmp',
        'tif|tiff'     => 'image/tiff',
        'ico'          => 'image/x-icon'
    );

    //check file type from file name
    $file_ext = wp_check_filetype( $file, $ngo_non_profit_mimes );

    //if file has a valid mime type return it, otherwise return default
    return ( $file_ext['ext'] ? $file : $setting->default );
}
