<?php
/*
Author: Fiona Coulter
Author URI: https://spiralscripts.co.uk
License: GPL v2
*/

if(! defined('SPIRALFACTCHECKLINKS'))
{
	exit();
}

Class SpiralFactCheckHTMLHelper{
	
	
	  public static function getHTML($layout, $view = null)
	  {
		  // Fetch the template
		  ob_start();
		  $tmplPath =  SPIRALFACTCHECKLINKS_PLUGIN_PATH. 'html'. DIRECTORY_SEPARATOR . $layout;
		  include($tmplPath);
		  $output =  ob_get_contents();
		  ob_end_clean();
		  return $output;
	  }
	  
	  public static function getTemplateOutput($layout, $view = null)
	  {
		  // Fetch the template
		  ob_start();
		  $tmplPath =  SPIRALFACTCHECKLINKS_PLUGIN_PATH. 'tmpl'. DIRECTORY_SEPARATOR . $layout;
		  include($tmplPath);
		  $output =  ob_get_contents();
		  ob_end_clean();
		  return $output;
	  }
	  
	  
	  public static function validateFormField(&$field)
	  {
		  if(empty($field->value))
		  {
			  $field->value = $field->default;
		  }
		  
		  if($field->type == 'text')
		  {
			  $field->value = call_user_func($field->validate, $field->value);  
			  //this will call the correct validation function, eg sanitize_text_field as defined in the options definition
		  }
		  elseif($field->type == 'select')
		  {
			  $optionValues = FactCheckDefinitionsHelper::getOptionValues($field->validate);
			  
			  if(! array_key_exists($field->value, $optionValues))
			  {
				  $field->value = $field->default;
			  }
			  
			  $field->value = sanitize_text_field($field->value); //lets sanitize it again anyway, although not really necessary
		  }
	  }
	  
	  public static function getFormField($key, $field)
	  {
		  $output = "";
		  
		  		  
		  if($field->type == 'text')
		  {
			  $output = self::getFormTextField($key, $field);
		  }
		  elseif($field->type == 'select')
		  {
			  $output = self::getFormSelectField($key, $field);
		  }
		  
		  return $output;

	  }

	  public static function getFormTextField($key, &$field)
	  {
		  $output = '<label for="'. $key .'">'. $field->label .'</label>';
		  $output .= '<input type="text" name="'. $key .'" id="'. $id .'" value= "'. $field->value . '" />';
          return $output;

	  }
	

	  public static function getFormSelectField($key, &$field)
	  {
		  $output = '<label for="'.$key.'">'. $field->label . '</label>';
		  $output .= '<select name="'. $key .'" id="'. $id .'">';
		  
		  $optionValues = FactCheckDefinitionsHelper::getOptionValues($field->validate);
		  
		  
		  foreach($optionValues as $option => $text)
		  {
			 $output .= '<option value="'. $option .'" ';
			 if($option == $field->value)
			 {
				 $output .= 'selected="selected" ';
			 }
			 $output .= '>'. $text .'</option>';
			  
		  }
		  $output .= '</select>';
		  
		  return $output;

	  }
	


}


?>