<?php

/*
Author: Fiona Coulter
Author URI: https://spiralscripts.co.uk
License: GPL v2
*/


if(! defined('SPIRALFACTCHECKLINKS'))
{
	exit();
}

Class SpiralFactCheckAdmin{
	
	function __construct()
	{
		  add_action('admin_menu', array($this, 'spiral_fact_check_admin_menu'));
		  add_action('admin_init', array($this, 'spiral_fact_check_admin_init'));
		  //add_action('wp_enqueue_scripts', array($this, 'spiral_fact_check_admin_queue_stylesheet'));
		  
				
	}
	
	function spiral_fact_check_admin_init()
	{
		add_action('admin_post_spiral_fact_check_save_options', array($this, 'spiral_fact_check_admin_save_options'));
		wp_enqueue_style('factcheckdminstyle', plugins_url('assets/css/admin-stylesheet.css', __FILE__));  
		wp_enqueue_script('jquery');
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('factcheckdminscripts', plugins_url('assets/js/repeatable-fields.js', __FILE__));  
	
	}
	
	function spiral_fact_check_admin_queue_stylesheet()
	{
		//wp_enqueue_style('fcadminshortcodestyle', plugins_url('assets/css/admin-stylesheet.css', __FILE__));  
		
	}
	
	
	function spiral_fact_check_admin_save_options()
	{
		
		if(!current_user_can('manage_options'))
		{
			wp_die('Not allowed');
		}
		
		//good opportunity to flush rewrite rules
		global $wp_rewrite;
		$wp_rewrite->flush_rules();
		
		check_admin_referer('spiral_f_c');
		
		$options = get_option('spiral_fact_check_options', array());	
		$default_options = FactCheckDefinitionsHelper::$options;
				
		
		foreach($default_options as $key => $opt)
		{
			if(isset($_POST[$key]))
			{
				 $field = new stdClass();
				 $field->value = $_POST[$key]; //please note that this is validated below
				 $field->type = $opt[1];
				 $field->default = $opt[2];
				 $field->validate = $opt[3];
				 SpiralFactCheckHTMLHelper::validateFormField($field); //please note that this function validates the value
				 $options[$key] = $field->value;
			}
		}
		
		update_option('spiral_fact_check_options', $options);
		
		wp_redirect( add_query_arg(array('page' => 'spiral-fact-check-sub-menu', 'message' => '1'), admin_url('admin.php')));
		exit();
	}
	
	
	function spiral_fact_check_admin_menu()
	{
	  global $submenu;
	  //create top level menu item
	  add_menu_page('Fact Check Main Page', 'Fact Check', 'manage_options', 'spiral-fact-check-main-menu', 'spiral_fact_check_main', plugins_url('fact-check.png', __FILE__));
	  
	  
	  
	  //create a sub-menu under the top-level-menu
	  add_submenu_page( 'spiral-fact-check-main-menu', 'Settings and Options and Options Page', 'Settings', 'manage_options', 'spiral-fact-check-sub-menu', 'spiral_fact_check_submenu');
	  	  
	  $entries_url = admin_url('edit.php?post_type=fact_checks');
	  $submenu['spiral-fact-check-main-menu'][] = array('Fact Checks', 'manage_options', $entries_url);



	 // $faq_url = "https://www.spiralscripts.co.uk/support/faq.html";
	 // $submenu['spiral-fact-check-main-menu'][] = array('FAQ', 'manage_options', $faq_url);
	  
	  $support_url = "https://www.spiralscripts.co.uk/support/forum/fact-checker-plugin.html";
	  $submenu['spiral-fact-check-main-menu'][] = array('Support', 'manage_options', $support_url);
	  
	  
	  function spiral_fact_check_main()
	  {
		echo SpiralFactCheckHTMLHelper::getHTML('welcome.php');
	  
	  
	  }
	  
	  function spiral_fact_check_submenu()
	  {		
		 $view = new stdClass();
		 $view->message = "";
		 
	     if(isset($_GET['message']) && $_GET['message'] == '1')
		 {
			 $view->message = '<div id="message" class="updated fade"><p><strong>Settings Saved</strong></p></div>';
		 }
		 
		 $view->options = FactCheckDefinitionsHelper::getOptions();
		 $fields = FactCheckDefinitionsHelper::$options;
		 
		 $view->fields = array();
		 
		 foreach($fields as $key => $opt)
		 {
			 $field = new stdClass();
			 $field->label = $opt[0];
			 if(isset($view->options[$key]))
			 {
				 $field->value = $view->options[$key];
			 }
			 else
			 {
				 $field->value = $opt[2];
			 }
			 $field->name = $key;
			 $field->type = $opt[1];
			 $field->default = $opt[2];
			 $field->validate = $opt[3];
			 SpiralFactCheckHTMLHelper::validateFormField($field);
			 $html = SpiralFactCheckHTMLHelper::getFormField($key, $field);
			 $view->fields[$key] = $html;
		 }
		 
		 echo SpiralFactCheckHTMLHelper::getHTML('settings.php', $view);		 
	  
	  }	  	
	
  }  //end spiral_fact_check_admin_menu


}



$SpiralFactCheckAdmin = new SpiralFactCheckAdmin();


?>