<?php
/**
 * FontAwesome Icons for Themify Icon Picker
 * @link http://fontawesome.io/
 */
class Themify_Icon_Picker_FontAwesome extends Themify_Icon_Picker_Font {
	function get_id() {
		return 'fontawesome';
	}

	function get_label() {
		return __( 'FontAwesome', 'themify' );
	}

	/**
	 * Check if the icon name belongs to the Themify icon font
	 * Assumes yes, if the icon name has "fa-" prefix
	 *
	 * @return bool
	 */
	function is_valid_icon( $name ) {
		$prefix = substr( $name , 0, 4 );
		return 
			strpos( $name, 'fa-' ) === 0 // FA v4
			|| in_array( $prefix, array( 'fas ', 'far ', 'fab ' ) ) // FA v5
		;
	}

	function get_classname( $icon ) {
		/* FA 5.0 has its own prefix */
		$prefix = substr( $icon , 0, 4 );
		if ( in_array( $prefix, array( 'fas ', 'far ', 'fab ' ) ) ) {
			return $icon;
		} else {
			/* FA v4 compatibility */
			return "fa {$icon}";
		}
	}

	function get_icons() {
		return array(
			array(
				'key' => 'solid',
				'label' => __( 'Solid', 'themify' ),
				'icons' => array(
					'fas fa-ad' => 'ad',
					'fas fa-address-book' => 'address-book',
					'fas fa-address-card' => 'address-card',
					'fas fa-adjust' => 'adjust',
					'fas fa-air-freshener' => 'air-freshener',
					'fas fa-align-center' => 'align-center',
					'fas fa-align-justify' => 'align-justify',
					'fas fa-align-left' => 'align-left',
					'fas fa-align-right' => 'align-right',
					'fas fa-allergies' => 'allergies',
					'fas fa-ambulance' => 'ambulance',
					'fas fa-american-sign-language-interpreting' => 'american-sign-language-interpreting',
					'fas fa-anchor' => 'anchor',
					'fas fa-angle-double-down' => 'angle-double-down',
					'fas fa-angle-double-left' => 'angle-double-left',
					'fas fa-angle-double-right' => 'angle-double-right',
					'fas fa-angle-double-up' => 'angle-double-up',
					'fas fa-angle-down' => 'angle-down',
					'fas fa-angle-left' => 'angle-left',
					'fas fa-angle-right' => 'angle-right',
					'fas fa-angle-up' => 'angle-up',
					'fas fa-angry' => 'angry',
					'fas fa-ankh' => 'ankh',
					'fas fa-apple-alt' => 'apple-alt',
					'fas fa-archive' => 'archive',
					'fas fa-archway' => 'archway',
					'fas fa-arrow-alt-circle-down' => 'arrow-alt-circle-down',
					'fas fa-arrow-alt-circle-left' => 'arrow-alt-circle-left',
					'fas fa-arrow-alt-circle-right' => 'arrow-alt-circle-right',
					'fas fa-arrow-alt-circle-up' => 'arrow-alt-circle-up',
					'fas fa-arrow-circle-down' => 'arrow-circle-down',
					'fas fa-arrow-circle-left' => 'arrow-circle-left',
					'fas fa-arrow-circle-right' => 'arrow-circle-right',
					'fas fa-arrow-circle-up' => 'arrow-circle-up',
					'fas fa-arrow-down' => 'arrow-down',
					'fas fa-arrow-left' => 'arrow-left',
					'fas fa-arrow-right' => 'arrow-right',
					'fas fa-arrow-up' => 'arrow-up',
					'fas fa-arrows-alt' => 'arrows-alt',
					'fas fa-arrows-alt-h' => 'arrows-alt-h',
					'fas fa-arrows-alt-v' => 'arrows-alt-v',
					'fas fa-assistive-listening-systems' => 'assistive-listening-systems',
					'fas fa-asterisk' => 'asterisk',
					'fas fa-at' => 'at',
					'fas fa-atlas' => 'atlas',
					'fas fa-atom' => 'atom',
					'fas fa-audio-description' => 'audio-description',
					'fas fa-award' => 'award',
					'fas fa-baby' => 'baby',
					'fas fa-baby-carriage' => 'baby-carriage',
					'fas fa-backspace' => 'backspace',
					'fas fa-backward' => 'backward',
					'fas fa-bacon' => 'bacon',
					'fas fa-balance-scale' => 'balance-scale',
					'fas fa-ban' => 'ban',
					'fas fa-band-aid' => 'band-aid',
					'fas fa-barcode' => 'barcode',
					'fas fa-bars' => 'bars',
					'fas fa-baseball-ball' => 'baseball-ball',
					'fas fa-basketball-ball' => 'basketball-ball',
					'fas fa-bath' => 'bath',
					'fas fa-battery-empty' => 'battery-empty',
					'fas fa-battery-full' => 'battery-full',
					'fas fa-battery-half' => 'battery-half',
					'fas fa-battery-quarter' => 'battery-quarter',
					'fas fa-battery-three-quarters' => 'battery-three-quarters',
					'fas fa-bed' => 'bed',
					'fas fa-beer' => 'beer',
					'fas fa-bell' => 'bell',
					'fas fa-bell-slash' => 'bell-slash',
					'fas fa-bezier-curve' => 'bezier-curve',
					'fas fa-bible' => 'bible',
					'fas fa-bicycle' => 'bicycle',
					'fas fa-binoculars' => 'binoculars',
					'fas fa-biohazard' => 'biohazard',
					'fas fa-birthday-cake' => 'birthday-cake',
					'fas fa-blender' => 'blender',
					'fas fa-blender-phone' => 'blender-phone',
					'fas fa-blind' => 'blind',
					'fas fa-blog' => 'blog',
					'fas fa-bold' => 'bold',
					'fas fa-bolt' => 'bolt',
					'fas fa-bomb' => 'bomb',
					'fas fa-bone' => 'bone',
					'fas fa-bong' => 'bong',
					'fas fa-book' => 'book',
					'fas fa-book-dead' => 'book-dead',
					'fas fa-book-medical' => 'book-medical',
					'fas fa-book-open' => 'book-open',
					'fas fa-book-reader' => 'book-reader',
					'fas fa-bookmark' => 'bookmark',
					'fas fa-bowling-ball' => 'bowling-ball',
					'fas fa-box' => 'box',
					'fas fa-box-open' => 'box-open',
					'fas fa-boxes' => 'boxes',
					'fas fa-braille' => 'braille',
					'fas fa-brain' => 'brain',
					'fas fa-bread-slice' => 'bread-slice',
					'fas fa-briefcase' => 'briefcase',
					'fas fa-briefcase-medical' => 'briefcase-medical',
					'fas fa-broadcast-tower' => 'broadcast-tower',
					'fas fa-broom' => 'broom',
					'fas fa-brush' => 'brush',
					'fas fa-bug' => 'bug',
					'fas fa-building' => 'building',
					'fas fa-bullhorn' => 'bullhorn',
					'fas fa-bullseye' => 'bullseye',
					'fas fa-burn' => 'burn',
					'fas fa-bus' => 'bus',
					'fas fa-bus-alt' => 'bus-alt',
					'fas fa-business-time' => 'business-time',
					'fas fa-calculator' => 'calculator',
					'fas fa-calendar' => 'calendar',
					'fas fa-calendar-alt' => 'calendar-alt',
					'fas fa-calendar-check' => 'calendar-check',
					'fas fa-calendar-day' => 'calendar-day',
					'fas fa-calendar-minus' => 'calendar-minus',
					'fas fa-calendar-plus' => 'calendar-plus',
					'fas fa-calendar-times' => 'calendar-times',
					'fas fa-calendar-week' => 'calendar-week',
					'fas fa-camera' => 'camera',
					'fas fa-camera-retro' => 'camera-retro',
					'fas fa-campground' => 'campground',
					'fas fa-candy-cane' => 'candy-cane',
					'fas fa-cannabis' => 'cannabis',
					'fas fa-capsules' => 'capsules',
					'fas fa-car' => 'car',
					'fas fa-car-alt' => 'car-alt',
					'fas fa-car-battery' => 'car-battery',
					'fas fa-car-crash' => 'car-crash',
					'fas fa-car-side' => 'car-side',
					'fas fa-caret-down' => 'caret-down',
					'fas fa-caret-left' => 'caret-left',
					'fas fa-caret-right' => 'caret-right',
					'fas fa-caret-square-down' => 'caret-square-down',
					'fas fa-caret-square-left' => 'caret-square-left',
					'fas fa-caret-square-right' => 'caret-square-right',
					'fas fa-caret-square-up' => 'caret-square-up',
					'fas fa-caret-up' => 'caret-up',
					'fas fa-carrot' => 'carrot',
					'fas fa-cart-arrow-down' => 'cart-arrow-down',
					'fas fa-cart-plus' => 'cart-plus',
					'fas fa-cash-register' => 'cash-register',
					'fas fa-cat' => 'cat',
					'fas fa-certificate' => 'certificate',
					'fas fa-chair' => 'chair',
					'fas fa-chalkboard' => 'chalkboard',
					'fas fa-chalkboard-teacher' => 'chalkboard-teacher',
					'fas fa-charging-station' => 'charging-station',
					'fas fa-chart-area' => 'chart-area',
					'fas fa-chart-bar' => 'chart-bar',
					'fas fa-chart-line' => 'chart-line',
					'fas fa-chart-pie' => 'chart-pie',
					'fas fa-check' => 'check',
					'fas fa-check-circle' => 'check-circle',
					'fas fa-check-double' => 'check-double',
					'fas fa-check-square' => 'check-square',
					'fas fa-cheese' => 'cheese',
					'fas fa-chess' => 'chess',
					'fas fa-chess-bishop' => 'chess-bishop',
					'fas fa-chess-board' => 'chess-board',
					'fas fa-chess-king' => 'chess-king',
					'fas fa-chess-knight' => 'chess-knight',
					'fas fa-chess-pawn' => 'chess-pawn',
					'fas fa-chess-queen' => 'chess-queen',
					'fas fa-chess-rook' => 'chess-rook',
					'fas fa-chevron-circle-down' => 'chevron-circle-down',
					'fas fa-chevron-circle-left' => 'chevron-circle-left',
					'fas fa-chevron-circle-right' => 'chevron-circle-right',
					'fas fa-chevron-circle-up' => 'chevron-circle-up',
					'fas fa-chevron-down' => 'chevron-down',
					'fas fa-chevron-left' => 'chevron-left',
					'fas fa-chevron-right' => 'chevron-right',
					'fas fa-chevron-up' => 'chevron-up',
					'fas fa-child' => 'child',
					'fas fa-church' => 'church',
					'fas fa-circle' => 'circle',
					'fas fa-circle-notch' => 'circle-notch',
					'fas fa-city' => 'city',
					'fas fa-clinic-medical' => 'clinic-medical',
					'fas fa-clipboard' => 'clipboard',
					'fas fa-clipboard-check' => 'clipboard-check',
					'fas fa-clipboard-list' => 'clipboard-list',
					'fas fa-clock' => 'clock',
					'fas fa-clone' => 'clone',
					'fas fa-closed-captioning' => 'closed-captioning',
					'fas fa-cloud' => 'cloud',
					'fas fa-cloud-download-alt' => 'cloud-download-alt',
					'fas fa-cloud-meatball' => 'cloud-meatball',
					'fas fa-cloud-moon' => 'cloud-moon',
					'fas fa-cloud-moon-rain' => 'cloud-moon-rain',
					'fas fa-cloud-rain' => 'cloud-rain',
					'fas fa-cloud-showers-heavy' => 'cloud-showers-heavy',
					'fas fa-cloud-sun' => 'cloud-sun',
					'fas fa-cloud-sun-rain' => 'cloud-sun-rain',
					'fas fa-cloud-upload-alt' => 'cloud-upload-alt',
					'fas fa-cocktail' => 'cocktail',
					'fas fa-code' => 'code',
					'fas fa-code-branch' => 'code-branch',
					'fas fa-coffee' => 'coffee',
					'fas fa-cog' => 'cog',
					'fas fa-cogs' => 'cogs',
					'fas fa-coins' => 'coins',
					'fas fa-columns' => 'columns',
					'fas fa-comment' => 'comment',
					'fas fa-comment-alt' => 'comment-alt',
					'fas fa-comment-dollar' => 'comment-dollar',
					'fas fa-comment-dots' => 'comment-dots',
					'fas fa-comment-medical' => 'comment-medical',
					'fas fa-comment-slash' => 'comment-slash',
					'fas fa-comments' => 'comments',
					'fas fa-comments-dollar' => 'comments-dollar',
					'fas fa-compact-disc' => 'compact-disc',
					'fas fa-compass' => 'compass',
					'fas fa-compress' => 'compress',
					'fas fa-compress-arrows-alt' => 'compress-arrows-alt',
					'fas fa-concierge-bell' => 'concierge-bell',
					'fas fa-cookie' => 'cookie',
					'fas fa-cookie-bite' => 'cookie-bite',
					'fas fa-copy' => 'copy',
					'fas fa-copyright' => 'copyright',
					'fas fa-couch' => 'couch',
					'fas fa-credit-card' => 'credit-card',
					'fas fa-crop' => 'crop',
					'fas fa-crop-alt' => 'crop-alt',
					'fas fa-cross' => 'cross',
					'fas fa-crosshairs' => 'crosshairs',
					'fas fa-crow' => 'crow',
					'fas fa-crown' => 'crown',
					'fas fa-crutch' => 'crutch',
					'fas fa-cube' => 'cube',
					'fas fa-cubes' => 'cubes',
					'fas fa-cut' => 'cut',
					'fas fa-database' => 'database',
					'fas fa-deaf' => 'deaf',
					'fas fa-democrat' => 'democrat',
					'fas fa-desktop' => 'desktop',
					'fas fa-dharmachakra' => 'dharmachakra',
					'fas fa-diagnoses' => 'diagnoses',
					'fas fa-dice' => 'dice',
					'fas fa-dice-d20' => 'dice-d20',
					'fas fa-dice-d6' => 'dice-d6',
					'fas fa-dice-five' => 'dice-five',
					'fas fa-dice-four' => 'dice-four',
					'fas fa-dice-one' => 'dice-one',
					'fas fa-dice-six' => 'dice-six',
					'fas fa-dice-three' => 'dice-three',
					'fas fa-dice-two' => 'dice-two',
					'fas fa-digital-tachograph' => 'digital-tachograph',
					'fas fa-directions' => 'directions',
					'fas fa-divide' => 'divide',
					'fas fa-dizzy' => 'dizzy',
					'fas fa-dna' => 'dna',
					'fas fa-dog' => 'dog',
					'fas fa-dollar-sign' => 'dollar-sign',
					'fas fa-dolly' => 'dolly',
					'fas fa-dolly-flatbed' => 'dolly-flatbed',
					'fas fa-donate' => 'donate',
					'fas fa-door-closed' => 'door-closed',
					'fas fa-door-open' => 'door-open',
					'fas fa-dot-circle' => 'dot-circle',
					'fas fa-dove' => 'dove',
					'fas fa-download' => 'download',
					'fas fa-drafting-compass' => 'drafting-compass',
					'fas fa-dragon' => 'dragon',
					'fas fa-draw-polygon' => 'draw-polygon',
					'fas fa-drum' => 'drum',
					'fas fa-drum-steelpan' => 'drum-steelpan',
					'fas fa-drumstick-bite' => 'drumstick-bite',
					'fas fa-dumbbell' => 'dumbbell',
					'fas fa-dumpster' => 'dumpster',
					'fas fa-dumpster-fire' => 'dumpster-fire',
					'fas fa-dungeon' => 'dungeon',
					'fas fa-edit' => 'edit',
					'fas fa-egg' => 'egg',
					'fas fa-eject' => 'eject',
					'fas fa-ellipsis-h' => 'ellipsis-h',
					'fas fa-ellipsis-v' => 'ellipsis-v',
					'fas fa-envelope' => 'envelope',
					'fas fa-envelope-open' => 'envelope-open',
					'fas fa-envelope-open-text' => 'envelope-open-text',
					'fas fa-envelope-square' => 'envelope-square',
					'fas fa-equals' => 'equals',
					'fas fa-eraser' => 'eraser',
					'fas fa-ethernet' => 'ethernet',
					'fas fa-euro-sign' => 'euro-sign',
					'fas fa-exchange-alt' => 'exchange-alt',
					'fas fa-exclamation' => 'exclamation',
					'fas fa-exclamation-circle' => 'exclamation-circle',
					'fas fa-exclamation-triangle' => 'exclamation-triangle',
					'fas fa-expand' => 'expand',
					'fas fa-expand-arrows-alt' => 'expand-arrows-alt',
					'fas fa-external-link-alt' => 'external-link-alt',
					'fas fa-external-link-square-alt' => 'external-link-square-alt',
					'fas fa-eye' => 'eye',
					'fas fa-eye-dropper' => 'eye-dropper',
					'fas fa-eye-slash' => 'eye-slash',
					'fas fa-fast-backward' => 'fast-backward',
					'fas fa-fast-forward' => 'fast-forward',
					'fas fa-fax' => 'fax',
					'fas fa-feather' => 'feather',
					'fas fa-feather-alt' => 'feather-alt',
					'fas fa-female' => 'female',
					'fas fa-fighter-jet' => 'fighter-jet',
					'fas fa-file' => 'file',
					'fas fa-file-alt' => 'file-alt',
					'fas fa-file-archive' => 'file-archive',
					'fas fa-file-audio' => 'file-audio',
					'fas fa-file-code' => 'file-code',
					'fas fa-file-contract' => 'file-contract',
					'fas fa-file-csv' => 'file-csv',
					'fas fa-file-download' => 'file-download',
					'fas fa-file-excel' => 'file-excel',
					'fas fa-file-export' => 'file-export',
					'fas fa-file-image' => 'file-image',
					'fas fa-file-import' => 'file-import',
					'fas fa-file-invoice' => 'file-invoice',
					'fas fa-file-invoice-dollar' => 'file-invoice-dollar',
					'fas fa-file-medical' => 'file-medical',
					'fas fa-file-medical-alt' => 'file-medical-alt',
					'fas fa-file-pdf' => 'file-pdf',
					'fas fa-file-powerpoint' => 'file-powerpoint',
					'fas fa-file-prescription' => 'file-prescription',
					'fas fa-file-signature' => 'file-signature',
					'fas fa-file-upload' => 'file-upload',
					'fas fa-file-video' => 'file-video',
					'fas fa-file-word' => 'file-word',
					'fas fa-fill' => 'fill',
					'fas fa-fill-drip' => 'fill-drip',
					'fas fa-film' => 'film',
					'fas fa-filter' => 'filter',
					'fas fa-fingerprint' => 'fingerprint',
					'fas fa-fire' => 'fire',
					'fas fa-fire-alt' => 'fire-alt',
					'fas fa-fire-extinguisher' => 'fire-extinguisher',
					'fas fa-first-aid' => 'first-aid',
					'fas fa-fish' => 'fish',
					'fas fa-fist-raised' => 'fist-raised',
					'fas fa-flag' => 'flag',
					'fas fa-flag-checkered' => 'flag-checkered',
					'fas fa-flag-usa' => 'flag-usa',
					'fas fa-flask' => 'flask',
					'fas fa-flushed' => 'flushed',
					'fas fa-folder' => 'folder',
					'fas fa-folder-minus' => 'folder-minus',
					'fas fa-folder-open' => 'folder-open',
					'fas fa-folder-plus' => 'folder-plus',
					'fas fa-font' => 'font',
					'fas fa-football-ball' => 'football-ball',
					'fas fa-forward' => 'forward',
					'fas fa-frog' => 'frog',
					'fas fa-frown' => 'frown',
					'fas fa-frown-open' => 'frown-open',
					'fas fa-funnel-dollar' => 'funnel-dollar',
					'fas fa-futbol' => 'futbol',
					'fas fa-gamepad' => 'gamepad',
					'fas fa-gas-pump' => 'gas-pump',
					'fas fa-gavel' => 'gavel',
					'fas fa-gem' => 'gem',
					'fas fa-genderless' => 'genderless',
					'fas fa-ghost' => 'ghost',
					'fas fa-gift' => 'gift',
					'fas fa-gifts' => 'gifts',
					'fas fa-glass-cheers' => 'glass-cheers',
					'fas fa-glass-martini' => 'glass-martini',
					'fas fa-glass-martini-alt' => 'glass-martini-alt',
					'fas fa-glass-whiskey' => 'glass-whiskey',
					'fas fa-glasses' => 'glasses',
					'fas fa-globe' => 'globe',
					'fas fa-globe-africa' => 'globe-africa',
					'fas fa-globe-americas' => 'globe-americas',
					'fas fa-globe-asia' => 'globe-asia',
					'fas fa-globe-europe' => 'globe-europe',
					'fas fa-golf-ball' => 'golf-ball',
					'fas fa-gopuram' => 'gopuram',
					'fas fa-graduation-cap' => 'graduation-cap',
					'fas fa-greater-than' => 'greater-than',
					'fas fa-greater-than-equal' => 'greater-than-equal',
					'fas fa-grimace' => 'grimace',
					'fas fa-grin' => 'grin',
					'fas fa-grin-alt' => 'grin-alt',
					'fas fa-grin-beam' => 'grin-beam',
					'fas fa-grin-beam-sweat' => 'grin-beam-sweat',
					'fas fa-grin-hearts' => 'grin-hearts',
					'fas fa-grin-squint' => 'grin-squint',
					'fas fa-grin-squint-tears' => 'grin-squint-tears',
					'fas fa-grin-stars' => 'grin-stars',
					'fas fa-grin-tears' => 'grin-tears',
					'fas fa-grin-tongue' => 'grin-tongue',
					'fas fa-grin-tongue-squint' => 'grin-tongue-squint',
					'fas fa-grin-tongue-wink' => 'grin-tongue-wink',
					'fas fa-grin-wink' => 'grin-wink',
					'fas fa-grip-horizontal' => 'grip-horizontal',
					'fas fa-grip-lines' => 'grip-lines',
					'fas fa-grip-lines-vertical' => 'grip-lines-vertical',
					'fas fa-grip-vertical' => 'grip-vertical',
					'fas fa-guitar' => 'guitar',
					'fas fa-h-square' => 'h-square',
					'fas fa-hamburger' => 'hamburger',
					'fas fa-hammer' => 'hammer',
					'fas fa-hamsa' => 'hamsa',
					'fas fa-hand-holding' => 'hand-holding',
					'fas fa-hand-holding-heart' => 'hand-holding-heart',
					'fas fa-hand-holding-usd' => 'hand-holding-usd',
					'fas fa-hand-lizard' => 'hand-lizard',
					'fas fa-hand-middle-finger' => 'hand-middle-finger',
					'fas fa-hand-paper' => 'hand-paper',
					'fas fa-hand-peace' => 'hand-peace',
					'fas fa-hand-point-down' => 'hand-point-down',
					'fas fa-hand-point-left' => 'hand-point-left',
					'fas fa-hand-point-right' => 'hand-point-right',
					'fas fa-hand-point-up' => 'hand-point-up',
					'fas fa-hand-pointer' => 'hand-pointer',
					'fas fa-hand-rock' => 'hand-rock',
					'fas fa-hand-scissors' => 'hand-scissors',
					'fas fa-hand-spock' => 'hand-spock',
					'fas fa-hands' => 'hands',
					'fas fa-hands-helping' => 'hands-helping',
					'fas fa-handshake' => 'handshake',
					'fas fa-hanukiah' => 'hanukiah',
					'fas fa-hard-hat' => 'hard-hat',
					'fas fa-hashtag' => 'hashtag',
					'fas fa-hat-wizard' => 'hat-wizard',
					'fas fa-haykal' => 'haykal',
					'fas fa-hdd' => 'hdd',
					'fas fa-heading' => 'heading',
					'fas fa-headphones' => 'headphones',
					'fas fa-headphones-alt' => 'headphones-alt',
					'fas fa-headset' => 'headset',
					'fas fa-heart' => 'heart',
					'fas fa-heart-broken' => 'heart-broken',
					'fas fa-heartbeat' => 'heartbeat',
					'fas fa-helicopter' => 'helicopter',
					'fas fa-highlighter' => 'highlighter',
					'fas fa-hiking' => 'hiking',
					'fas fa-hippo' => 'hippo',
					'fas fa-history' => 'history',
					'fas fa-hockey-puck' => 'hockey-puck',
					'fas fa-holly-berry' => 'holly-berry',
					'fas fa-home' => 'home',
					'fas fa-horse' => 'horse',
					'fas fa-horse-head' => 'horse-head',
					'fas fa-hospital' => 'hospital',
					'fas fa-hospital-alt' => 'hospital-alt',
					'fas fa-hospital-symbol' => 'hospital-symbol',
					'fas fa-hot-tub' => 'hot-tub',
					'fas fa-hotdog' => 'hotdog',
					'fas fa-hotel' => 'hotel',
					'fas fa-hourglass' => 'hourglass',
					'fas fa-hourglass-end' => 'hourglass-end',
					'fas fa-hourglass-half' => 'hourglass-half',
					'fas fa-hourglass-start' => 'hourglass-start',
					'fas fa-house-damage' => 'house-damage',
					'fas fa-hryvnia' => 'hryvnia',
					'fas fa-i-cursor' => 'i-cursor',
					'fas fa-ice-cream' => 'ice-cream',
					'fas fa-icicles' => 'icicles',
					'fas fa-id-badge' => 'id-badge',
					'fas fa-id-card' => 'id-card',
					'fas fa-id-card-alt' => 'id-card-alt',
					'fas fa-igloo' => 'igloo',
					'fas fa-image' => 'image',
					'fas fa-images' => 'images',
					'fas fa-inbox' => 'inbox',
					'fas fa-indent' => 'indent',
					'fas fa-industry' => 'industry',
					'fas fa-infinity' => 'infinity',
					'fas fa-info' => 'info',
					'fas fa-info-circle' => 'info-circle',
					'fas fa-italic' => 'italic',
					'fas fa-jedi' => 'jedi',
					'fas fa-joint' => 'joint',
					'fas fa-journal-whills' => 'journal-whills',
					'fas fa-kaaba' => 'kaaba',
					'fas fa-key' => 'key',
					'fas fa-keyboard' => 'keyboard',
					'fas fa-khanda' => 'khanda',
					'fas fa-kiss' => 'kiss',
					'fas fa-kiss-beam' => 'kiss-beam',
					'fas fa-kiss-wink-heart' => 'kiss-wink-heart',
					'fas fa-kiwi-bird' => 'kiwi-bird',
					'fas fa-landmark' => 'landmark',
					'fas fa-language' => 'language',
					'fas fa-laptop' => 'laptop',
					'fas fa-laptop-code' => 'laptop-code',
					'fas fa-laptop-medical' => 'laptop-medical',
					'fas fa-laugh' => 'laugh',
					'fas fa-laugh-beam' => 'laugh-beam',
					'fas fa-laugh-squint' => 'laugh-squint',
					'fas fa-laugh-wink' => 'laugh-wink',
					'fas fa-layer-group' => 'layer-group',
					'fas fa-leaf' => 'leaf',
					'fas fa-lemon' => 'lemon',
					'fas fa-less-than' => 'less-than',
					'fas fa-less-than-equal' => 'less-than-equal',
					'fas fa-level-down-alt' => 'level-down-alt',
					'fas fa-level-up-alt' => 'level-up-alt',
					'fas fa-life-ring' => 'life-ring',
					'fas fa-lightbulb' => 'lightbulb',
					'fas fa-link' => 'link',
					'fas fa-lira-sign' => 'lira-sign',
					'fas fa-list' => 'list',
					'fas fa-list-alt' => 'list-alt',
					'fas fa-list-ol' => 'list-ol',
					'fas fa-list-ul' => 'list-ul',
					'fas fa-location-arrow' => 'location-arrow',
					'fas fa-lock' => 'lock',
					'fas fa-lock-open' => 'lock-open',
					'fas fa-long-arrow-alt-down' => 'long-arrow-alt-down',
					'fas fa-long-arrow-alt-left' => 'long-arrow-alt-left',
					'fas fa-long-arrow-alt-right' => 'long-arrow-alt-right',
					'fas fa-long-arrow-alt-up' => 'long-arrow-alt-up',
					'fas fa-low-vision' => 'low-vision',
					'fas fa-luggage-cart' => 'luggage-cart',
					'fas fa-magic' => 'magic',
					'fas fa-magnet' => 'magnet',
					'fas fa-mail-bulk' => 'mail-bulk',
					'fas fa-male' => 'male',
					'fas fa-map' => 'map',
					'fas fa-map-marked' => 'map-marked',
					'fas fa-map-marked-alt' => 'map-marked-alt',
					'fas fa-map-marker' => 'map-marker',
					'fas fa-map-marker-alt' => 'map-marker-alt',
					'fas fa-map-pin' => 'map-pin',
					'fas fa-map-signs' => 'map-signs',
					'fas fa-marker' => 'marker',
					'fas fa-mars' => 'mars',
					'fas fa-mars-double' => 'mars-double',
					'fas fa-mars-stroke' => 'mars-stroke',
					'fas fa-mars-stroke-h' => 'mars-stroke-h',
					'fas fa-mars-stroke-v' => 'mars-stroke-v',
					'fas fa-mask' => 'mask',
					'fas fa-medal' => 'medal',
					'fas fa-medkit' => 'medkit',
					'fas fa-meh' => 'meh',
					'fas fa-meh-blank' => 'meh-blank',
					'fas fa-meh-rolling-eyes' => 'meh-rolling-eyes',
					'fas fa-memory' => 'memory',
					'fas fa-menorah' => 'menorah',
					'fas fa-mercury' => 'mercury',
					'fas fa-meteor' => 'meteor',
					'fas fa-microchip' => 'microchip',
					'fas fa-microphone' => 'microphone',
					'fas fa-microphone-alt' => 'microphone-alt',
					'fas fa-microphone-alt-slash' => 'microphone-alt-slash',
					'fas fa-microphone-slash' => 'microphone-slash',
					'fas fa-microscope' => 'microscope',
					'fas fa-minus' => 'minus',
					'fas fa-minus-circle' => 'minus-circle',
					'fas fa-minus-square' => 'minus-square',
					'fas fa-mitten' => 'mitten',
					'fas fa-mobile' => 'mobile',
					'fas fa-mobile-alt' => 'mobile-alt',
					'fas fa-money-bill' => 'money-bill',
					'fas fa-money-bill-alt' => 'money-bill-alt',
					'fas fa-money-bill-wave' => 'money-bill-wave',
					'fas fa-money-bill-wave-alt' => 'money-bill-wave-alt',
					'fas fa-money-check' => 'money-check',
					'fas fa-money-check-alt' => 'money-check-alt',
					'fas fa-monument' => 'monument',
					'fas fa-moon' => 'moon',
					'fas fa-mortar-pestle' => 'mortar-pestle',
					'fas fa-mosque' => 'mosque',
					'fas fa-motorcycle' => 'motorcycle',
					'fas fa-mountain' => 'mountain',
					'fas fa-mouse-pointer' => 'mouse-pointer',
					'fas fa-mug-hot' => 'mug-hot',
					'fas fa-music' => 'music',
					'fas fa-network-wired' => 'network-wired',
					'fas fa-neuter' => 'neuter',
					'fas fa-newspaper' => 'newspaper',
					'fas fa-not-equal' => 'not-equal',
					'fas fa-notes-medical' => 'notes-medical',
					'fas fa-object-group' => 'object-group',
					'fas fa-object-ungroup' => 'object-ungroup',
					'fas fa-oil-can' => 'oil-can',
					'fas fa-om' => 'om',
					'fas fa-otter' => 'otter',
					'fas fa-outdent' => 'outdent',
					'fas fa-pager' => 'pager',
					'fas fa-paint-brush' => 'paint-brush',
					'fas fa-paint-roller' => 'paint-roller',
					'fas fa-palette' => 'palette',
					'fas fa-pallet' => 'pallet',
					'fas fa-paper-plane' => 'paper-plane',
					'fas fa-paperclip' => 'paperclip',
					'fas fa-parachute-box' => 'parachute-box',
					'fas fa-paragraph' => 'paragraph',
					'fas fa-parking' => 'parking',
					'fas fa-passport' => 'passport',
					'fas fa-pastafarianism' => 'pastafarianism',
					'fas fa-paste' => 'paste',
					'fas fa-pause' => 'pause',
					'fas fa-pause-circle' => 'pause-circle',
					'fas fa-paw' => 'paw',
					'fas fa-peace' => 'peace',
					'fas fa-pen' => 'pen',
					'fas fa-pen-alt' => 'pen-alt',
					'fas fa-pen-fancy' => 'pen-fancy',
					'fas fa-pen-nib' => 'pen-nib',
					'fas fa-pen-square' => 'pen-square',
					'fas fa-pencil-alt' => 'pencil-alt',
					'fas fa-pencil-ruler' => 'pencil-ruler',
					'fas fa-people-carry' => 'people-carry',
					'fas fa-pepper-hot' => 'pepper-hot',
					'fas fa-percent' => 'percent',
					'fas fa-percentage' => 'percentage',
					'fas fa-person-booth' => 'person-booth',
					'fas fa-phone' => 'phone',
					'fas fa-phone-slash' => 'phone-slash',
					'fas fa-phone-square' => 'phone-square',
					'fas fa-phone-volume' => 'phone-volume',
					'fas fa-piggy-bank' => 'piggy-bank',
					'fas fa-pills' => 'pills',
					'fas fa-pizza-slice' => 'pizza-slice',
					'fas fa-place-of-worship' => 'place-of-worship',
					'fas fa-plane' => 'plane',
					'fas fa-plane-arrival' => 'plane-arrival',
					'fas fa-plane-departure' => 'plane-departure',
					'fas fa-play' => 'play',
					'fas fa-play-circle' => 'play-circle',
					'fas fa-plug' => 'plug',
					'fas fa-plus' => 'plus',
					'fas fa-plus-circle' => 'plus-circle',
					'fas fa-plus-square' => 'plus-square',
					'fas fa-podcast' => 'podcast',
					'fas fa-poll' => 'poll',
					'fas fa-poll-h' => 'poll-h',
					'fas fa-poo' => 'poo',
					'fas fa-poo-storm' => 'poo-storm',
					'fas fa-poop' => 'poop',
					'fas fa-portrait' => 'portrait',
					'fas fa-pound-sign' => 'pound-sign',
					'fas fa-power-off' => 'power-off',
					'fas fa-pray' => 'pray',
					'fas fa-praying-hands' => 'praying-hands',
					'fas fa-prescription' => 'prescription',
					'fas fa-prescription-bottle' => 'prescription-bottle',
					'fas fa-prescription-bottle-alt' => 'prescription-bottle-alt',
					'fas fa-print' => 'print',
					'fas fa-procedures' => 'procedures',
					'fas fa-project-diagram' => 'project-diagram',
					'fas fa-puzzle-piece' => 'puzzle-piece',
					'fas fa-qrcode' => 'qrcode',
					'fas fa-question' => 'question',
					'fas fa-question-circle' => 'question-circle',
					'fas fa-quidditch' => 'quidditch',
					'fas fa-quote-left' => 'quote-left',
					'fas fa-quote-right' => 'quote-right',
					'fas fa-quran' => 'quran',
					'fas fa-radiation' => 'radiation',
					'fas fa-radiation-alt' => 'radiation-alt',
					'fas fa-rainbow' => 'rainbow',
					'fas fa-random' => 'random',
					'fas fa-receipt' => 'receipt',
					'fas fa-recycle' => 'recycle',
					'fas fa-redo' => 'redo',
					'fas fa-redo-alt' => 'redo-alt',
					'fas fa-registered' => 'registered',
					'fas fa-reply' => 'reply',
					'fas fa-reply-all' => 'reply-all',
					'fas fa-republican' => 'republican',
					'fas fa-restroom' => 'restroom',
					'fas fa-retweet' => 'retweet',
					'fas fa-ribbon' => 'ribbon',
					'fas fa-ring' => 'ring',
					'fas fa-road' => 'road',
					'fas fa-robot' => 'robot',
					'fas fa-rocket' => 'rocket',
					'fas fa-route' => 'route',
					'fas fa-rss' => 'rss',
					'fas fa-rss-square' => 'rss-square',
					'fas fa-ruble-sign' => 'ruble-sign',
					'fas fa-ruler' => 'ruler',
					'fas fa-ruler-combined' => 'ruler-combined',
					'fas fa-ruler-horizontal' => 'ruler-horizontal',
					'fas fa-ruler-vertical' => 'ruler-vertical',
					'fas fa-running' => 'running',
					'fas fa-rupee-sign' => 'rupee-sign',
					'fas fa-sad-cry' => 'sad-cry',
					'fas fa-sad-tear' => 'sad-tear',
					'fas fa-satellite' => 'satellite',
					'fas fa-satellite-dish' => 'satellite-dish',
					'fas fa-save' => 'save',
					'fas fa-school' => 'school',
					'fas fa-screwdriver' => 'screwdriver',
					'fas fa-scroll' => 'scroll',
					'fas fa-sd-card' => 'sd-card',
					'fas fa-search' => 'search',
					'fas fa-search-dollar' => 'search-dollar',
					'fas fa-search-location' => 'search-location',
					'fas fa-search-minus' => 'search-minus',
					'fas fa-search-plus' => 'search-plus',
					'fas fa-seedling' => 'seedling',
					'fas fa-server' => 'server',
					'fas fa-shapes' => 'shapes',
					'fas fa-share' => 'share',
					'fas fa-share-alt' => 'share-alt',
					'fas fa-share-alt-square' => 'share-alt-square',
					'fas fa-share-square' => 'share-square',
					'fas fa-shekel-sign' => 'shekel-sign',
					'fas fa-shield-alt' => 'shield-alt',
					'fas fa-ship' => 'ship',
					'fas fa-shipping-fast' => 'shipping-fast',
					'fas fa-shoe-prints' => 'shoe-prints',
					'fas fa-shopping-bag' => 'shopping-bag',
					'fas fa-shopping-basket' => 'shopping-basket',
					'fas fa-shopping-cart' => 'shopping-cart',
					'fas fa-shower' => 'shower',
					'fas fa-shuttle-van' => 'shuttle-van',
					'fas fa-sign' => 'sign',
					'fas fa-sign-in-alt' => 'sign-in-alt',
					'fas fa-sign-language' => 'sign-language',
					'fas fa-sign-out-alt' => 'sign-out-alt',
					'fas fa-signal' => 'signal',
					'fas fa-signature' => 'signature',
					'fas fa-sim-card' => 'sim-card',
					'fas fa-sitemap' => 'sitemap',
					'fas fa-skating' => 'skating',
					'fas fa-skiing' => 'skiing',
					'fas fa-skiing-nordic' => 'skiing-nordic',
					'fas fa-skull' => 'skull',
					'fas fa-skull-crossbones' => 'skull-crossbones',
					'fas fa-slash' => 'slash',
					'fas fa-sleigh' => 'sleigh',
					'fas fa-sliders-h' => 'sliders-h',
					'fas fa-smile' => 'smile',
					'fas fa-smile-beam' => 'smile-beam',
					'fas fa-smile-wink' => 'smile-wink',
					'fas fa-smog' => 'smog',
					'fas fa-smoking' => 'smoking',
					'fas fa-smoking-ban' => 'smoking-ban',
					'fas fa-sms' => 'sms',
					'fas fa-snowboarding' => 'snowboarding',
					'fas fa-snowflake' => 'snowflake',
					'fas fa-snowman' => 'snowman',
					'fas fa-snowplow' => 'snowplow',
					'fas fa-socks' => 'socks',
					'fas fa-solar-panel' => 'solar-panel',
					'fas fa-sort' => 'sort',
					'fas fa-sort-alpha-down' => 'sort-alpha-down',
					'fas fa-sort-alpha-up' => 'sort-alpha-up',
					'fas fa-sort-amount-down' => 'sort-amount-down',
					'fas fa-sort-amount-up' => 'sort-amount-up',
					'fas fa-sort-down' => 'sort-down',
					'fas fa-sort-numeric-down' => 'sort-numeric-down',
					'fas fa-sort-numeric-up' => 'sort-numeric-up',
					'fas fa-sort-up' => 'sort-up',
					'fas fa-spa' => 'spa',
					'fas fa-space-shuttle' => 'space-shuttle',
					'fas fa-spider' => 'spider',
					'fas fa-spinner' => 'spinner',
					'fas fa-splotch' => 'splotch',
					'fas fa-spray-can' => 'spray-can',
					'fas fa-square' => 'square',
					'fas fa-square-full' => 'square-full',
					'fas fa-square-root-alt' => 'square-root-alt',
					'fas fa-stamp' => 'stamp',
					'fas fa-star' => 'star',
					'fas fa-star-and-crescent' => 'star-and-crescent',
					'fas fa-star-half' => 'star-half',
					'fas fa-star-half-alt' => 'star-half-alt',
					'fas fa-star-of-david' => 'star-of-david',
					'fas fa-star-of-life' => 'star-of-life',
					'fas fa-step-backward' => 'step-backward',
					'fas fa-step-forward' => 'step-forward',
					'fas fa-stethoscope' => 'stethoscope',
					'fas fa-sticky-note' => 'sticky-note',
					'fas fa-stop' => 'stop',
					'fas fa-stop-circle' => 'stop-circle',
					'fas fa-stopwatch' => 'stopwatch',
					'fas fa-store' => 'store',
					'fas fa-store-alt' => 'store-alt',
					'fas fa-stream' => 'stream',
					'fas fa-street-view' => 'street-view',
					'fas fa-strikethrough' => 'strikethrough',
					'fas fa-stroopwafel' => 'stroopwafel',
					'fas fa-subscript' => 'subscript',
					'fas fa-subway' => 'subway',
					'fas fa-suitcase' => 'suitcase',
					'fas fa-suitcase-rolling' => 'suitcase-rolling',
					'fas fa-sun' => 'sun',
					'fas fa-superscript' => 'superscript',
					'fas fa-surprise' => 'surprise',
					'fas fa-swatchbook' => 'swatchbook',
					'fas fa-swimmer' => 'swimmer',
					'fas fa-swimming-pool' => 'swimming-pool',
					'fas fa-synagogue' => 'synagogue',
					'fas fa-sync' => 'sync',
					'fas fa-sync-alt' => 'sync-alt',
					'fas fa-syringe' => 'syringe',
					'fas fa-table' => 'table',
					'fas fa-table-tennis' => 'table-tennis',
					'fas fa-tablet' => 'tablet',
					'fas fa-tablet-alt' => 'tablet-alt',
					'fas fa-tablets' => 'tablets',
					'fas fa-tachometer-alt' => 'tachometer-alt',
					'fas fa-tag' => 'tag',
					'fas fa-tags' => 'tags',
					'fas fa-tape' => 'tape',
					'fas fa-tasks' => 'tasks',
					'fas fa-taxi' => 'taxi',
					'fas fa-teeth' => 'teeth',
					'fas fa-teeth-open' => 'teeth-open',
					'fas fa-temperature-high' => 'temperature-high',
					'fas fa-temperature-low' => 'temperature-low',
					'fas fa-tenge' => 'tenge',
					'fas fa-terminal' => 'terminal',
					'fas fa-text-height' => 'text-height',
					'fas fa-text-width' => 'text-width',
					'fas fa-th' => 'th',
					'fas fa-th-large' => 'th-large',
					'fas fa-th-list' => 'th-list',
					'fas fa-theater-masks' => 'theater-masks',
					'fas fa-thermometer' => 'thermometer',
					'fas fa-thermometer-empty' => 'thermometer-empty',
					'fas fa-thermometer-full' => 'thermometer-full',
					'fas fa-thermometer-half' => 'thermometer-half',
					'fas fa-thermometer-quarter' => 'thermometer-quarter',
					'fas fa-thermometer-three-quarters' => 'thermometer-three-quarters',
					'fas fa-thumbs-down' => 'thumbs-down',
					'fas fa-thumbs-up' => 'thumbs-up',
					'fas fa-thumbtack' => 'thumbtack',
					'fas fa-ticket-alt' => 'ticket-alt',
					'fas fa-times' => 'times',
					'fas fa-times-circle' => 'times-circle',
					'fas fa-tint' => 'tint',
					'fas fa-tint-slash' => 'tint-slash',
					'fas fa-tired' => 'tired',
					'fas fa-toggle-off' => 'toggle-off',
					'fas fa-toggle-on' => 'toggle-on',
					'fas fa-toilet' => 'toilet',
					'fas fa-toilet-paper' => 'toilet-paper',
					'fas fa-toolbox' => 'toolbox',
					'fas fa-tools' => 'tools',
					'fas fa-tooth' => 'tooth',
					'fas fa-torah' => 'torah',
					'fas fa-torii-gate' => 'torii-gate',
					'fas fa-tractor' => 'tractor',
					'fas fa-trademark' => 'trademark',
					'fas fa-traffic-light' => 'traffic-light',
					'fas fa-train' => 'train',
					'fas fa-tram' => 'tram',
					'fas fa-transgender' => 'transgender',
					'fas fa-transgender-alt' => 'transgender-alt',
					'fas fa-trash' => 'trash',
					'fas fa-trash-alt' => 'trash-alt',
					'fas fa-trash-restore' => 'trash-restore',
					'fas fa-trash-restore-alt' => 'trash-restore-alt',
					'fas fa-tree' => 'tree',
					'fas fa-trophy' => 'trophy',
					'fas fa-truck' => 'truck',
					'fas fa-truck-loading' => 'truck-loading',
					'fas fa-truck-monster' => 'truck-monster',
					'fas fa-truck-moving' => 'truck-moving',
					'fas fa-truck-pickup' => 'truck-pickup',
					'fas fa-tshirt' => 'tshirt',
					'fas fa-tty' => 'tty',
					'fas fa-tv' => 'tv',
					'fas fa-umbrella' => 'umbrella',
					'fas fa-umbrella-beach' => 'umbrella-beach',
					'fas fa-underline' => 'underline',
					'fas fa-undo' => 'undo',
					'fas fa-undo-alt' => 'undo-alt',
					'fas fa-universal-access' => 'universal-access',
					'fas fa-university' => 'university',
					'fas fa-unlink' => 'unlink',
					'fas fa-unlock' => 'unlock',
					'fas fa-unlock-alt' => 'unlock-alt',
					'fas fa-upload' => 'upload',
					'fas fa-user' => 'user',
					'fas fa-user-alt' => 'user-alt',
					'fas fa-user-alt-slash' => 'user-alt-slash',
					'fas fa-user-astronaut' => 'user-astronaut',
					'fas fa-user-check' => 'user-check',
					'fas fa-user-circle' => 'user-circle',
					'fas fa-user-clock' => 'user-clock',
					'fas fa-user-cog' => 'user-cog',
					'fas fa-user-edit' => 'user-edit',
					'fas fa-user-friends' => 'user-friends',
					'fas fa-user-graduate' => 'user-graduate',
					'fas fa-user-injured' => 'user-injured',
					'fas fa-user-lock' => 'user-lock',
					'fas fa-user-md' => 'user-md',
					'fas fa-user-minus' => 'user-minus',
					'fas fa-user-ninja' => 'user-ninja',
					'fas fa-user-nurse' => 'user-nurse',
					'fas fa-user-plus' => 'user-plus',
					'fas fa-user-secret' => 'user-secret',
					'fas fa-user-shield' => 'user-shield',
					'fas fa-user-slash' => 'user-slash',
					'fas fa-user-tag' => 'user-tag',
					'fas fa-user-tie' => 'user-tie',
					'fas fa-user-times' => 'user-times',
					'fas fa-users' => 'users',
					'fas fa-users-cog' => 'users-cog',
					'fas fa-utensil-spoon' => 'utensil-spoon',
					'fas fa-utensils' => 'utensils',
					'fas fa-vector-square' => 'vector-square',
					'fas fa-venus' => 'venus',
					'fas fa-venus-double' => 'venus-double',
					'fas fa-venus-mars' => 'venus-mars',
					'fas fa-vial' => 'vial',
					'fas fa-vials' => 'vials',
					'fas fa-video' => 'video',
					'fas fa-video-slash' => 'video-slash',
					'fas fa-vihara' => 'vihara',
					'fas fa-volleyball-ball' => 'volleyball-ball',
					'fas fa-volume-down' => 'volume-down',
					'fas fa-volume-mute' => 'volume-mute',
					'fas fa-volume-off' => 'volume-off',
					'fas fa-volume-up' => 'volume-up',
					'fas fa-vote-yea' => 'vote-yea',
					'fas fa-vr-cardboard' => 'vr-cardboard',
					'fas fa-walking' => 'walking',
					'fas fa-wallet' => 'wallet',
					'fas fa-warehouse' => 'warehouse',
					'fas fa-water' => 'water',
					'fas fa-weight' => 'weight',
					'fas fa-weight-hanging' => 'weight-hanging',
					'fas fa-wheelchair' => 'wheelchair',
					'fas fa-wifi' => 'wifi',
					'fas fa-wind' => 'wind',
					'fas fa-window-close' => 'window-close',
					'fas fa-window-maximize' => 'window-maximize',
					'fas fa-window-minimize' => 'window-minimize',
					'fas fa-window-restore' => 'window-restore',
					'fas fa-wine-bottle' => 'wine-bottle',
					'fas fa-wine-glass' => 'wine-glass',
					'fas fa-wine-glass-alt' => 'wine-glass-alt',
					'fas fa-won-sign' => 'won-sign',
					'fas fa-wrench' => 'wrench',
					'fas fa-x-ray' => 'x-ray',
					'fas fa-yen-sign' => 'yen-sign',
					'fas fa-yin-yang' => 'yin-yang',
				),
			),
			array(
				'key' => 'regular',
				'label' => __( 'Regular', 'themify' ),
				'icons' => array(
					'far fa-address-book' => 'address-book',
					'far fa-address-card' => 'address-card',
					'far fa-angry' => 'angry',
					'far fa-arrow-alt-circle-down' => 'arrow-alt-circle-down',
					'far fa-arrow-alt-circle-left' => 'arrow-alt-circle-left',
					'far fa-arrow-alt-circle-right' => 'arrow-alt-circle-right',
					'far fa-arrow-alt-circle-up' => 'arrow-alt-circle-up',
					'far fa-bell' => 'bell',
					'far fa-bell-slash' => 'bell-slash',
					'far fa-bookmark' => 'bookmark',
					'far fa-building' => 'building',
					'far fa-calendar' => 'calendar',
					'far fa-calendar-alt' => 'calendar-alt',
					'far fa-calendar-check' => 'calendar-check',
					'far fa-calendar-minus' => 'calendar-minus',
					'far fa-calendar-plus' => 'calendar-plus',
					'far fa-calendar-times' => 'calendar-times',
					'far fa-caret-square-down' => 'caret-square-down',
					'far fa-caret-square-left' => 'caret-square-left',
					'far fa-caret-square-right' => 'caret-square-right',
					'far fa-caret-square-up' => 'caret-square-up',
					'far fa-chart-bar' => 'chart-bar',
					'far fa-check-circle' => 'check-circle',
					'far fa-check-square' => 'check-square',
					'far fa-circle' => 'circle',
					'far fa-clipboard' => 'clipboard',
					'far fa-clock' => 'clock',
					'far fa-clone' => 'clone',
					'far fa-closed-captioning' => 'closed-captioning',
					'far fa-comment' => 'comment',
					'far fa-comment-alt' => 'comment-alt',
					'far fa-comment-dots' => 'comment-dots',
					'far fa-comments' => 'comments',
					'far fa-compass' => 'compass',
					'far fa-copy' => 'copy',
					'far fa-copyright' => 'copyright',
					'far fa-credit-card' => 'credit-card',
					'far fa-dizzy' => 'dizzy',
					'far fa-dot-circle' => 'dot-circle',
					'far fa-edit' => 'edit',
					'far fa-envelope' => 'envelope',
					'far fa-envelope-open' => 'envelope-open',
					'far fa-eye' => 'eye',
					'far fa-eye-slash' => 'eye-slash',
					'far fa-file' => 'file',
					'far fa-file-alt' => 'file-alt',
					'far fa-file-archive' => 'file-archive',
					'far fa-file-audio' => 'file-audio',
					'far fa-file-code' => 'file-code',
					'far fa-file-excel' => 'file-excel',
					'far fa-file-image' => 'file-image',
					'far fa-file-pdf' => 'file-pdf',
					'far fa-file-powerpoint' => 'file-powerpoint',
					'far fa-file-video' => 'file-video',
					'far fa-file-word' => 'file-word',
					'far fa-flag' => 'flag',
					'far fa-flushed' => 'flushed',
					'far fa-folder' => 'folder',
					'far fa-folder-open' => 'folder-open',
					'far fa-frown' => 'frown',
					'far fa-frown-open' => 'frown-open',
					'far fa-futbol' => 'futbol',
					'far fa-gem' => 'gem',
					'far fa-grimace' => 'grimace',
					'far fa-grin' => 'grin',
					'far fa-grin-alt' => 'grin-alt',
					'far fa-grin-beam' => 'grin-beam',
					'far fa-grin-beam-sweat' => 'grin-beam-sweat',
					'far fa-grin-hearts' => 'grin-hearts',
					'far fa-grin-squint' => 'grin-squint',
					'far fa-grin-squint-tears' => 'grin-squint-tears',
					'far fa-grin-stars' => 'grin-stars',
					'far fa-grin-tears' => 'grin-tears',
					'far fa-grin-tongue' => 'grin-tongue',
					'far fa-grin-tongue-squint' => 'grin-tongue-squint',
					'far fa-grin-tongue-wink' => 'grin-tongue-wink',
					'far fa-grin-wink' => 'grin-wink',
					'far fa-hand-lizard' => 'hand-lizard',
					'far fa-hand-paper' => 'hand-paper',
					'far fa-hand-peace' => 'hand-peace',
					'far fa-hand-point-down' => 'hand-point-down',
					'far fa-hand-point-left' => 'hand-point-left',
					'far fa-hand-point-right' => 'hand-point-right',
					'far fa-hand-point-up' => 'hand-point-up',
					'far fa-hand-pointer' => 'hand-pointer',
					'far fa-hand-rock' => 'hand-rock',
					'far fa-hand-scissors' => 'hand-scissors',
					'far fa-hand-spock' => 'hand-spock',
					'far fa-handshake' => 'handshake',
					'far fa-hdd' => 'hdd',
					'far fa-heart' => 'heart',
					'far fa-hospital' => 'hospital',
					'far fa-hourglass' => 'hourglass',
					'far fa-id-badge' => 'id-badge',
					'far fa-id-card' => 'id-card',
					'far fa-image' => 'image',
					'far fa-images' => 'images',
					'far fa-keyboard' => 'keyboard',
					'far fa-kiss' => 'kiss',
					'far fa-kiss-beam' => 'kiss-beam',
					'far fa-kiss-wink-heart' => 'kiss-wink-heart',
					'far fa-laugh' => 'laugh',
					'far fa-laugh-beam' => 'laugh-beam',
					'far fa-laugh-squint' => 'laugh-squint',
					'far fa-laugh-wink' => 'laugh-wink',
					'far fa-lemon' => 'lemon',
					'far fa-life-ring' => 'life-ring',
					'far fa-lightbulb' => 'lightbulb',
					'far fa-list-alt' => 'list-alt',
					'far fa-map' => 'map',
					'far fa-meh' => 'meh',
					'far fa-meh-blank' => 'meh-blank',
					'far fa-meh-rolling-eyes' => 'meh-rolling-eyes',
					'far fa-minus-square' => 'minus-square',
					'far fa-money-bill-alt' => 'money-bill-alt',
					'far fa-moon' => 'moon',
					'far fa-newspaper' => 'newspaper',
					'far fa-object-group' => 'object-group',
					'far fa-object-ungroup' => 'object-ungroup',
					'far fa-paper-plane' => 'paper-plane',
					'far fa-pause-circle' => 'pause-circle',
					'far fa-play-circle' => 'play-circle',
					'far fa-plus-square' => 'plus-square',
					'far fa-question-circle' => 'question-circle',
					'far fa-registered' => 'registered',
					'far fa-sad-cry' => 'sad-cry',
					'far fa-sad-tear' => 'sad-tear',
					'far fa-save' => 'save',
					'far fa-share-square' => 'share-square',
					'far fa-smile' => 'smile',
					'far fa-smile-beam' => 'smile-beam',
					'far fa-smile-wink' => 'smile-wink',
					'far fa-snowflake' => 'snowflake',
					'far fa-square' => 'square',
					'far fa-star' => 'star',
					'far fa-star-half' => 'star-half',
					'far fa-sticky-note' => 'sticky-note',
					'far fa-stop-circle' => 'stop-circle',
					'far fa-sun' => 'sun',
					'far fa-surprise' => 'surprise',
					'far fa-thumbs-down' => 'thumbs-down',
					'far fa-thumbs-up' => 'thumbs-up',
					'far fa-times-circle' => 'times-circle',
					'far fa-tired' => 'tired',
					'far fa-trash-alt' => 'trash-alt',
					'far fa-user' => 'user',
					'far fa-user-circle' => 'user-circle',
					'far fa-window-close' => 'window-close',
					'far fa-window-maximize' => 'window-maximize',
					'far fa-window-minimize' => 'window-minimize',
					'far fa-window-restore' => 'window-restore',
				),
			),
			array(
				'key' => 'brand',
				'label' => __( 'Brand', 'themify' ),
				'icons' => array(
					'fab fa-500px' => '500px',
					'fab fa-accessible-icon' => 'accessible-icon',
					'fab fa-accusoft' => 'accusoft',
					'fab fa-acquisitions-incorporated' => 'acquisitions-incorporated',
					'fab fa-adn' => 'adn',
					'fab fa-adobe' => 'adobe',
					'fab fa-adversal' => 'adversal',
					'fab fa-affiliatetheme' => 'affiliatetheme',
					'fab fa-algolia' => 'algolia',
					'fab fa-alipay' => 'alipay',
					'fab fa-amazon' => 'amazon',
					'fab fa-amazon-pay' => 'amazon-pay',
					'fab fa-amilia' => 'amilia',
					'fab fa-android' => 'android',
					'fab fa-angellist' => 'angellist',
					'fab fa-angrycreative' => 'angrycreative',
					'fab fa-angular' => 'angular',
					'fab fa-app-store' => 'app-store',
					'fab fa-app-store-ios' => 'app-store-ios',
					'fab fa-apper' => 'apper',
					'fab fa-apple' => 'apple',
					'fab fa-apple-pay' => 'apple-pay',
					'fab fa-artstation' => 'artstation',
					'fab fa-asymmetrik' => 'asymmetrik',
					'fab fa-atlassian' => 'atlassian',
					'fab fa-audible' => 'audible',
					'fab fa-autoprefixer' => 'autoprefixer',
					'fab fa-avianex' => 'avianex',
					'fab fa-aviato' => 'aviato',
					'fab fa-aws' => 'aws',
					'fab fa-bandcamp' => 'bandcamp',
					'fab fa-behance' => 'behance',
					'fab fa-behance-square' => 'behance-square',
					'fab fa-bimobject' => 'bimobject',
					'fab fa-bitbucket' => 'bitbucket',
					'fab fa-bitcoin' => 'bitcoin',
					'fab fa-bity' => 'bity',
					'fab fa-black-tie' => 'black-tie',
					'fab fa-blackberry' => 'blackberry',
					'fab fa-blogger' => 'blogger',
					'fab fa-blogger-b' => 'blogger-b',
					'fab fa-bluetooth' => 'bluetooth',
					'fab fa-bluetooth-b' => 'bluetooth-b',
					'fab fa-btc' => 'btc',
					'fab fa-buromobelexperte' => 'buromobelexperte',
					'fab fa-buysellads' => 'buysellads',
					'fab fa-canadian-maple-leaf' => 'canadian-maple-leaf',
					'fab fa-cc-amazon-pay' => 'cc-amazon-pay',
					'fab fa-cc-amex' => 'cc-amex',
					'fab fa-cc-apple-pay' => 'cc-apple-pay',
					'fab fa-cc-diners-club' => 'cc-diners-club',
					'fab fa-cc-discover' => 'cc-discover',
					'fab fa-cc-jcb' => 'cc-jcb',
					'fab fa-cc-mastercard' => 'cc-mastercard',
					'fab fa-cc-paypal' => 'cc-paypal',
					'fab fa-cc-stripe' => 'cc-stripe',
					'fab fa-cc-visa' => 'cc-visa',
					'fab fa-centercode' => 'centercode',
					'fab fa-centos' => 'centos',
					'fab fa-chrome' => 'chrome',
					'fab fa-cloudscale' => 'cloudscale',
					'fab fa-cloudsmith' => 'cloudsmith',
					'fab fa-cloudversify' => 'cloudversify',
					'fab fa-codepen' => 'codepen',
					'fab fa-codiepie' => 'codiepie',
					'fab fa-confluence' => 'confluence',
					'fab fa-connectdevelop' => 'connectdevelop',
					'fab fa-contao' => 'contao',
					'fab fa-cpanel' => 'cpanel',
					'fab fa-creative-commons' => 'creative-commons',
					'fab fa-creative-commons-by' => 'creative-commons-by',
					'fab fa-creative-commons-nc' => 'creative-commons-nc',
					'fab fa-creative-commons-nc-eu' => 'creative-commons-nc-eu',
					'fab fa-creative-commons-nc-jp' => 'creative-commons-nc-jp',
					'fab fa-creative-commons-nd' => 'creative-commons-nd',
					'fab fa-creative-commons-pd' => 'creative-commons-pd',
					'fab fa-creative-commons-pd-alt' => 'creative-commons-pd-alt',
					'fab fa-creative-commons-remix' => 'creative-commons-remix',
					'fab fa-creative-commons-sa' => 'creative-commons-sa',
					'fab fa-creative-commons-sampling' => 'creative-commons-sampling',
					'fab fa-creative-commons-sampling-plus' => 'creative-commons-sampling-plus',
					'fab fa-creative-commons-share' => 'creative-commons-share',
					'fab fa-creative-commons-zero' => 'creative-commons-zero',
					'fab fa-critical-role' => 'critical-role',
					'fab fa-css3' => 'css3',
					'fab fa-css3-alt' => 'css3-alt',
					'fab fa-cuttlefish' => 'cuttlefish',
					'fab fa-d-and-d' => 'd-and-d',
					'fab fa-d-and-d-beyond' => 'd-and-d-beyond',
					'fab fa-dashcube' => 'dashcube',
					'fab fa-delicious' => 'delicious',
					'fab fa-deploydog' => 'deploydog',
					'fab fa-deskpro' => 'deskpro',
					'fab fa-dev' => 'dev',
					'fab fa-deviantart' => 'deviantart',
					'fab fa-dhl' => 'dhl',
					'fab fa-diaspora' => 'diaspora',
					'fab fa-digg' => 'digg',
					'fab fa-digital-ocean' => 'digital-ocean',
					'fab fa-discord' => 'discord',
					'fab fa-discourse' => 'discourse',
					'fab fa-dochub' => 'dochub',
					'fab fa-docker' => 'docker',
					'fab fa-draft2digital' => 'draft2digital',
					'fab fa-dribbble' => 'dribbble',
					'fab fa-dribbble-square' => 'dribbble-square',
					'fab fa-dropbox' => 'dropbox',
					'fab fa-drupal' => 'drupal',
					'fab fa-dyalog' => 'dyalog',
					'fab fa-earlybirds' => 'earlybirds',
					'fab fa-ebay' => 'ebay',
					'fab fa-edge' => 'edge',
					'fab fa-elementor' => 'elementor',
					'fab fa-ello' => 'ello',
					'fab fa-ember' => 'ember',
					'fab fa-empire' => 'empire',
					'fab fa-envira' => 'envira',
					'fab fa-erlang' => 'erlang',
					'fab fa-ethereum' => 'ethereum',
					'fab fa-etsy' => 'etsy',
					'fab fa-expeditedssl' => 'expeditedssl',
					'fab fa-facebook' => 'facebook',
					'fab fa-facebook-f' => 'facebook-f',
					'fab fa-facebook-messenger' => 'facebook-messenger',
					'fab fa-facebook-square' => 'facebook-square',
					'fab fa-fantasy-flight-games' => 'fantasy-flight-games',
					'fab fa-fedex' => 'fedex',
					'fab fa-fedora' => 'fedora',
					'fab fa-figma' => 'figma',
					'fab fa-firefox' => 'firefox',
					'fab fa-first-order' => 'first-order',
					'fab fa-first-order-alt' => 'first-order-alt',
					'fab fa-firstdraft' => 'firstdraft',
					'fab fa-flickr' => 'flickr',
					'fab fa-flipboard' => 'flipboard',
					'fab fa-fly' => 'fly',
					'fab fa-font-awesome' => 'font-awesome',
					'fab fa-font-awesome-alt' => 'font-awesome-alt',
					'fab fa-font-awesome-flag' => 'font-awesome-flag',
					'fab fa-fonticons' => 'fonticons',
					'fab fa-fonticons-fi' => 'fonticons-fi',
					'fab fa-fort-awesome' => 'fort-awesome',
					'fab fa-fort-awesome-alt' => 'fort-awesome-alt',
					'fab fa-forumbee' => 'forumbee',
					'fab fa-foursquare' => 'foursquare',
					'fab fa-free-code-camp' => 'free-code-camp',
					'fab fa-freebsd' => 'freebsd',
					'fab fa-fulcrum' => 'fulcrum',
					'fab fa-galactic-republic' => 'galactic-republic',
					'fab fa-galactic-senate' => 'galactic-senate',
					'fab fa-get-pocket' => 'get-pocket',
					'fab fa-gg' => 'gg',
					'fab fa-gg-circle' => 'gg-circle',
					'fab fa-git' => 'git',
					'fab fa-git-square' => 'git-square',
					'fab fa-github' => 'github',
					'fab fa-github-alt' => 'github-alt',
					'fab fa-github-square' => 'github-square',
					'fab fa-gitkraken' => 'gitkraken',
					'fab fa-gitlab' => 'gitlab',
					'fab fa-gitter' => 'gitter',
					'fab fa-glide' => 'glide',
					'fab fa-glide-g' => 'glide-g',
					'fab fa-gofore' => 'gofore',
					'fab fa-goodreads' => 'goodreads',
					'fab fa-goodreads-g' => 'goodreads-g',
					'fab fa-google' => 'google',
					'fab fa-google-drive' => 'google-drive',
					'fab fa-google-play' => 'google-play',
					'fab fa-google-plus' => 'google-plus',
					'fab fa-google-plus-g' => 'google-plus-g',
					'fab fa-google-plus-square' => 'google-plus-square',
					'fab fa-google-wallet' => 'google-wallet',
					'fab fa-gratipay' => 'gratipay',
					'fab fa-grav' => 'grav',
					'fab fa-gripfire' => 'gripfire',
					'fab fa-grunt' => 'grunt',
					'fab fa-gulp' => 'gulp',
					'fab fa-hacker-news' => 'hacker-news',
					'fab fa-hacker-news-square' => 'hacker-news-square',
					'fab fa-hackerrank' => 'hackerrank',
					'fab fa-hips' => 'hips',
					'fab fa-hire-a-helper' => 'hire-a-helper',
					'fab fa-hooli' => 'hooli',
					'fab fa-hornbill' => 'hornbill',
					'fab fa-hotjar' => 'hotjar',
					'fab fa-houzz' => 'houzz',
					'fab fa-html5' => 'html5',
					'fab fa-hubspot' => 'hubspot',
					'fab fa-imdb' => 'imdb',
					'fab fa-instagram' => 'instagram',
					'fab fa-intercom' => 'intercom',
					'fab fa-internet-explorer' => 'internet-explorer',
					'fab fa-invision' => 'invision',
					'fab fa-ioxhost' => 'ioxhost',
					'fab fa-itunes' => 'itunes',
					'fab fa-itunes-note' => 'itunes-note',
					'fab fa-java' => 'java',
					'fab fa-jedi-order' => 'jedi-order',
					'fab fa-jenkins' => 'jenkins',
					'fab fa-jira' => 'jira',
					'fab fa-joget' => 'joget',
					'fab fa-joomla' => 'joomla',
					'fab fa-js' => 'js',
					'fab fa-js-square' => 'js-square',
					'fab fa-jsfiddle' => 'jsfiddle',
					'fab fa-kaggle' => 'kaggle',
					'fab fa-keybase' => 'keybase',
					'fab fa-keycdn' => 'keycdn',
					'fab fa-kickstarter' => 'kickstarter',
					'fab fa-kickstarter-k' => 'kickstarter-k',
					'fab fa-korvue' => 'korvue',
					'fab fa-laravel' => 'laravel',
					'fab fa-lastfm' => 'lastfm',
					'fab fa-lastfm-square' => 'lastfm-square',
					'fab fa-leanpub' => 'leanpub',
					'fab fa-less' => 'less',
					'fab fa-line' => 'line',
					'fab fa-linkedin' => 'linkedin',
					'fab fa-linkedin-in' => 'linkedin-in',
					'fab fa-linode' => 'linode',
					'fab fa-linux' => 'linux',
					'fab fa-lyft' => 'lyft',
					'fab fa-magento' => 'magento',
					'fab fa-mailchimp' => 'mailchimp',
					'fab fa-mandalorian' => 'mandalorian',
					'fab fa-markdown' => 'markdown',
					'fab fa-mastodon' => 'mastodon',
					'fab fa-maxcdn' => 'maxcdn',
					'fab fa-medapps' => 'medapps',
					'fab fa-medium' => 'medium',
					'fab fa-medium-m' => 'medium-m',
					'fab fa-medrt' => 'medrt',
					'fab fa-meetup' => 'meetup',
					'fab fa-megaport' => 'megaport',
					'fab fa-mendeley' => 'mendeley',
					'fab fa-microsoft' => 'microsoft',
					'fab fa-mix' => 'mix',
					'fab fa-mixcloud' => 'mixcloud',
					'fab fa-mizuni' => 'mizuni',
					'fab fa-modx' => 'modx',
					'fab fa-monero' => 'monero',
					'fab fa-napster' => 'napster',
					'fab fa-neos' => 'neos',
					'fab fa-nimblr' => 'nimblr',
					'fab fa-nintendo-switch' => 'nintendo-switch',
					'fab fa-node' => 'node',
					'fab fa-node-js' => 'node-js',
					'fab fa-npm' => 'npm',
					'fab fa-ns8' => 'ns8',
					'fab fa-nutritionix' => 'nutritionix',
					'fab fa-odnoklassniki' => 'odnoklassniki',
					'fab fa-odnoklassniki-square' => 'odnoklassniki-square',
					'fab fa-old-republic' => 'old-republic',
					'fab fa-opencart' => 'opencart',
					'fab fa-openid' => 'openid',
					'fab fa-opera' => 'opera',
					'fab fa-optin-monster' => 'optin-monster',
					'fab fa-osi' => 'osi',
					'fab fa-page4' => 'page4',
					'fab fa-pagelines' => 'pagelines',
					'fab fa-palfed' => 'palfed',
					'fab fa-patreon' => 'patreon',
					'fab fa-paypal' => 'paypal',
					'fab fa-penny-arcade' => 'penny-arcade',
					'fab fa-periscope' => 'periscope',
					'fab fa-phabricator' => 'phabricator',
					'fab fa-phoenix-framework' => 'phoenix-framework',
					'fab fa-phoenix-squadron' => 'phoenix-squadron',
					'fab fa-php' => 'php',
					'fab fa-pied-piper' => 'pied-piper',
					'fab fa-pied-piper-alt' => 'pied-piper-alt',
					'fab fa-pied-piper-hat' => 'pied-piper-hat',
					'fab fa-pied-piper-pp' => 'pied-piper-pp',
					'fab fa-pinterest' => 'pinterest',
					'fab fa-pinterest-p' => 'pinterest-p',
					'fab fa-pinterest-square' => 'pinterest-square',
					'fab fa-playstation' => 'playstation',
					'fab fa-product-hunt' => 'product-hunt',
					'fab fa-pushed' => 'pushed',
					'fab fa-python' => 'python',
					'fab fa-qq' => 'qq',
					'fab fa-quinscape' => 'quinscape',
					'fab fa-quora' => 'quora',
					'fab fa-r-project' => 'r-project',
					'fab fa-raspberry-pi' => 'raspberry-pi',
					'fab fa-ravelry' => 'ravelry',
					'fab fa-react' => 'react',
					'fab fa-reacteurope' => 'reacteurope',
					'fab fa-readme' => 'readme',
					'fab fa-rebel' => 'rebel',
					'fab fa-red-river' => 'red-river',
					'fab fa-reddit' => 'reddit',
					'fab fa-reddit-alien' => 'reddit-alien',
					'fab fa-reddit-square' => 'reddit-square',
					'fab fa-redhat' => 'redhat',
					'fab fa-renren' => 'renren',
					'fab fa-replyd' => 'replyd',
					'fab fa-researchgate' => 'researchgate',
					'fab fa-resolving' => 'resolving',
					'fab fa-rev' => 'rev',
					'fab fa-rocketchat' => 'rocketchat',
					'fab fa-rockrms' => 'rockrms',
					'fab fa-safari' => 'safari',
					'fab fa-sass' => 'sass',
					'fab fa-schlix' => 'schlix',
					'fab fa-scribd' => 'scribd',
					'fab fa-searchengin' => 'searchengin',
					'fab fa-sellcast' => 'sellcast',
					'fab fa-sellsy' => 'sellsy',
					'fab fa-servicestack' => 'servicestack',
					'fab fa-shirtsinbulk' => 'shirtsinbulk',
					'fab fa-shopware' => 'shopware',
					'fab fa-simplybuilt' => 'simplybuilt',
					'fab fa-sistrix' => 'sistrix',
					'fab fa-sith' => 'sith',
					'fab fa-sketch' => 'sketch',
					'fab fa-skyatlas' => 'skyatlas',
					'fab fa-skype' => 'skype',
					'fab fa-slack' => 'slack',
					'fab fa-slack-hash' => 'slack-hash',
					'fab fa-slideshare' => 'slideshare',
					'fab fa-snapchat' => 'snapchat',
					'fab fa-snapchat-ghost' => 'snapchat-ghost',
					'fab fa-snapchat-square' => 'snapchat-square',
					'fab fa-soundcloud' => 'soundcloud',
					'fab fa-sourcetree' => 'sourcetree',
					'fab fa-speakap' => 'speakap',
					'fab fa-spotify' => 'spotify',
					'fab fa-squarespace' => 'squarespace',
					'fab fa-stack-exchange' => 'stack-exchange',
					'fab fa-stack-overflow' => 'stack-overflow',
					'fab fa-staylinked' => 'staylinked',
					'fab fa-steam' => 'steam',
					'fab fa-steam-square' => 'steam-square',
					'fab fa-steam-symbol' => 'steam-symbol',
					'fab fa-sticker-mule' => 'sticker-mule',
					'fab fa-strava' => 'strava',
					'fab fa-stripe' => 'stripe',
					'fab fa-stripe-s' => 'stripe-s',
					'fab fa-studiovinari' => 'studiovinari',
					'fab fa-stumbleupon' => 'stumbleupon',
					'fab fa-stumbleupon-circle' => 'stumbleupon-circle',
					'fab fa-superpowers' => 'superpowers',
					'fab fa-supple' => 'supple',
					'fab fa-suse' => 'suse',
					'fab fa-teamspeak' => 'teamspeak',
					'fab fa-telegram' => 'telegram',
					'fab fa-telegram-plane' => 'telegram-plane',
					'fab fa-tencent-weibo' => 'tencent-weibo',
					'fab fa-the-red-yeti' => 'the-red-yeti',
					'fab fa-themeco' => 'themeco',
					'fab fa-themeisle' => 'themeisle',
					'fab fa-think-peaks' => 'think-peaks',
					'fab fa-trade-federation' => 'trade-federation',
					'fab fa-trello' => 'trello',
					'fab fa-tripadvisor' => 'tripadvisor',
					'fab fa-tumblr' => 'tumblr',
					'fab fa-tumblr-square' => 'tumblr-square',
					'fab fa-twitch' => 'twitch',
					'fab fa-twitter' => 'twitter',
					'fab fa-twitter-square' => 'twitter-square',
					'fab fa-typo3' => 'typo3',
					'fab fa-uber' => 'uber',
					'fab fa-ubuntu' => 'ubuntu',
					'fab fa-uikit' => 'uikit',
					'fab fa-uniregistry' => 'uniregistry',
					'fab fa-untappd' => 'untappd',
					'fab fa-ups' => 'ups',
					'fab fa-usb' => 'usb',
					'fab fa-usps' => 'usps',
					'fab fa-ussunnah' => 'ussunnah',
					'fab fa-vaadin' => 'vaadin',
					'fab fa-viacoin' => 'viacoin',
					'fab fa-viadeo' => 'viadeo',
					'fab fa-viadeo-square' => 'viadeo-square',
					'fab fa-viber' => 'viber',
					'fab fa-vimeo' => 'vimeo',
					'fab fa-vimeo-square' => 'vimeo-square',
					'fab fa-vimeo-v' => 'vimeo-v',
					'fab fa-vine' => 'vine',
					'fab fa-vk' => 'vk',
					'fab fa-vnv' => 'vnv',
					'fab fa-vuejs' => 'vuejs',
					'fab fa-weebly' => 'weebly',
					'fab fa-weibo' => 'weibo',
					'fab fa-weixin' => 'weixin',
					'fab fa-whatsapp' => 'whatsapp',
					'fab fa-whatsapp-square' => 'whatsapp-square',
					'fab fa-whmcs' => 'whmcs',
					'fab fa-wikipedia-w' => 'wikipedia-w',
					'fab fa-windows' => 'windows',
					'fab fa-wix' => 'wix',
					'fab fa-wizards-of-the-coast' => 'wizards-of-the-coast',
					'fab fa-wolf-pack-battalion' => 'wolf-pack-battalion',
					'fab fa-wordpress' => 'wordpress',
					'fab fa-wordpress-simple' => 'wordpress-simple',
					'fab fa-wpbeginner' => 'wpbeginner',
					'fab fa-wpexplorer' => 'wpexplorer',
					'fab fa-wpforms' => 'wpforms',
					'fab fa-wpressr' => 'wpressr',
					'fab fa-xbox' => 'xbox',
					'fab fa-xing' => 'xing',
					'fab fa-xing-square' => 'xing-square',
					'fab fa-y-combinator' => 'y-combinator',
					'fab fa-yahoo' => 'yahoo',
					'fab fa-yandex' => 'yandex',
					'fab fa-yandex-international' => 'yandex-international',
					'fab fa-yarn' => 'yarn',
					'fab fa-yelp' => 'yelp',
					'fab fa-yoast' => 'yoast',
					'fab fa-youtube' => 'youtube',
					'fab fa-youtube-square' => 'youtube-square',
					'fab fa-zhihu' => 'zhihu',
				),
			),
		);
	}
}