<?php  
$current = 9;
$type = 0;

// Paramètres de connexion 
$host = 'localhost';
$db = 'uygraddkjhgtea_resolution';
$user = 'uygraddkjhgtea'; 
$pass = '3Jqgd2W8x5TX9j'; 

// Création de la connexion
$conn = new mysqli($host, $user, $pass, $db);

// Vérifiez la connexion
if ($conn->connect_error) {
    die("Échec de la connexion : " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $pdfFile = $_FILES['pdf_file'];
    $coverFile = $_FILES['cover_file'];
    $bookName = $_POST['name_file']; 

    $uploadDir = '../uploads/';
    $pdfPath = $uploadDir . basename($pdfFile['name']);
    $coverPath = $uploadDir . basename($coverFile['name']);

    $errors = [];

    // Vérifiez les erreurs de téléchargement pour le PDF
    if ($pdfFile['error'] != UPLOAD_ERR_OK) {
        $errors[] = "Erreur lors du téléchargement du fichier PDF. Code d'erreur : " . $pdfFile['error'];
    } elseif (!move_uploaded_file($pdfFile['tmp_name'], $pdfPath)) {
        $errors[] = "Impossible de déplacer le fichier PDF vers le dossier de destination.";
    }

    // Vérifiez les erreurs de téléchargement pour la photo de couverture
    if ($coverFile['error'] != UPLOAD_ERR_OK) {
        $errors[] = "Erreur lors du téléchargement de la photo de couverture. Code d'erreur : " . $coverFile['error'];
    } elseif (!move_uploaded_file($coverFile['tmp_name'], $coverPath)) {
        $errors[] = "Impossible de déplacer la photo de couverture vers le dossier de destination.";
    }

    if (empty($errors)) {
        // Préparez et exécutez l'insertion dans la base de données
        $stmt = $conn->prepare("INSERT INTO books (pdf_file, cover_file, nom) VALUES (?, ?, ?)");
        $stmt->bind_param('sss', $pdfFile['name'], $coverFile['name'], $bookName);

        if ($stmt->execute()) {
            // Redirection après succès avec un message de succès
            header("Location: index.php?page=upload&status=success");
            exit();  
        } else {
            header("Location: index.php?page=upload&status=error");
            exit();  
        }

        $stmt->close();
    } else {
        $errorMessage = implode('\n', $errors);
        header("Location: index.php?page=upload&status=error&message=" . urlencode($errorMessage));
        exit();  
    }
}

$conn->close();
?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const params = new URLSearchParams(window.location.search);
        const status = params.get('status');
        const message = params.get('message');
    
        if (status === 'success') {
            alert('Les données ont été insérées dans la base de données avec succès.');
        } else if (status === 'error') {
            alert('Erreur lors de l\'insertion des données dans la base de données.' + (message ? '\nDétails : ' + decodeURIComponent(message) : ''));
        }
    });
</script>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Administration - Téléchargement</title>
    <style>
         body {
            font-family: Arial, sans-serif;
            background-color: #f5f5f5;
            margin: 0;
            padding: 0;
        }
        .menu{
            
            margin-left:-70px;
            margin-top:50px;
        }
        
        .form-container {
            max-width: 300px;
            margin-left: 200px;
            margin-top:100px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .table-container {
            margin-left: 550px;
            margin-top:-485px;
            max-width: 1500px;
            padding: 20px;
        }
        h3 {
            text-align: center;
            color: #333;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }
        
        input[type="text"],
        input[type="file"],
        input[type="submit"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="file"]:focus {
            border-color: #007BFF;
            outline: none;
        }
        
        input[type="submit"] {
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
            font-weight: bold;
        }
        
        input[type="submit"]:hover {
            background-color: #0056b3;
        }
        
        input[type="submit"]:active {
            background-color: #004494;
        }
    </style>
    
</head>
<body>
    <div class="container">
        <!-- Menu Admin -->
       <div class="menu"> 
            <?php include('../includes/menu_admin.php'); ?>
        </div>
        
        <!-- Formulaire -->
        <div class="form-container">
            <h3>Telecharger</h3>
            <form action="upload.php" method="post" enctype="multipart/form-data">
                <label for="name_file">Nom du Livre :</label>
                <input type="text" name="name_file" id="name_file" required>
                
                <label for="pdf_file">Fichier PDF :</label>
                <input type="file" name="pdf_file" id="pdf_file" required>
                
                <label for="cover_file">Photo de Couverture :</label>
                <input type="file" name="cover_file" id="cover_file" required>
                
                <input type="submit" value="Télécharger">
            </form>
        </div>

        <!-- Tableau d'affichage des données -->
        <div class="table-container">
            <?php
            // Réouverture de la connexion à la base de données
            $conn = new mysqli($host, $user, $pass, $db);

            if ($conn->connect_error) {
                die("Échec de la connexion : " . $conn->connect_error);
            }
            include('list_livre.php');
            
            // Fermeture de la connexion
            $conn->close();
            ?>
        </div>
    </div>
</body>
</html>
