<?php
/**
 * Custom template tags for this theme
 *
 * @subpackage Recycling Energy
 * @since 1.0
 */

/**
 * Prints HTML with meta information for the current post-date/time and author.
 */

if ( ! function_exists( 'recycling_energy_entry_footer' ) ) :
/**
 * Prints HTML with meta information for the categories, tags and comments.
 */
function recycling_energy_entry_footer() {
	$recycling_energy_separate_meta = __( ', ', 'recycling-energy' );
	$recycling_energy_categories_list = get_the_category_list( $recycling_energy_separate_meta );
	$recycling_energy_tags_list = get_the_tag_list( '', $recycling_energy_separate_meta );
	if ( ( ( recycling_energy_categorized_blog() && $recycling_energy_categories_list ) || $recycling_energy_tags_list ) || get_edit_post_link() ) {

		echo '<footer class="entry-footer">';

			recycling_energy_edit_link();

		echo '</footer> <!-- .entry-footer -->';
	}
}
endif;

if ( ! function_exists( 'recycling_energy_edit_link' ) ) :
function recycling_energy_edit_link() {
	edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			__( 'Edit<span class="screen-reader-text"> "%s"</span>', 'recycling-energy' ),
			get_the_title()
		),
		'<span class="edit-link">',
		'</span>'
	);
}
endif;

function recycling_energy_categorized_blog() {
	$recycling_energy_category_count = get_transient( 'recycling_energy_categories' );

	if ( false === $recycling_energy_category_count ) {
		// Create an array of all the categories that are attached to posts.
		$categories = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$recycling_energy_category_count = count( $categories );

		set_transient( 'recycling_energy_categories', $recycling_energy_category_count );
	}

	// Allow viewing case of 0 or 1 categories in post preview.
	if ( is_preview() ) {
		return true;
	}

	return $recycling_energy_category_count > 1;
}

if ( ! function_exists( 'recycling_energy_the_custom_logo' ) ) :

function recycling_energy_the_custom_logo() {
	the_custom_logo();
}
endif;

function recycling_energy_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 'recycling_energy_categories' );
}
add_action( 'edit_category', 'recycling_energy_category_transient_flusher' );
add_action( 'save_post',     'recycling_energy_category_transient_flusher' );
