<?php
/**
 * Recycling Energy: Customizer-home-page
 *
 * @subpackage Recycling Energy
 * @since 1.0
 */

	//  Home Page Panel
	$wp_customize->add_panel( 'recycling_energy_custompage_panel', array(
		'title' => esc_html__( 'Custom Page Settings', 'recycling-energy' ),
		'priority' => 2,
	));

	// Top Header
    $wp_customize->add_section('recycling_energy_top',array(
        'title' => __('Top Header', 'recycling-energy'),
        'panel' => 'recycling_energy_custompage_panel',
    ) );
    $wp_customize->add_setting( 'recycling_energy_section_header_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_header_heading', array(
		'label'       => esc_html__( 'Top Header Settings', 'recycling-energy' ),	
		'section'     => 'recycling_energy_top',
		'settings'    => 'recycling_energy_section_header_heading',
	) ) );
	$wp_customize->add_setting(
		'tobar_text_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'tobar_text_enable',
			array(
				'settings'        => 'tobar_text_enable',
				'section'         => 'recycling_energy_top',
				'label'           => __( 'Check to Show Topbar Text ', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
    $wp_customize->add_setting('recycling_energy_top_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_top_text',array(
		'label' => esc_html__('Add Topbar Text','recycling-energy'),
		'section' => 'recycling_energy_top',
		'setting' => 'recycling_energy_top_text',
		'type'    => 'text'
	));
	$wp_customize->add_setting(
		'tobar_button_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'tobar_button_enable',
			array(
				'settings'        => 'tobar_button_enable',
				'section'         => 'recycling_energy_top',
				'label'           => __( 'Check to Show Topbar Links', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
    $wp_customize->add_setting('recycling_energy_top_text_btn1',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_top_text_btn1',array(
		'label' => esc_html__('Add Button Text','recycling-energy'),
		'section' => 'recycling_energy_top',
		'setting' => 'recycling_energy_top_text_btn1',
		'type'    => 'text'
	));
    $wp_customize->add_setting('recycling_energy_top_link_btn1',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_top_link_btn1',array(
		'label' => esc_html__('Add Button URL','recycling-energy'),
		'section' => 'recycling_energy_top',
		'setting' => 'recycling_energy_top_link_btn1',
		'type'    => 'url'
	));
    $wp_customize->add_setting('recycling_energy_top_text_btn2',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_top_text_btn2',array(
		'label' => esc_html__('Add Button Text','recycling-energy'),
		'section' => 'recycling_energy_top',
		'setting' => 'recycling_energy_top_text_btn2',
		'type'    => 'text'
	));
    $wp_customize->add_setting('recycling_energy_top_link_btn2',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_top_link_btn2',array(
		'label' => esc_html__('Add Button URL','recycling-energy'),
		'section' => 'recycling_energy_top',
		'setting' => 'recycling_energy_top_link_btn2',
		'type'    => 'url'
	));

	// Header
    $wp_customize->add_section('recycling_energy_header',array(
        'title' => __('Header', 'recycling-energy'),
        'panel' => 'recycling_energy_custompage_panel',
    ) );
    $wp_customize->add_setting( 'recycling_energy_section_contact_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_contact_heading', array(
		'label'       => esc_html__( 'Header Settings', 'recycling-energy' ),	
		'description' => __( 'Add contact info in the below feilds', 'recycling-energy' ),		
		'section'     => 'recycling_energy_header',
		'settings'    => 'recycling_energy_section_contact_heading',
	) ) );
	$wp_customize->add_setting(
		'header_contact_info_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'header_contact_info_enable',
			array(
				'settings'        => 'header_contact_info_enable',
				'section'         => 'recycling_energy_header',
				'label'           => __( 'Check to Show Contact Details', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
    $wp_customize->add_setting('recycling_energy_email_address_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_email_address_text',array(
		'label' => esc_html__('Add Email Address Text','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_email_address_text',
		'type'    => 'text'
	));
    $wp_customize->add_setting('recycling_energy_email_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_email'
	));
	$wp_customize->add_control('recycling_energy_email_address',array(
		'label' => esc_html__('Add Email Address','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_email_address',
		'type'    => 'text'
	));
	$wp_customize->add_setting('recycling_energy_email_icon',array(
		'default'	=> 'fas fa-envelope-open',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_email_icon',array(
		'label'	=> __('Add email Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_header',
		'setting'	=> 'recycling_energy_email_icon',
		'type'		=> 'icon'
	)));
    $wp_customize->add_setting('recycling_energy_call_number_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_call_number_text',array(
		'label' => esc_html__('Add Phone Number Text','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_call_number_text',
		'type'    => 'text'
	));
    $wp_customize->add_setting('recycling_energy_call_number',array(
		'default' => '',
		'sanitize_callback' => 'recycling_energy_sanitize_phone_number'
	));
	$wp_customize->add_control('recycling_energy_call_number',array(
		'label' => esc_html__('Add Phone Number','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_call_number',
		'type'    => 'text'
	));
	$wp_customize->add_setting('recycling_energy_call_icon',array(
		'default'	=> 'fas fa-phone-volume',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_call_icon',array(
		'label'	=> __('Add call Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_header',
		'setting'	=> 'recycling_energy_call_icon',
		'type'		=> 'icon'
	)));
    $wp_customize->add_setting('recycling_energy_location_address_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_location_address_text',array(
		'label' => esc_html__('Add Location Text','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_location_address_text',
		'type'    => 'text'
	));
	$wp_customize->add_setting('recycling_energy_location_address',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_location_address',array(
		'label' => esc_html__('Add Location','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_location_address',
		'type'    => 'text'
	));
	$wp_customize->add_setting('recycling_energy_location_icon',array(
		'default'	=> 'fas fa-map-marker-alt',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_location_icon',array(
		'label'	=> __('Add location Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_header',
		'setting'	=> 'recycling_energy_location_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting(
		'header_button_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'header_button_enable',
			array(
				'settings'        => 'header_button_enable',
				'section'         => 'recycling_energy_header',
				'label'           => __( 'Check to Show Header Button', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
    $wp_customize->add_setting('recycling_energy_talk_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_talk_btn_text',array(
		'label' => esc_html__('Add Button Text','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_talk_btn_text',
		'type'    => 'text'
	));
    $wp_customize->add_setting('recycling_energy_talk_btn_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_talk_btn_link',array(
		'label' => esc_html__('Add Button URL','recycling-energy'),
		'section' => 'recycling_energy_header',
		'setting' => 'recycling_energy_talk_btn_link',
		'type'    => 'url'
	));

	// Social Media
    $wp_customize->add_section('recycling_energy_urls',array(
        'title' => __('Social Media', 'recycling-energy'),
        'panel' => 'recycling_energy_custompage_panel',
    ) );
    $wp_customize->add_setting( 'recycling_energy_section_social_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_social_heading', array(
		'label'       => esc_html__( 'Social Media Settings', 'recycling-energy' ),
		'description' => __( 'Add social media links in the below feilds', 'recycling-energy' ),			
		'section'     => 'recycling_energy_urls',
		'settings'    => 'recycling_energy_section_social_heading',
	) ) );
	$wp_customize->add_setting(
		'header_social_icon_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'header_social_icon_enable',
			array(
				'settings'        => 'header_social_icon_enable',
				'section'         => 'recycling_energy_urls',
				'label'           => __( 'Check to show social fields', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_twitter_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_twitter_heading', array(
		'label'       => esc_html__( 'Twitter Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_urls',
		'settings'    => 'recycling_energy_twitter_heading',
	) ) );
    $wp_customize->add_setting('recycling_energy_twitter_icon',array(
		'default'	=> 'fab fa-twitter',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_twitter_icon',array(
		'label'	=> __('Add Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_urls',
		'setting'	=> 'recycling_energy_twitter_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_twitter',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_twitter',array(
		'label' => esc_html__('Add URL','recycling-energy'),
		'section' => 'recycling_energy_urls',
		'setting' => 'recycling_energy_twitter',
		'type'    => 'url'
	));
	$wp_customize->add_setting(
		'recycling_energy_header_twt_target',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_header_twt_target',
			array(
				'settings'        => 'recycling_energy_header_twt_target',
				'section'         => 'recycling_energy_urls',
				'label'           => __( 'Open link in a new tab', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_linkedin_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_linkedin_heading', array(
		'label'       => esc_html__( 'Linkedin Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_urls',
		'settings'    => 'recycling_energy_linkedin_heading',
	) ) );
	$wp_customize->add_setting('recycling_energy_linkedin_icon',array(
		'default'	=> 'fab fa-linkedin',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_linkedin_icon',array(
		'label'	=> __('Add Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_urls',
		'setting'	=> 'recycling_energy_linkedin_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_linkedin',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_linkedin',array(
		'label' => esc_html__('Add URL','recycling-energy'),
		'section' => 'recycling_energy_urls',
		'setting' => 'recycling_energy_linkedin',
		'type'    => 'url'
	));
	$wp_customize->add_setting(
		'recycling_energy_header_linkedin_target',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_header_linkedin_target',
			array(
				'settings'        => 'recycling_energy_header_linkedin_target',
				'section'         => 'recycling_energy_urls',
				'label'           => __( 'Open link in a new tab', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_youtube_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_youtube_heading', array(
		'label'       => esc_html__( 'Youtube Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_urls',
		'settings'    => 'recycling_energy_youtube_heading',
	) ) );
	$wp_customize->add_setting('recycling_energy_youtube_icon',array(
		'default'	=> 'fab fa-youtube',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_youtube_icon',array(
		'label'	=> __('Add Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_urls',
		'setting'	=> 'recycling_energy_youtube_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_youtube',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_youtube',array(
		'label' => esc_html__('Add URL','recycling-energy'),
		'section' => 'recycling_energy_urls',
		'setting' => 'recycling_energy_youtube',
		'type'    => 'url'
	));
	$wp_customize->add_setting(
		'recycling_energy_header_youtube_target',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_header_youtube_target',
			array(
				'settings'        => 'recycling_energy_header_youtube_target',
				'section'         => 'recycling_energy_urls',
				'label'           => __( 'Open link in a new tab', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting( 'recycling_energy_instagram_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_instagram_heading', array(
		'label'       => esc_html__( 'Instagram Settings', 'recycling-energy' ),
		'section'     => 'recycling_energy_urls',
		'settings'    => 'recycling_energy_instagram_heading',
	) ) );
	$wp_customize->add_setting('recycling_energy_instagram_icon',array(
		'default'	=> 'fab fa-instagram',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control(new Recycling_Energy_Fontawesome_Icon_Chooser(
        $wp_customize,'recycling_energy_instagram_icon',array(
		'label'	=> __('Add Icon','recycling-energy'),
		'transport' => 'refresh',
		'section'	=> 'recycling_energy_urls',
		'setting'	=> 'recycling_energy_instagram_icon',
		'type'		=> 'icon'
	)));
	$wp_customize->add_setting('recycling_energy_instagram',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw'
	));
	$wp_customize->add_control('recycling_energy_instagram',array(
		'label' => esc_html__('Add URL','recycling-energy'),
		'section' => 'recycling_energy_urls',
		'setting' => 'recycling_energy_instagram',
		'type'    => 'url'
	));
	$wp_customize->add_setting(
		'recycling_energy_header_instagram_target',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_header_instagram_target',
			array(
				'settings'        => 'recycling_energy_header_instagram_target',
				'section'         => 'recycling_energy_urls',
				'label'           => __( 'Open link in a new tab', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);

    //Slider
	$wp_customize->add_section( 'recycling_energy_slider_section' , array(
    	'title'      => __( 'Slider Settings', 'recycling-energy' ),
    	'panel' => 'recycling_energy_custompage_panel',
	) );
	$wp_customize->add_setting( 'recycling_energy_section_slide_heading', array(
			'default'           => '',
			'transport'         => 'refresh',
			'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_slide_heading', array(
		'label'       => esc_html__( 'Slider Settings', 'recycling-energy' ),
		'description' => __( 'Slider Image Dimension ( 1600px x 650px )', 'recycling-energy' ),		
		'section'     => 'recycling_energy_slider_section',
		'settings'    => 'recycling_energy_section_slide_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_slider_arrows',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_slider_arrows',
			array(
				'settings'        => 'recycling_energy_slider_arrows',
				'section'         => 'recycling_energy_slider_section',
				'label'           => __( 'Check To Show Slider', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);

	$recycling_energy_args = array('numberposts' => -1);
	$post_list = get_posts($recycling_energy_args);
	$i = 0;
	$pst_sls[]= __('Select','recycling-energy');
	foreach ($post_list as $key => $p_post) {
		$pst_sls[$p_post->ID]=$p_post->post_title;
	}
	for ( $i = 1; $i <= 4; $i++ ) {
		$wp_customize->add_setting('recycling_energy_post_setting'.$i,array(
			'sanitize_callback' => 'recycling_energy_sanitize_select',
		));
		$wp_customize->add_control('recycling_energy_post_setting'.$i,array(
			'type'    => 'select',
			'choices' => $pst_sls,
			'label' => __('Select post','recycling-energy'),
			'section' => 'recycling_energy_slider_section',
			'active_callback' => 'recycling_energy_slider_dropdown',
		));
	}
	wp_reset_postdata();

	$wp_customize->add_setting(
		'recycling_energy_slider_excerpt_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_slider_excerpt_show_hide',
			array(
				'settings'        => 'recycling_energy_slider_excerpt_show_hide',
				'section'         => 'recycling_energy_slider_section',
				'label'           => __( 'Show Hide excerpt', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => 'recycling_energy_slider_dropdown',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_slider_excerpt_count',array(
		'default'=> 20,
		'transport' => 'refresh',
		'sanitize_callback' => 'recycling_energy_sanitize_integer'
	));
	$wp_customize->add_control(new Recycling_Energy_Slider_Custom_Control( $wp_customize, 'recycling_energy_slider_excerpt_count',array(
		'label' => esc_html__( 'Excerpt Limit','recycling-energy' ),
		'section'=> 'recycling_energy_slider_section',
		'settings'=>'recycling_energy_slider_excerpt_count',
		'input_attrs' => array(
			'reset'			   => 20,
            'step'             => 1,
			'min'              => 0,
			'max'              => 50,
        ),
        'active_callback' => 'recycling_energy_slider_dropdown',
	)));
	$wp_customize->add_setting(
		'recycling_energy_slider_button_show_hide',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '1',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_slider_button_show_hide',
			array(
				'settings'        => 'recycling_energy_slider_button_show_hide',
				'section'         => 'recycling_energy_slider_section',
				'label'           => __( 'Show Hide Button', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => 'recycling_energy_slider_dropdown',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_slider_read_more',array(
		'default' => 'Get Involved',
		'sanitize_callback' => 'sanitize_text_field'
	)); 
	$wp_customize->add_control('recycling_energy_slider_read_more',array(
		'label' => esc_html__('Button Text','recycling-energy'),
		'section' => 'recycling_energy_slider_section',
		'setting' => 'recycling_energy_slider_read_more',
		'type'    => 'text',
		'active_callback' => 'recycling_energy_slider_dropdown',
	));

	$wp_customize->add_setting( 'recycling_energy_slider_content_alignment',
		array(
			'default' => 'LEFT-ALIGN',
			'transport' => 'refresh',
			'sanitize_callback' => 'recycling_energy_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Text_Radio_Button_Custom_Control( $wp_customize, 'recycling_energy_slider_content_alignment',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Slider Content Alignment', 'recycling-energy' ),
			'section' => 'recycling_energy_slider_section',
			'choices' => array(
				'LEFT-ALIGN' => __('LEFT','recycling-energy'),
	            'CENTER-ALIGN' => __('CENTER','recycling-energy'),
	            'RIGHT-ALIGN' => __('RIGHT','recycling-energy'),
			),
			'active_callback' => 'recycling_energy_slider_dropdown',
		)
	) );

	// Mission Section
	$wp_customize->add_section( 'recycling_energy_mission_section' , array(
    	'title'      => __( 'Mission Section Settings', 'recycling-energy' ),
		'panel' => 'recycling_energy_custompage_panel',
	) );
	$wp_customize->add_setting( 'recycling_energy_section_mission_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_mission_heading', array(
			'label'       => esc_html__( 'Mission Section Settings', 'recycling-energy' ),		
			'section'     => 'recycling_energy_mission_section',
			'settings'    => 'recycling_energy_section_mission_heading',
	) ) );
	$wp_customize->add_setting(
		'recycling_energy_services_enable',
		array(
			'type'                 => 'option',
			'capability'           => 'edit_theme_options',
			'theme_supports'       => '',
			'default'              => '',
			'transport'            => 'refresh',
			'sanitize_callback'    => 'recycling_energy_callback_sanitize_switch',
		)
	);
	$wp_customize->add_control(
		new Recycling_Energy_Customizer_Customcontrol_Switch(
			$wp_customize,
			'recycling_energy_services_enable',
			array(
				'settings'        => 'recycling_energy_services_enable',
				'section'         => 'recycling_energy_mission_section',
				'label'           => __( 'Check To Show Section', 'recycling-energy' ),				
				'choices'		  => array(
					'1'      => __( 'On', 'recycling-energy' ),
					'off'    => __( 'Off', 'recycling-energy' ),
				),
				'active_callback' => '',
			)
		)
	);
	$wp_customize->add_setting('recycling_energy_mission_main_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_mission_main_title',array(
		'label'	=> esc_html__('Section Main Title','recycling-energy'),
		'section'	=> 'recycling_energy_mission_section',
		'type'		=> 'text',
		'active_callback' => 'recycling_energy_services_dropdown',
	));
	$wp_customize->add_setting('recycling_energy_mission_short_title',array(
		'default'	=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_mission_short_title',array(
		'label'	=> esc_html__('Section Short Title ','recycling-energy'),
		'section'	=> 'recycling_energy_mission_section',
		'type'		=> 'text',
		'active_callback' => 'recycling_energy_services_dropdown',
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
	if($i==0){
	  $default = $category->slug;
	  $i++;
	}
	$cat_post[$category->slug] = $category->name;
	}
	$wp_customize->add_setting('recycling_energy_mission_category_setting',array(
		'default' => 'select',
		'sanitize_callback' => 'recycling_energy_sanitize_select',
	));
	$wp_customize->add_control('recycling_energy_mission_category_setting',array(
		'type'    => 'select',
		'choices' => $cat_post,
		'label' => esc_html__('Select Category to display mission','recycling-energy'),
		'section' => 'recycling_energy_mission_section',
		'active_callback' => 'recycling_energy_services_dropdown',
	));

	//Footer
    $wp_customize->add_section( 'recycling_energy_footer_copyright', array(
    	'title'      => esc_html__( 'Footer Text', 'recycling-energy' ),
    	'panel' => 'recycling_energy_custompage_panel',
	));
    $wp_customize->add_setting( 'recycling_energy_section_footer_heading', array(
		'default'           => '',
		'transport'         => 'refresh',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new Recycling_Energy_Customizer_Customcontrol_Section_Heading( $wp_customize, 'recycling_energy_section_footer_heading', array(
		'label'       => esc_html__( 'Footer Settings', 'recycling-energy' ),		
		'section'     => 'recycling_energy_footer_copyright',
		'settings'    => 'recycling_energy_section_footer_heading',
	) ) );
    $wp_customize->add_setting('recycling_energy_footer_text',array(
		'default'	=> 'Recycling WordPress Theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('recycling_energy_footer_text',array(
		'label'	=> esc_html__('Copyright Text','recycling-energy'),
		'section'	=> 'recycling_energy_footer_copyright',
		'type'		=> 'textarea'
	));
	$wp_customize->add_setting( 'recycling_energy_footer_content_alignment',
		array(
			'default' => 'CENTER-ALIGN',
			'transport' => 'refresh',
			'sanitize_callback' => 'recycling_energy_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Text_Radio_Button_Custom_Control( $wp_customize, 'recycling_energy_footer_content_alignment',
		array(
			'type' => 'select',
			'label' => esc_html__( 'Footer Content Alignment', 'recycling-energy' ),
			'section' => 'recycling_energy_footer_copyright',
			'choices' => array(
				'LEFT-ALIGN' => __('LEFT','recycling-energy'),
	            'CENTER-ALIGN' => __('CENTER','recycling-energy'),
	            'RIGHT-ALIGN' => __('RIGHT','recycling-energy'),
			),
			'active_callback' => '',
		)
	) );
	$wp_customize->add_setting( 'recycling_energy_footer_widget',
		array(
			'default' => '4',
			'transport' => 'refresh',
			'sanitize_callback' => 'recycling_energy_sanitize_choices'
		)
	);
	$wp_customize->add_control( new Recycling_Energy_Text_Radio_Button_Custom_Control( $wp_customize, 'recycling_energy_footer_widget',
		array(
			'type' => 'select',
			'label' => esc_html__('Footer Per Column','recycling-energy'),
			'section' => 'recycling_energy_footer_copyright',
			'choices' => array(
				'1' => __('1','recycling-energy'),
	            '2' => __('2','recycling-energy'),
	            '3' => __('3','recycling-energy'),
	            '4' => __('4','recycling-energy'),
			)
		)
	) );