<?php
/**
 * The header for our theme
 *
 * @subpackage Recycling Energy
 * @since 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
	    do_action( 'wp_body_open' );
	}
?>
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'recycling-energy' ); ?></a>
	<?php if( get_option('recycling_energy_theme_loader',true) != 'off'){ ?>
		<div class="preloader">
			<div class="load">
			  <hr/><hr/><hr/><hr/>
			</div>
		</div>
	<?php }?>
	<div id="page" class="site">
		<div id="header">
			<div class="top_bar py-2 text-center text-md-left">
				<div class="container">
					<div class="row">
						<div class="col-lg-4 col-md-4 col-12 align-self-center">
							<?php if( get_option('tobar_text_enable',false) != 'off'){ ?>
								<?php if( get_theme_mod('recycling_energy_top_text') != '' ){ ?>
									<p class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_top_text','')); ?></p>
								<?php }?>
							<?php }?>
						</div>
						<div class="col-lg-4 col-md-4 col-6 align-self-center">
							<?php if( get_option('tobar_button_enable',false) != 'off'){ ?>
								<?php if( get_theme_mod('recycling_energy_top_text_btn1') != '' || get_theme_mod('recycling_energy_top_link_btn1') != '' ){ ?>
									<a href="<?php echo esc_url(get_theme_mod('recycling_energy_top_link_btn1','')); ?>"><?php echo esc_html(get_theme_mod('recycling_energy_top_text_btn1','')); ?></a>
								<?php }?>
								<?php if( get_theme_mod('recycling_energy_top_text_btn2') != '' || get_theme_mod('recycling_energy_top_link_btn2') != '' ){ ?><span>|</span>
									<a href="<?php echo esc_url(get_theme_mod('recycling_energy_top_link_btn2','')); ?>"><?php echo esc_html(get_theme_mod('recycling_energy_top_text_btn2','')); ?></a>
								<?php }?>
							<?php }?>
						</div>
						<div class="col-lg-4 col-md-4 col-6 align-self-center">
							<?php if( get_option('header_social_icon_enable',false) != 'off'){ ?>
				          <?php
				            $recycling_energy_header_twt_target = esc_attr(get_option('recycling_energy_header_twt_target','true'));
				            $recycling_energy_header_linkedin_target = esc_attr(get_option('recycling_energy_header_linkedin_target','true'));
				            $recycling_energy_header_youtube_target = esc_attr(get_option('recycling_energy_header_youtube_target','true'));
				            $recycling_energy_header_instagram_target = esc_attr(get_option('recycling_energy_header_instagram_target','true'));
				          ?> 						 
							<div class="links text-center text-md-right">
								<?php if( get_theme_mod('recycling_energy_twitter') != ''){ ?>
					            <a target="<?php echo $recycling_energy_header_twt_target !='off' ? '_blank' : '' ?>" href="<?php echo esc_url(get_theme_mod('recycling_energy_twitter','')); ?>">
					              <i class="<?php echo esc_attr(get_theme_mod('recycling_energy_twitter_icon','fab fa-twitter')); ?>"></i>
					            </a>
					          <?php }?>
					          <?php if( get_theme_mod('recycling_energy_linkedin') != ''){ ?>
					            <a target="<?php echo $recycling_energy_header_linkedin_target !='off' ? '_blank' : '' ?>" href="<?php echo esc_url(get_theme_mod('recycling_energy_linkedin','')); ?>">
					              <i class="<?php echo esc_attr(get_theme_mod('recycling_energy_linkedin_icon','fab fa-linkedin-in')); ?>"></i>
					            </a>
					          <?php }?>
					          <?php if( get_theme_mod('recycling_energy_youtube') != ''){ ?>
					            <a target="<?php echo $recycling_energy_header_youtube_target !='off' ? '_blank' : '' ?>" href="<?php echo esc_url(get_theme_mod('recycling_energy_youtube','')); ?>">
					              <i class="<?php echo esc_attr(get_theme_mod('recycling_energy_youtube_icon','fab fa-youtube')); ?>"></i>
					            </a>
					          <?php }?>
					          <?php if( get_theme_mod('recycling_energy_instagram') != ''){ ?>
					            <a target="<?php echo $recycling_energy_header_instagram_target !='off' ? '_blank' : '' ?>" href="<?php echo esc_url(get_theme_mod('recycling_energy_instagram','')); ?>">
					              <i class="<?php echo esc_attr(get_theme_mod('recycling_energy_instagram_icon','fab fa-instagram')); ?>"></i>
					            </a>
					          <?php }?>
							</div>
							<?php }?>
						</div>
					</div>
				</div>
			</div>
			<div class="contact-header py-3 text-center text-md-left">
				<div class="container">
					<div class="row">
						<div class="col-lg-3 col-md-12 col-12 align-self-center mb-2 mb-md-0">
							<div class="logo py-3 py-lg-0 text-md-center text-lg-left">
						        <?php if ( has_custom_logo() ) : ?>
				            		<?php the_custom_logo(); ?>
					            <?php endif; ?>
				              	<?php $recycling_energy_blog_info = get_bloginfo( 'name' ); ?>
				              	<?php if( get_option('recycling_energy_logo_title',false) != 'off'){ ?>
					                <?php if ( ! empty( $recycling_energy_blog_info ) ) : ?>
					                  	<?php if ( is_front_page() && is_home() ) : ?>
					                    	<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
					                  	<?php else : ?>
				                      		<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>

				                  		<?php endif; ?>
					                <?php endif; ?>
					                <?php }?>
					                <?php
				                  		$recycling_energy_description = get_bloginfo( 'description', 'display' );
					                  	if ( $recycling_energy_description || is_customize_preview() ) :
					                ?>
					                <?php if( get_option('recycling_energy_logo_text',true) != 'off'){ ?>
				                  	<p class="site-description">
				                    	<?php echo esc_html($recycling_energy_description); ?>
				                  	</p>
				                  <?php }?>
				              	<?php endif; ?>
						    </div>
						</div>
						<div class="col-lg-9 col-md-12 col-12 align-self-center">
							<?php if( get_option('header_contact_info_enable',false) != 'off'){ ?>
								<div class="row">
									<div class="col-lg-4 col-md-4 col-12 align-self-center mb-2 mb-md-0">
										<div class="row">
											<?php if( get_theme_mod('recycling_energy_email_address') != '' || get_theme_mod('recycling_energy_email_address_text') != '' ){ ?>
												<div class="col-lg-2 col-md-2  align-self-center">
													<i class="<?php echo esc_html(get_theme_mod('recycling_energy_email_icon','fas fa-envelope-open')); ?>"></i>
												</div>
												<div class="col-lg-10 col-md-10  align-self-center">
													<h6 class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_email_address_text','')); ?></h6>
													<p class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_email_address','')); ?></p>
												</div>
											<?php }?>
										</div>
									</div>
									<div class="col-lg-3 col-md-4 col-12 align-self-center mb-2 mb-md-0">
										<div class="row">
											<?php if( get_theme_mod('recycling_energy_call_number') != '' || get_theme_mod('recycling_energy_call_number_text') != '' ){ ?>
												<div class="col-lg-3 col-md-3  align-self-center">
													<i class="<?php echo esc_html(get_theme_mod('recycling_energy_call_icon','fas fa-phone-volume')); ?>"></i>
												</div>
												<div class="col-lg-9 col-md-9  align-self-center">
													<h6 class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_call_number_text','')); ?></h6>
													<p class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_call_number','')); ?></p>
												</div>
											<?php }?>
										</div>
									</div>
									<div class="col-lg-5 col-md-4 col-12 align-self-center">
										<div class="row">
											<?php if( get_theme_mod('recycling_energy_location_address') != '' || get_theme_mod('recycling_energy_location_address_text') != '' ){ ?>
												<div class="col-lg-2 col-md-2  align-self-center">
													<i class="<?php echo esc_html(get_theme_mod('recycling_energy_location_icon','fas fa-map-marker-alt')); ?>"></i>
												</div>
												<div class="col-lg-10 col-md-10  align-self-center">
													<h6 class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_location_address_text','')); ?></h6>
													<p class="mb-0"><?php echo esc_html(get_theme_mod('recycling_energy_location_address','')); ?></p>
												</div>
											<?php }?>
										</div>
									</div>
								</div>
							<?php }?>
						</div>
					</div>
				</div>
			</div>
			<div class="wrap_figure">
				<div class="menu_header py-2">
					<div class="container">
						<div class="row">
							<div class="col-lg-9 col-md-6 col-6 align-self-center">
								<div class="fixed_header">
									<div class="toggle-menu gb_menu text-center">
										<button onclick="recycling_energy_gb_Menu_open()" class="gb_toggle p-2"><i class="fas fa-ellipsis-h"></i><p class="mb-0"><?php esc_html_e('Menu','recycling-energy'); ?></p></button>
									</div>
				   				<?php get_template_part('template-parts/navigation/navigation'); ?>
							</div>
							</div>
							<div class="col-lg-3 col-md-6 col-6 align-self-center">
								<?php if( get_option('header_button_enable',false) != 'off'){ ?>
									<?php if( get_theme_mod('recycling_energy_talk_btn_link') != '' || get_theme_mod('recycling_energy_talk_btn_text') != ''){ ?>
										<p class="chat_btn mb-0 text-center"><a href="<?php echo esc_url(get_theme_mod('recycling_energy_talk_btn_link','')); ?>"><?php echo esc_html(get_theme_mod('recycling_energy_talk_btn_text','')); ?></i></a></p>
									<?php }?>
								<?php }?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
