<?php
defined('ABSPATH') || exit;

if (!class_exists('Wgl_Admin_Icon')) {
    /**
     * BigHearts Wgl_Admin_Icon
     *
     *
     * @category Class
     * @package bighearts\core\class
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     */
    class Wgl_Admin_Icon
    {
        private $icons = [];
        private static $instance;

        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        private function __construct()
        {
            $this->icons = $this->setup_icon_array();
        }

        private function setup_icon_array()
        {
            $icons = $this->get_icon_list() ?: [];

            return apply_filters('bighearts/icon_list', $icons);
        }

        /*----------------------------------------------------------------------------*
         * Public Helper Functions
         *----------------------------------------------------------------------------*/
        public function get_icons_name($get_icons_value = false)
        {
            $icons = [];

            if (!empty($this->icons)) {
                foreach ($this->icons as $key => $value) {
                    $icons[$key] = (bool) $get_icons_value ? esc_html($key) : esc_html($value);
                }

                return $icons;
            } else {
                return $icons;
            }
        }

        public function get_icon_list()
        {
            return [
                'fab fa-500px' => esc_html__( '500px', 'bighearts' ),
                'fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'bighearts' ),
                'fab fa-accusoft' => esc_html__( 'accusoft', 'bighearts' ),
                'fas fa-address-book' => esc_html__( 'address-book', 'bighearts' ),
                'far fa-address-book' => esc_html__( 'address-book', 'bighearts' ),
                'fas fa-address-card' => esc_html__( 'address-card', 'bighearts' ),
                'far fa-address-card' => esc_html__( 'address-card', 'bighearts' ),
                'fas fa-adjust' => esc_html__( 'adjust', 'bighearts' ),
                'fab fa-adn' => esc_html__( 'adn', 'bighearts' ),
                'fab fa-adversal' => esc_html__( 'adversal', 'bighearts' ),
                'fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'bighearts' ),
                'fab fa-algolia' => esc_html__( 'algolia', 'bighearts' ),
                'fas fa-align-center' => esc_html__( 'align-center', 'bighearts' ),
                'fas fa-align-justify' => esc_html__( 'align-justify', 'bighearts' ),
                'fas fa-align-left' => esc_html__( 'align-left', 'bighearts' ),
                'fas fa-align-right' => esc_html__( 'align-right', 'bighearts' ),
                'fas fa-allergies' => esc_html__( 'allergies', 'bighearts' ),
                'fab fa-amazon' => esc_html__( 'amazon', 'bighearts' ),
                'fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'bighearts' ),
                'fas fa-ambulance' => esc_html__( 'ambulance', 'bighearts' ),
                'fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'bighearts' ),
                'fab fa-amilia' => esc_html__( 'amilia', 'bighearts' ),
                'fas fa-anchor' => esc_html__( 'anchor', 'bighearts' ),
                'fab fa-android' => esc_html__( 'android', 'bighearts' ),
                'fab fa-angellist' => esc_html__( 'angellist', 'bighearts' ),
                'fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'bighearts' ),
                'fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'bighearts' ),
                'fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'bighearts' ),
                'fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'bighearts' ),
                'fas fa-angle-down' => esc_html__( 'angle-down', 'bighearts' ),
                'fas fa-angle-left' => esc_html__( 'angle-left', 'bighearts' ),
                'fas fa-angle-right' => esc_html__( 'angle-right', 'bighearts' ),
                'fas fa-angle-up' => esc_html__( 'angle-up', 'bighearts' ),
                'fab fa-angrycreative' => esc_html__( 'angrycreative', 'bighearts' ),
                'fab fa-angular' => esc_html__( 'angular', 'bighearts' ),
                'fab fa-app-store' => esc_html__( 'app-store', 'bighearts' ),
                'fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'bighearts' ),
                'fab fa-apper' => esc_html__( 'apper', 'bighearts' ),
                'fab fa-apple' => esc_html__( 'apple', 'bighearts' ),
                'fab fa-apple-pay' => esc_html__( 'apple-pay', 'bighearts' ),
                'fas fa-archive' => esc_html__( 'archive', 'bighearts' ),
                'fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'bighearts' ),
                'far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'bighearts' ),
                'fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'bighearts' ),
                'far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'bighearts' ),
                'fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'bighearts' ),
                'far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'bighearts' ),
                'fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'bighearts' ),
                'far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'bighearts' ),
                'fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'bighearts' ),
                'fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'bighearts' ),
                'fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'bighearts' ),
                'fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'bighearts' ),
                'fas fa-arrow-down' => esc_html__( 'arrow-down', 'bighearts' ),
                'fas fa-arrow-left' => esc_html__( 'arrow-left', 'bighearts' ),
                'fas fa-arrow-right' => esc_html__( 'arrow-right', 'bighearts' ),
                'fas fa-arrow-up' => esc_html__( 'arrow-up', 'bighearts' ),
                'fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'bighearts' ),
                'fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'bighearts' ),
                'fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'bighearts' ),
                'fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'bighearts' ),
                'fas fa-asterisk' => esc_html__( 'asterisk', 'bighearts' ),
                'fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'bighearts' ),
                'fas fa-at' => esc_html__( 'at', 'bighearts' ),
                'fab fa-audible' => esc_html__( 'audible', 'bighearts' ),
                'fas fa-audio-description' => esc_html__( 'audio-description', 'bighearts' ),
                'fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'bighearts' ),
                'fab fa-avianex' => esc_html__( 'avianex', 'bighearts' ),
                'fab fa-aviato' => esc_html__( 'aviato', 'bighearts' ),
                'fab fa-aws' => esc_html__( 'aws', 'bighearts' ),
                'fas fa-backward' => esc_html__( 'backward', 'bighearts' ),
                'fas fa-balance-scale' => esc_html__( 'balance-scale', 'bighearts' ),
                'fas fa-ban' => esc_html__( 'ban', 'bighearts' ),
                'fas fa-band-aid' => esc_html__( 'band-aid', 'bighearts' ),
                'fab fa-bandcamp' => esc_html__( 'bandcamp', 'bighearts' ),
                'fas fa-barcode' => esc_html__( 'barcode', 'bighearts' ),
                'fas fa-bars' => esc_html__( 'bars', 'bighearts' ),
                'fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'bighearts' ),
                'fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'bighearts' ),
                'fas fa-bath' => esc_html__( 'bath', 'bighearts' ),
                'fas fa-battery-empty' => esc_html__( 'battery-empty', 'bighearts' ),
                'fas fa-battery-full' => esc_html__( 'battery-full', 'bighearts' ),
                'fas fa-battery-half' => esc_html__( 'battery-half', 'bighearts' ),
                'fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'bighearts' ),
                'fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'bighearts' ),
                'fas fa-bed' => esc_html__( 'bed', 'bighearts' ),
                'fas fa-beer' => esc_html__( 'beer', 'bighearts' ),
                'fab fa-behance' => esc_html__( 'behance', 'bighearts' ),
                'fab fa-behance-square' => esc_html__( 'behance-square', 'bighearts' ),
                'fas fa-bell' => esc_html__( 'bell', 'bighearts' ),
                'far fa-bell' => esc_html__( 'bell', 'bighearts' ),
                'fas fa-bell-slash' => esc_html__( 'bell-slash', 'bighearts' ),
                'far fa-bell-slash' => esc_html__( 'bell-slash', 'bighearts' ),
                'fas fa-bicycle' => esc_html__( 'bicycle', 'bighearts' ),
                'fab fa-bimobject' => esc_html__( 'bimobject', 'bighearts' ),
                'fas fa-binoculars' => esc_html__( 'binoculars', 'bighearts' ),
                'fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'bighearts' ),
                'fab fa-bitbucket' => esc_html__( 'bitbucket', 'bighearts' ),
                'fab fa-bitcoin' => esc_html__( 'bitcoin', 'bighearts' ),
                'fab fa-bity' => esc_html__( 'bity', 'bighearts' ),
                'fab fa-black-tie' => esc_html__( 'black-tie', 'bighearts' ),
                'fab fa-blackberry' => esc_html__( 'blackberry', 'bighearts' ),
                'fas fa-blind' => esc_html__( 'blind', 'bighearts' ),
                'fab fa-blogger' => esc_html__( 'blogger', 'bighearts' ),
                'fab fa-blogger-b' => esc_html__( 'blogger-b', 'bighearts' ),
                'fab fa-bluetooth' => esc_html__( 'bluetooth', 'bighearts' ),
                'fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'bighearts' ),
                'fas fa-bold' => esc_html__( 'bold', 'bighearts' ),
                'fas fa-bolt' => esc_html__( 'bolt', 'bighearts' ),
                'fas fa-bomb' => esc_html__( 'bomb', 'bighearts' ),
                'fas fa-book' => esc_html__( 'book', 'bighearts' ),
                'fas fa-bookmark' => esc_html__( 'bookmark', 'bighearts' ),
                'far fa-bookmark' => esc_html__( 'bookmark', 'bighearts' ),
                'fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'bighearts' ),
                'fas fa-box' => esc_html__( 'box', 'bighearts' ),
                'fas fa-box-open' => esc_html__( 'box-open', 'bighearts' ),
                'fas fa-boxes' => esc_html__( 'boxes', 'bighearts' ),
                'fas fa-braille' => esc_html__( 'braille', 'bighearts' ),
                'fas fa-briefcase' => esc_html__( 'briefcase', 'bighearts' ),
                'fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'bighearts' ),
                'fab fa-btc' => esc_html__( 'btc', 'bighearts' ),
                'fas fa-bug' => esc_html__( 'bug', 'bighearts' ),
                'fas fa-building' => esc_html__( 'building', 'bighearts' ),
                'far fa-building' => esc_html__( 'building', 'bighearts' ),
                'fas fa-bullhorn' => esc_html__( 'bullhorn', 'bighearts' ),
                'fas fa-bullseye' => esc_html__( 'bullseye', 'bighearts' ),
                'fas fa-burn' => esc_html__( 'burn', 'bighearts' ),
                'fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'bighearts' ),
                'fas fa-bus' => esc_html__( 'bus', 'bighearts' ),
                'fab fa-buysellads' => esc_html__( 'buysellads', 'bighearts' ),
                'fas fa-calculator' => esc_html__( 'calculator', 'bighearts' ),
                'fas fa-calendar' => esc_html__( 'calendar', 'bighearts' ),
                'far fa-calendar' => esc_html__( 'calendar', 'bighearts' ),
                'fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'bighearts' ),
                'far fa-calendar-alt' => esc_html__( 'calendar-alt', 'bighearts' ),
                'fas fa-calendar-check' => esc_html__( 'calendar-check', 'bighearts' ),
                'far fa-calendar-check' => esc_html__( 'calendar-check', 'bighearts' ),
                'fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'bighearts' ),
                'far fa-calendar-minus' => esc_html__( 'calendar-minus', 'bighearts' ),
                'fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'bighearts' ),
                'far fa-calendar-plus' => esc_html__( 'calendar-plus', 'bighearts' ),
                'fas fa-calendar-times' => esc_html__( 'calendar-times', 'bighearts' ),
                'far fa-calendar-times' => esc_html__( 'calendar-times', 'bighearts' ),
                'fas fa-camera' => esc_html__( 'camera', 'bighearts' ),
                'fas fa-camera-retro' => esc_html__( 'camera-retro', 'bighearts' ),
                'fas fa-capsules' => esc_html__( 'capsules', 'bighearts' ),
                'fas fa-car' => esc_html__( 'car', 'bighearts' ),
                'fas fa-caret-down' => esc_html__( 'caret-down', 'bighearts' ),
                'fas fa-caret-left' => esc_html__( 'caret-left', 'bighearts' ),
                'fas fa-caret-right' => esc_html__( 'caret-right', 'bighearts' ),
                'fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'bighearts' ),
                'far fa-caret-square-down' => esc_html__( 'caret-square-down', 'bighearts' ),
                'fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'bighearts' ),
                'far fa-caret-square-left' => esc_html__( 'caret-square-left', 'bighearts' ),
                'fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'bighearts' ),
                'far fa-caret-square-right' => esc_html__( 'caret-square-right', 'bighearts' ),
                'fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'bighearts' ),
                'far fa-caret-square-up' => esc_html__( 'caret-square-up', 'bighearts' ),
                'fas fa-caret-up' => esc_html__( 'caret-up', 'bighearts' ),
                'fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'bighearts' ),
                'fas fa-cart-plus' => esc_html__( 'cart-plus', 'bighearts' ),
                'fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'bighearts' ),
                'fab fa-cc-amex' => esc_html__( 'cc-amex', 'bighearts' ),
                'fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'bighearts' ),
                'fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'bighearts' ),
                'fab fa-cc-discover' => esc_html__( 'cc-discover', 'bighearts' ),
                'fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'bighearts' ),
                'fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'bighearts' ),
                'fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'bighearts' ),
                'fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'bighearts' ),
                'fab fa-cc-visa' => esc_html__( 'cc-visa', 'bighearts' ),
                'fab fa-centercode' => esc_html__( 'centercode', 'bighearts' ),
                'fas fa-certificate' => esc_html__( 'certificate', 'bighearts' ),
                'fas fa-chart-area' => esc_html__( 'chart-area', 'bighearts' ),
                'fas fa-chart-bar' => esc_html__( 'chart-bar', 'bighearts' ),
                'far fa-chart-bar' => esc_html__( 'chart-bar', 'bighearts' ),
                'fas fa-chart-line' => esc_html__( 'chart-line', 'bighearts' ),
                'fas fa-chart-pie' => esc_html__( 'chart-pie', 'bighearts' ),
                'fas fa-check' => esc_html__( 'check', 'bighearts' ),
                'fas fa-check-circle' => esc_html__( 'check-circle', 'bighearts' ),
                'far fa-check-circle' => esc_html__( 'check-circle', 'bighearts' ),
                'fas fa-check-square' => esc_html__( 'check-square', 'bighearts' ),
                'far fa-check-square' => esc_html__( 'check-square', 'bighearts' ),
                'fas fa-chess' => esc_html__( 'chess', 'bighearts' ),
                'fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'bighearts' ),
                'fas fa-chess-board' => esc_html__( 'chess-board', 'bighearts' ),
                'fas fa-chess-king' => esc_html__( 'chess-king', 'bighearts' ),
                'fas fa-chess-knight' => esc_html__( 'chess-knight', 'bighearts' ),
                'fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'bighearts' ),
                'fas fa-chess-queen' => esc_html__( 'chess-queen', 'bighearts' ),
                'fas fa-chess-rook' => esc_html__( 'chess-rook', 'bighearts' ),
                'fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'bighearts' ),
                'fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'bighearts' ),
                'fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'bighearts' ),
                'fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'bighearts' ),
                'fas fa-chevron-down' => esc_html__( 'chevron-down', 'bighearts' ),
                'fas fa-chevron-left' => esc_html__( 'chevron-left', 'bighearts' ),
                'fas fa-chevron-right' => esc_html__( 'chevron-right', 'bighearts' ),
                'fas fa-chevron-up' => esc_html__( 'chevron-up', 'bighearts' ),
                'fas fa-child' => esc_html__( 'child', 'bighearts' ),
                'fab fa-chrome' => esc_html__( 'chrome', 'bighearts' ),
                'fas fa-circle' => esc_html__( 'circle', 'bighearts' ),
                'far fa-circle' => esc_html__( 'circle', 'bighearts' ),
                'fas fa-circle-notch' => esc_html__( 'circle-notch', 'bighearts' ),
                'fas fa-clipboard' => esc_html__( 'clipboard', 'bighearts' ),
                'far fa-clipboard' => esc_html__( 'clipboard', 'bighearts' ),
                'fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'bighearts' ),
                'fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'bighearts' ),
                'fas fa-clock' => esc_html__( 'clock', 'bighearts' ),
                'far fa-clock' => esc_html__( 'clock', 'bighearts' ),
                'fas fa-clone' => esc_html__( 'clone', 'bighearts' ),
                'far fa-clone' => esc_html__( 'clone', 'bighearts' ),
                'fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'bighearts' ),
                'far fa-closed-captioning' => esc_html__( 'closed-captioning', 'bighearts' ),
                'fas fa-cloud' => esc_html__( 'cloud', 'bighearts' ),
                'fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'bighearts' ),
                'fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'bighearts' ),
                'fab fa-cloudscale' => esc_html__( 'cloudscale', 'bighearts' ),
                'fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'bighearts' ),
                'fab fa-cloudversify' => esc_html__( 'cloudversify', 'bighearts' ),
                'fas fa-code' => esc_html__( 'code', 'bighearts' ),
                'fas fa-code-branch' => esc_html__( 'code-branch', 'bighearts' ),
                'fab fa-codepen' => esc_html__( 'codepen', 'bighearts' ),
                'fab fa-codiepie' => esc_html__( 'codiepie', 'bighearts' ),
                'fas fa-coffee' => esc_html__( 'coffee', 'bighearts' ),
                'fas fa-cog' => esc_html__( 'cog', 'bighearts' ),
                'fas fa-cogs' => esc_html__( 'cogs', 'bighearts' ),
                'fas fa-columns' => esc_html__( 'columns', 'bighearts' ),
                'fas fa-comment' => esc_html__( 'comment', 'bighearts' ),
                'far fa-comment' => esc_html__( 'comment', 'bighearts' ),
                'fas fa-comment-alt' => esc_html__( 'comment-alt', 'bighearts' ),
                'far fa-comment-alt' => esc_html__( 'comment-alt', 'bighearts' ),
                'fas fa-comment-dots' => esc_html__( 'comment-dots', 'bighearts' ),
                'fas fa-comment-slash' => esc_html__( 'comment-slash', 'bighearts' ),
                'fas fa-comments' => esc_html__( 'comments', 'bighearts' ),
                'far fa-comments' => esc_html__( 'comments', 'bighearts' ),
                'fas fa-compass' => esc_html__( 'compass', 'bighearts' ),
                'far fa-compass' => esc_html__( 'compass', 'bighearts' ),
                'fas fa-compress' => esc_html__( 'compress', 'bighearts' ),
                'fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'bighearts' ),
                'fab fa-contao' => esc_html__( 'contao', 'bighearts' ),
                'fas fa-copy' => esc_html__( 'copy', 'bighearts' ),
                'far fa-copy' => esc_html__( 'copy', 'bighearts' ),
                'fas fa-copyright' => esc_html__( 'copyright', 'bighearts' ),
                'far fa-copyright' => esc_html__( 'copyright', 'bighearts' ),
                'fas fa-couch' => esc_html__( 'couch', 'bighearts' ),
                'fab fa-cpanel' => esc_html__( 'cpanel', 'bighearts' ),
                'fab fa-creative-commons' => esc_html__( 'creative-commons', 'bighearts' ),
                'fas fa-credit-card' => esc_html__( 'credit-card', 'bighearts' ),
                'far fa-credit-card' => esc_html__( 'credit-card', 'bighearts' ),
                'fas fa-crop' => esc_html__( 'crop', 'bighearts' ),
                'fas fa-crosshairs' => esc_html__( 'crosshairs', 'bighearts' ),
                'fab fa-css3' => esc_html__( 'css3', 'bighearts' ),
                'fab fa-css3-alt' => esc_html__( 'css3-alt', 'bighearts' ),
                'fas fa-cube' => esc_html__( 'cube', 'bighearts' ),
                'fas fa-cubes' => esc_html__( 'cubes', 'bighearts' ),
                'fas fa-cut' => esc_html__( 'cut', 'bighearts' ),
                'fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'bighearts' ),
                'fab fa-d-and-d' => esc_html__( 'd-and-d', 'bighearts' ),
                'fab fa-dashcube' => esc_html__( 'dashcube', 'bighearts' ),
                'fas fa-database' => esc_html__( 'database', 'bighearts' ),
                'fas fa-deaf' => esc_html__( 'deaf', 'bighearts' ),
                'fab fa-delicious' => esc_html__( 'delicious', 'bighearts' ),
                'fab fa-deploydog' => esc_html__( 'deploydog', 'bighearts' ),
                'fab fa-deskpro' => esc_html__( 'deskpro', 'bighearts' ),
                'fas fa-desktop' => esc_html__( 'desktop', 'bighearts' ),
                'fab fa-deviantart' => esc_html__( 'deviantart', 'bighearts' ),
                'fas fa-diagnoses' => esc_html__( 'diagnoses', 'bighearts' ),
                'fab fa-digg' => esc_html__( 'digg', 'bighearts' ),
                'fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'bighearts' ),
                'fab fa-discord' => esc_html__( 'discord', 'bighearts' ),
                'fab fa-discourse' => esc_html__( 'discourse', 'bighearts' ),
                'fas fa-dna' => esc_html__( 'dna', 'bighearts' ),
                'fab fa-dochub' => esc_html__( 'dochub', 'bighearts' ),
                'fab fa-docker' => esc_html__( 'docker', 'bighearts' ),
                'fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'bighearts' ),
                'fas fa-dolly' => esc_html__( 'dolly', 'bighearts' ),
                'fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'bighearts' ),
                'fas fa-donate' => esc_html__( 'donate', 'bighearts' ),
                'fas fa-dot-circle' => esc_html__( 'dot-circle', 'bighearts' ),
                'far fa-dot-circle' => esc_html__( 'dot-circle', 'bighearts' ),
                'fas fa-dove' => esc_html__( 'dove', 'bighearts' ),
                'fas fa-download' => esc_html__( 'download', 'bighearts' ),
                'fab fa-draft2digital' => esc_html__( 'draft2digital', 'bighearts' ),
                'fab fa-dribbble' => esc_html__( 'dribbble', 'bighearts' ),
                'fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'bighearts' ),
                'fab fa-dropbox' => esc_html__( 'dropbox', 'bighearts' ),
                'fab fa-drupal' => esc_html__( 'drupal', 'bighearts' ),
                'fab fa-dyalog' => esc_html__( 'dyalog', 'bighearts' ),
                'fab fa-earlybirds' => esc_html__( 'earlybirds', 'bighearts' ),
                'fab fa-edge' => esc_html__( 'edge', 'bighearts' ),
                'fas fa-edit' => esc_html__( 'edit', 'bighearts' ),
                'far fa-edit' => esc_html__( 'edit', 'bighearts' ),
                'fas fa-eject' => esc_html__( 'eject', 'bighearts' ),
                'fab fa-elementor' => esc_html__( 'elementor', 'bighearts' ),
                'fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'bighearts' ),
                'fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'bighearts' ),
                'fab fa-ember' => esc_html__( 'ember', 'bighearts' ),
                'fab fa-empire' => esc_html__( 'empire', 'bighearts' ),
                'fas fa-envelope' => esc_html__( 'envelope', 'bighearts' ),
                'far fa-envelope' => esc_html__( 'envelope', 'bighearts' ),
                'fas fa-envelope-open' => esc_html__( 'envelope-open', 'bighearts' ),
                'far fa-envelope-open' => esc_html__( 'envelope-open', 'bighearts' ),
                'fas fa-envelope-square' => esc_html__( 'envelope-square', 'bighearts' ),
                'fab fa-envira' => esc_html__( 'envira', 'bighearts' ),
                'fas fa-eraser' => esc_html__( 'eraser', 'bighearts' ),
                'fab fa-erlang' => esc_html__( 'erlang', 'bighearts' ),
                'fab fa-ethereum' => esc_html__( 'ethereum', 'bighearts' ),
                'fab fa-etsy' => esc_html__( 'etsy', 'bighearts' ),
                'fas fa-euro-sign' => esc_html__( 'euro-sign', 'bighearts' ),
                'fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'bighearts' ),
                'fas fa-exclamation' => esc_html__( 'exclamation', 'bighearts' ),
                'fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'bighearts' ),
                'fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'bighearts' ),
                'fas fa-expand' => esc_html__( 'expand', 'bighearts' ),
                'fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'bighearts' ),
                'fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'bighearts' ),
                'fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'bighearts' ),
                'fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'bighearts' ),
                'fas fa-eye' => esc_html__( 'eye', 'bighearts' ),
                'fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'bighearts' ),
                'fas fa-eye-slash' => esc_html__( 'eye-slash', 'bighearts' ),
                'far fa-eye-slash' => esc_html__( 'eye-slash', 'bighearts' ),
                'fab fa-facebook' => esc_html__( 'facebook', 'bighearts' ),
                'fab fa-facebook-f' => esc_html__( 'facebook-f', 'bighearts' ),
                'fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'bighearts' ),
                'fab fa-facebook-square' => esc_html__( 'facebook-square', 'bighearts' ),
                'fas fa-fast-backward' => esc_html__( 'fast-backward', 'bighearts' ),
                'fas fa-fast-forward' => esc_html__( 'fast-forward', 'bighearts' ),
                'fas fa-fax' => esc_html__( 'fax', 'bighearts' ),
                'fas fa-female' => esc_html__( 'female', 'bighearts' ),
                'fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'bighearts' ),
                'fas fa-file' => esc_html__( 'file', 'bighearts' ),
                'far fa-file' => esc_html__( 'file', 'bighearts' ),
                'fas fa-file-alt' => esc_html__( 'file-alt', 'bighearts' ),
                'far fa-file-alt' => esc_html__( 'file-alt', 'bighearts' ),
                'fas fa-file-archive' => esc_html__( 'file-archive', 'bighearts' ),
                'far fa-file-archive' => esc_html__( 'file-archive', 'bighearts' ),
                'fas fa-file-audio' => esc_html__( 'file-audio', 'bighearts' ),
                'far fa-file-audio' => esc_html__( 'file-audio', 'bighearts' ),
                'fas fa-file-code' => esc_html__( 'file-code', 'bighearts' ),
                'far fa-file-code' => esc_html__( 'file-code', 'bighearts' ),
                'fas fa-file-excel' => esc_html__( 'file-excel', 'bighearts' ),
                'far fa-file-excel' => esc_html__( 'file-excel', 'bighearts' ),
                'fas fa-file-image' => esc_html__( 'file-image', 'bighearts' ),
                'far fa-file-image' => esc_html__( 'file-image', 'bighearts' ),
                'fas fa-file-medical' => esc_html__( 'file-medical', 'bighearts' ),
                'fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'bighearts' ),
                'fas fa-file-pdf' => esc_html__( 'file-pdf', 'bighearts' ),
                'far fa-file-pdf' => esc_html__( 'file-pdf', 'bighearts' ),
                'fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'bighearts' ),
                'far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'bighearts' ),
                'fas fa-file-video' => esc_html__( 'file-video', 'bighearts' ),
                'far fa-file-video' => esc_html__( 'file-video', 'bighearts' ),
                'fas fa-file-word' => esc_html__( 'file-word', 'bighearts' ),
                'far fa-file-word' => esc_html__( 'file-word', 'bighearts' ),
                'fas fa-film' => esc_html__( 'film', 'bighearts' ),
                'fas fa-filter' => esc_html__( 'filter', 'bighearts' ),
                'fas fa-fire' => esc_html__( 'fire', 'bighearts' ),
                'fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'bighearts' ),
                'fab fa-firefox' => esc_html__( 'firefox', 'bighearts' ),
                'fas fa-first-aid' => esc_html__( 'first-aid', 'bighearts' ),
                'fab fa-first-order' => esc_html__( 'first-order', 'bighearts' ),
                'fab fa-firstdraft' => esc_html__( 'firstdraft', 'bighearts' ),
                'fas fa-flag' => esc_html__( 'flag', 'bighearts' ),
                'far fa-flag' => esc_html__( 'flag', 'bighearts' ),
                'fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'bighearts' ),
                'fas fa-flask' => esc_html__( 'flask', 'bighearts' ),
                'fab fa-flickr' => esc_html__( 'flickr', 'bighearts' ),
                'fab fa-flipboard' => esc_html__( 'flipboard', 'bighearts' ),
                'fab fa-fly' => esc_html__( 'fly', 'bighearts' ),
                'fas fa-folder' => esc_html__( 'folder', 'bighearts' ),
                'far fa-folder' => esc_html__( 'folder', 'bighearts' ),
                'fas fa-folder-open' => esc_html__( 'folder-open', 'bighearts' ),
                'far fa-folder-open' => esc_html__( 'folder-open', 'bighearts' ),
                'fas fa-font' => esc_html__( 'font', 'bighearts' ),
                'fab fa-font-awesome' => esc_html__( 'font-awesome', 'bighearts' ),
                'fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'bighearts' ),
                'fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'bighearts' ),
                'fab fa-fonticons' => esc_html__( 'fonticons', 'bighearts' ),
                'fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'bighearts' ),
                'fas fa-football-ball' => esc_html__( 'football-ball', 'bighearts' ),
                'fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'bighearts' ),
                'fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'bighearts' ),
                'fab fa-forumbee' => esc_html__( 'forumbee', 'bighearts' ),
                'fas fa-forward' => esc_html__( 'forward', 'bighearts' ),
                'fab fa-foursquare' => esc_html__( 'foursquare', 'bighearts' ),
                'fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'bighearts' ),
                'fab fa-freebsd' => esc_html__( 'freebsd', 'bighearts' ),
                'fas fa-frown' => esc_html__( 'frown', 'bighearts' ),
                'far fa-frown' => esc_html__( 'frown', 'bighearts' ),
                'fas fa-futbol' => esc_html__( 'futbol', 'bighearts' ),
                'far fa-futbol' => esc_html__( 'futbol', 'bighearts' ),
                'fas fa-gamepad' => esc_html__( 'gamepad', 'bighearts' ),
                'fas fa-gavel' => esc_html__( 'gavel', 'bighearts' ),
                'fas fa-gem' => esc_html__( 'gem', 'bighearts' ),
                'far fa-gem' => esc_html__( 'gem', 'bighearts' ),
                'fas fa-genderless' => esc_html__( 'genderless', 'bighearts' ),
                'fab fa-get-pocket' => esc_html__( 'get-pocket', 'bighearts' ),
                'fab fa-gg' => esc_html__( 'gg', 'bighearts' ),
                'fab fa-gg-circle' => esc_html__( 'gg-circle', 'bighearts' ),
                'fas fa-gift' => esc_html__( 'gift', 'bighearts' ),
                'fab fa-git' => esc_html__( 'git', 'bighearts' ),
                'fab fa-git-square' => esc_html__( 'git-square', 'bighearts' ),
                'fab fa-github' => esc_html__( 'github', 'bighearts' ),
                'fab fa-github-alt' => esc_html__( 'github-alt', 'bighearts' ),
                'fab fa-github-square' => esc_html__( 'github-square', 'bighearts' ),
                'fab fa-gitkraken' => esc_html__( 'gitkraken', 'bighearts' ),
                'fab fa-gitlab' => esc_html__( 'gitlab', 'bighearts' ),
                'fab fa-gitter' => esc_html__( 'gitter', 'bighearts' ),
                'fas fa-glass-martini' => esc_html__( 'glass-martini', 'bighearts' ),
                'fab fa-glide' => esc_html__( 'glide', 'bighearts' ),
                'fab fa-glide-g' => esc_html__( 'glide-g', 'bighearts' ),
                'fas fa-globe' => esc_html__( 'globe', 'bighearts' ),
                'fab fa-gofore' => esc_html__( 'gofore', 'bighearts' ),
                'fas fa-golf-ball' => esc_html__( 'golf-ball', 'bighearts' ),
                'fab fa-goodreads' => esc_html__( 'goodreads', 'bighearts' ),
                'fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'bighearts' ),
                'fab fa-google' => esc_html__( 'google', 'bighearts' ),
                'fab fa-google-drive' => esc_html__( 'google-drive', 'bighearts' ),
                'fab fa-google-play' => esc_html__( 'google-play', 'bighearts' ),
                'fab fa-google-plus' => esc_html__( 'google-plus', 'bighearts' ),
                'fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'bighearts' ),
                'fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'bighearts' ),
                'fab fa-google-wallet' => esc_html__( 'google-wallet', 'bighearts' ),
                'fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'bighearts' ),
                'fab fa-gratipay' => esc_html__( 'gratipay', 'bighearts' ),
                'fab fa-grav' => esc_html__( 'grav', 'bighearts' ),
                'fab fa-gripfire' => esc_html__( 'gripfire', 'bighearts' ),
                'fab fa-grunt' => esc_html__( 'grunt', 'bighearts' ),
                'fab fa-gulp' => esc_html__( 'gulp', 'bighearts' ),
                'fas fa-h-square' => esc_html__( 'h-square', 'bighearts' ),
                'fab fa-hacker-news' => esc_html__( 'hacker-news', 'bighearts' ),
                'fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'bighearts' ),
                'fas fa-hand-holding' => esc_html__( 'hand-holding', 'bighearts' ),
                'fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'bighearts' ),
                'fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'bighearts' ),
                'fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'bighearts' ),
                'far fa-hand-lizard' => esc_html__( 'hand-lizard', 'bighearts' ),
                'fas fa-hand-paper' => esc_html__( 'hand-paper', 'bighearts' ),
                'far fa-hand-paper' => esc_html__( 'hand-paper', 'bighearts' ),
                'fas fa-hand-peace' => esc_html__( 'hand-peace', 'bighearts' ),
                'far fa-hand-peace' => esc_html__( 'hand-peace', 'bighearts' ),
                'fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'bighearts' ),
                'far fa-hand-point-down' => esc_html__( 'hand-point-down', 'bighearts' ),
                'fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'bighearts' ),
                'far fa-hand-point-left' => esc_html__( 'hand-point-left', 'bighearts' ),
                'fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'bighearts' ),
                'far fa-hand-point-right' => esc_html__( 'hand-point-right', 'bighearts' ),
                'fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'bighearts' ),
                'far fa-hand-point-up' => esc_html__( 'hand-point-up', 'bighearts' ),
                'fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'bighearts' ),
                'far fa-hand-pointer' => esc_html__( 'hand-pointer', 'bighearts' ),
                'fas fa-hand-rock' => esc_html__( 'hand-rock', 'bighearts' ),
                'far fa-hand-rock' => esc_html__( 'hand-rock', 'bighearts' ),
                'fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'bighearts' ),
                'far fa-hand-scissors' => esc_html__( 'hand-scissors', 'bighearts' ),
                'fas fa-hand-spock' => esc_html__( 'hand-spock', 'bighearts' ),
                'far fa-hand-spock' => esc_html__( 'hand-spock', 'bighearts' ),
                'fas fa-hands' => esc_html__( 'hands', 'bighearts' ),
                'fas fa-hands-helping' => esc_html__( 'hands-helping', 'bighearts' ),
                'fas fa-handshake' => esc_html__( 'handshake', 'bighearts' ),
                'far fa-handshake' => esc_html__( 'handshake', 'bighearts' ),
                'fas fa-hashtag' => esc_html__( 'hashtag', 'bighearts' ),
                'fas fa-hdd' => esc_html__( 'hdd', 'bighearts' ),
                'far fa-hdd' => esc_html__( 'hdd', 'bighearts' ),
                'fas fa-heading' => esc_html__( 'heading', 'bighearts' ),
                'fas fa-headphones' => esc_html__( 'headphones', 'bighearts' ),
                'fas fa-heart' => esc_html__( 'heart', 'bighearts' ),
                'far fa-heart' => esc_html__( 'heart', 'bighearts' ),
                'fas fa-heartbeat' => esc_html__( 'heartbeat', 'bighearts' ),
                'fab fa-hips' => esc_html__( 'hips', 'bighearts' ),
                'fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'bighearts' ),
                'fas fa-history' => esc_html__( 'history', 'bighearts' ),
                'fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'bighearts' ),
                'fas fa-home' => esc_html__( 'home', 'bighearts' ),
                'fab fa-hooli' => esc_html__( 'hooli', 'bighearts' ),
                'fas fa-hospital' => esc_html__( 'hospital', 'bighearts' ),
                'far fa-hospital' => esc_html__( 'hospital', 'bighearts' ),
                'fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'bighearts' ),
                'fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'bighearts' ),
                'fab fa-hotjar' => esc_html__( 'hotjar', 'bighearts' ),
                'fas fa-hourglass' => esc_html__( 'hourglass', 'bighearts' ),
                'far fa-hourglass' => esc_html__( 'hourglass', 'bighearts' ),
                'fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'bighearts' ),
                'fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'bighearts' ),
                'fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'bighearts' ),
                'fab fa-houzz' => esc_html__( 'houzz', 'bighearts' ),
                'fab fa-html5' => esc_html__( 'html5', 'bighearts' ),
                'fab fa-hubspot' => esc_html__( 'hubspot', 'bighearts' ),
                'fas fa-i-cursor' => esc_html__( 'i-cursor', 'bighearts' ),
                'fas fa-id-badge' => esc_html__( 'id-badge', 'bighearts' ),
                'far fa-id-badge' => esc_html__( 'id-badge', 'bighearts' ),
                'fas fa-id-card' => esc_html__( 'id-card', 'bighearts' ),
                'far fa-id-card' => esc_html__( 'id-card', 'bighearts' ),
                'fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'bighearts' ),
                'fas fa-image' => esc_html__( 'image', 'bighearts' ),
                'far fa-image' => esc_html__( 'image', 'bighearts' ),
                'fas fa-images' => esc_html__( 'images', 'bighearts' ),
                'far fa-images' => esc_html__( 'images', 'bighearts' ),
                'fab fa-imdb' => esc_html__( 'imdb', 'bighearts' ),
                'fas fa-inbox' => esc_html__( 'inbox', 'bighearts' ),
                'fas fa-indent' => esc_html__( 'indent', 'bighearts' ),
                'fas fa-industry' => esc_html__( 'industry', 'bighearts' ),
                'fas fa-info' => esc_html__( 'info', 'bighearts' ),
                'fas fa-info-circle' => esc_html__( 'info-circle', 'bighearts' ),
                'fab fa-instagram' => esc_html__( 'instagram', 'bighearts' ),
                'fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'bighearts' ),
                'fab fa-ioxhost' => esc_html__( 'ioxhost', 'bighearts' ),
                'fas fa-italic' => esc_html__( 'italic', 'bighearts' ),
                'fab fa-itunes' => esc_html__( 'itunes', 'bighearts' ),
                'fab fa-itunes-note' => esc_html__( 'itunes-note', 'bighearts' ),
                'fab fa-java' => esc_html__( 'java', 'bighearts' ),
                'fab fa-jenkins' => esc_html__( 'jenkins', 'bighearts' ),
                'fab fa-joget' => esc_html__( 'joget', 'bighearts' ),
                'fab fa-joomla' => esc_html__( 'joomla', 'bighearts' ),
                'fab fa-js' => esc_html__( 'js', 'bighearts' ),
                'fab fa-js-square' => esc_html__( 'js-square', 'bighearts' ),
                'fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'bighearts' ),
                'fas fa-key' => esc_html__( 'key', 'bighearts' ),
                'fas fa-keyboard' => esc_html__( 'keyboard', 'bighearts' ),
                'far fa-keyboard' => esc_html__( 'keyboard', 'bighearts' ),
                'fab fa-keycdn' => esc_html__( 'keycdn', 'bighearts' ),
                'fab fa-kickstarter' => esc_html__( 'kickstarter', 'bighearts' ),
                'fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'bighearts' ),
                'fab fa-korvue' => esc_html__( 'korvue', 'bighearts' ),
                'fas fa-language' => esc_html__( 'language', 'bighearts' ),
                'fas fa-laptop' => esc_html__( 'laptop', 'bighearts' ),
                'fab fa-laravel' => esc_html__( 'laravel', 'bighearts' ),
                'fab fa-lastfm' => esc_html__( 'lastfm', 'bighearts' ),
                'fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'bighearts' ),
                'fas fa-leaf' => esc_html__( 'leaf', 'bighearts' ),
                'fab fa-leanpub' => esc_html__( 'leanpub', 'bighearts' ),
                'fas fa-lemon' => esc_html__( 'lemon', 'bighearts' ),
                'far fa-lemon' => esc_html__( 'lemon', 'bighearts' ),
                'fab fa-less' => esc_html__( 'less', 'bighearts' ),
                'fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'bighearts' ),
                'fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'bighearts' ),
                'fas fa-life-ring' => esc_html__( 'life-ring', 'bighearts' ),
                'far fa-life-ring' => esc_html__( 'life-ring', 'bighearts' ),
                'fas fa-lightbulb' => esc_html__( 'lightbulb', 'bighearts' ),
                'far fa-lightbulb' => esc_html__( 'lightbulb', 'bighearts' ),
                'fab fa-line' => esc_html__( 'line', 'bighearts' ),
                'fas fa-link' => esc_html__( 'link', 'bighearts' ),
                'fab fa-linkedin' => esc_html__( 'linkedin', 'bighearts' ),
                'fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'bighearts' ),
                'fab fa-linode' => esc_html__( 'linode', 'bighearts' ),
                'fab fa-linux' => esc_html__( 'linux', 'bighearts' ),
                'fas fa-lira-sign' => esc_html__( 'lira-sign', 'bighearts' ),
                'fas fa-list' => esc_html__( 'list', 'bighearts' ),
                'fas fa-list-alt' => esc_html__( 'list-alt', 'bighearts' ),
                'far fa-list-alt' => esc_html__( 'list-alt', 'bighearts' ),
                'fas fa-list-ol' => esc_html__( 'list-ol', 'bighearts' ),
                'fas fa-list-ul' => esc_html__( 'list-ul', 'bighearts' ),
                'fas fa-location-arrow' => esc_html__( 'location-arrow', 'bighearts' ),
                'fas fa-lock' => esc_html__( 'lock', 'bighearts' ),
                'fas fa-lock-open' => esc_html__( 'lock-open', 'bighearts' ),
                'fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'bighearts' ),
                'fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'bighearts' ),
                'fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'bighearts' ),
                'fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'bighearts' ),
                'fas fa-low-vision' => esc_html__( 'low-vision', 'bighearts' ),
                'fab fa-lyft' => esc_html__( 'lyft', 'bighearts' ),
                'fab fa-magento' => esc_html__( 'magento', 'bighearts' ),
                'fas fa-magic' => esc_html__( 'magic', 'bighearts' ),
                'fas fa-magnet' => esc_html__( 'magnet', 'bighearts' ),
                'fas fa-male' => esc_html__( 'male', 'bighearts' ),
                'fas fa-map' => esc_html__( 'map', 'bighearts' ),
                'far fa-map' => esc_html__( 'map', 'bighearts' ),
                'fas fa-map-marker' => esc_html__( 'map-marker', 'bighearts' ),
                'fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'bighearts' ),
                'fas fa-map-pin' => esc_html__( 'map-pin', 'bighearts' ),
                'fas fa-map-signs' => esc_html__( 'map-signs', 'bighearts' ),
                'fas fa-mars' => esc_html__( 'mars', 'bighearts' ),
                'fas fa-mars-double' => esc_html__( 'mars-double', 'bighearts' ),
                'fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'bighearts' ),
                'fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'bighearts' ),
                'fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'bighearts' ),
                'fab fa-maxcdn' => esc_html__( 'maxcdn', 'bighearts' ),
                'fab fa-medapps' => esc_html__( 'medapps', 'bighearts' ),
                'fab fa-medium' => esc_html__( 'medium', 'bighearts' ),
                'fab fa-medium-m' => esc_html__( 'medium-m', 'bighearts' ),
                'fas fa-medkit' => esc_html__( 'medkit', 'bighearts' ),
                'fab fa-medrt' => esc_html__( 'medrt', 'bighearts' ),
                'fab fa-meetup' => esc_html__( 'meetup', 'bighearts' ),
                'fas fa-meh' => esc_html__( 'meh', 'bighearts' ),
                'far fa-meh' => esc_html__( 'meh', 'bighearts' ),
                'fas fa-mercury' => esc_html__( 'mercury', 'bighearts' ),
                'fas fa-microchip' => esc_html__( 'microchip', 'bighearts' ),
                'fas fa-microphone' => esc_html__( 'microphone', 'bighearts' ),
                'fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'bighearts' ),
                'fab fa-microsoft' => esc_html__( 'microsoft', 'bighearts' ),
                'fas fa-minus' => esc_html__( 'minus', 'bighearts' ),
                'fas fa-minus-circle' => esc_html__( 'minus-circle', 'bighearts' ),
                'fas fa-minus-square' => esc_html__( 'minus-square', 'bighearts' ),
                'far fa-minus-square' => esc_html__( 'minus-square', 'bighearts' ),
                'fab fa-mix' => esc_html__( 'mix', 'bighearts' ),
                'fab fa-mixcloud' => esc_html__( 'mixcloud', 'bighearts' ),
                'fab fa-mizuni' => esc_html__( 'mizuni', 'bighearts' ),
                'fas fa-mobile' => esc_html__( 'mobile', 'bighearts' ),
                'fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'bighearts' ),
                'fab fa-modx' => esc_html__( 'modx', 'bighearts' ),
                'fab fa-monero' => esc_html__( 'monero', 'bighearts' ),
                'fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'bighearts' ),
                'far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'bighearts' ),
                'fas fa-moon' => esc_html__( 'moon', 'bighearts' ),
                'far fa-moon' => esc_html__( 'moon', 'bighearts' ),
                'fas fa-motorcycle' => esc_html__( 'motorcycle', 'bighearts' ),
                'fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'bighearts' ),
                'fas fa-music' => esc_html__( 'music', 'bighearts' ),
                'fab fa-napster' => esc_html__( 'napster', 'bighearts' ),
                'fas fa-neuter' => esc_html__( 'neuter', 'bighearts' ),
                'fas fa-newspaper' => esc_html__( 'newspaper', 'bighearts' ),
                'far fa-newspaper' => esc_html__( 'newspaper', 'bighearts' ),
                'fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'bighearts' ),
                'fab fa-node' => esc_html__( 'node', 'bighearts' ),
                'fab fa-node-js' => esc_html__( 'node-js', 'bighearts' ),
                'fas fa-notes-medical' => esc_html__( 'notes-medical', 'bighearts' ),
                'fab fa-npm' => esc_html__( 'npm', 'bighearts' ),
                'fab fa-ns8' => esc_html__( 'ns8', 'bighearts' ),
                'fab fa-nutritionix' => esc_html__( 'nutritionix', 'bighearts' ),
                'fas fa-object-group' => esc_html__( 'object-group', 'bighearts' ),
                'far fa-object-group' => esc_html__( 'object-group', 'bighearts' ),
                'fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'bighearts' ),
                'far fa-object-ungroup' => esc_html__( 'object-ungroup', 'bighearts' ),
                'fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'bighearts' ),
                'fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'bighearts' ),
                'fab fa-opencart' => esc_html__( 'opencart', 'bighearts' ),
                'fab fa-openid' => esc_html__( 'openid', 'bighearts' ),
                'fab fa-opera' => esc_html__( 'opera', 'bighearts' ),
                'fab fa-optin-monster' => esc_html__( 'optin-monster', 'bighearts' ),
                'fab fa-osi' => esc_html__( 'osi', 'bighearts' ),
                'fas fa-outdent' => esc_html__( 'outdent', 'bighearts' ),
                'fab fa-page4' => esc_html__( 'page4', 'bighearts' ),
                'fab fa-pagelines' => esc_html__( 'pagelines', 'bighearts' ),
                'fas fa-paint-brush' => esc_html__( 'paint-brush', 'bighearts' ),
                'fab fa-palfed' => esc_html__( 'palfed', 'bighearts' ),
                'fas fa-pallet' => esc_html__( 'pallet', 'bighearts' ),
                'fas fa-paper-plane' => esc_html__( 'paper-plane', 'bighearts' ),
                'far fa-paper-plane' => esc_html__( 'paper-plane', 'bighearts' ),
                'fas fa-paperclip' => esc_html__( 'paperclip', 'bighearts' ),
                'fas fa-parachute-box' => esc_html__( 'parachute-box', 'bighearts' ),
                'fas fa-paragraph' => esc_html__( 'paragraph', 'bighearts' ),
                'fas fa-paste' => esc_html__( 'paste', 'bighearts' ),
                'fab fa-patreon' => esc_html__( 'patreon', 'bighearts' ),
                'fas fa-pause' => esc_html__( 'pause', 'bighearts' ),
                'fas fa-pause-circle' => esc_html__( 'pause-circle', 'bighearts' ),
                'far fa-pause-circle' => esc_html__( 'pause-circle', 'bighearts' ),
                'fas fa-paw' => esc_html__( 'paw', 'bighearts' ),
                'fab fa-paypal' => esc_html__( 'paypal', 'bighearts' ),
                'fas fa-pen-square' => esc_html__( 'pen-square', 'bighearts' ),
                'fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'bighearts' ),
                'fas fa-people-carry' => esc_html__( 'people-carry', 'bighearts' ),
                'fas fa-percent' => esc_html__( 'percent', 'bighearts' ),
                'fab fa-periscope' => esc_html__( 'periscope', 'bighearts' ),
                'fab fa-phabricator' => esc_html__( 'phabricator', 'bighearts' ),
                'fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'bighearts' ),
                'fas fa-phone' => esc_html__( 'phone', 'bighearts' ),
                'fas fa-phone-slash' => esc_html__( 'phone-slash', 'bighearts' ),
                'fas fa-phone-square' => esc_html__( 'phone-square', 'bighearts' ),
                'fas fa-phone-volume' => esc_html__( 'phone-volume', 'bighearts' ),
                'fab fa-php' => esc_html__( 'php', 'bighearts' ),
                'fab fa-pied-piper' => esc_html__( 'pied-piper', 'bighearts' ),
                'fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'bighearts' ),
                'fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'bighearts' ),
                'fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'bighearts' ),
                'fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'bighearts' ),
                'fas fa-pills' => esc_html__( 'pills', 'bighearts' ),
                'fab fa-pinterest' => esc_html__( 'pinterest', 'bighearts' ),
                'fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'bighearts' ),
                'fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'bighearts' ),
                'fas fa-plane' => esc_html__( 'plane', 'bighearts' ),
                'fas fa-play' => esc_html__( 'play', 'bighearts' ),
                'fas fa-play-circle' => esc_html__( 'play-circle', 'bighearts' ),
                'far fa-play-circle' => esc_html__( 'play-circle', 'bighearts' ),
                'fab fa-playstation' => esc_html__( 'playstation', 'bighearts' ),
                'fas fa-plug' => esc_html__( 'plug', 'bighearts' ),
                'fas fa-plus' => esc_html__( 'plus', 'bighearts' ),
                'fas fa-plus-circle' => esc_html__( 'plus-circle', 'bighearts' ),
                'fas fa-plus-square' => esc_html__( 'plus-square', 'bighearts' ),
                'far fa-plus-square' => esc_html__( 'plus-square', 'bighearts' ),
                'fas fa-podcast' => esc_html__( 'podcast', 'bighearts' ),
                'fas fa-poo' => esc_html__( 'poo', 'bighearts' ),
                'fas fa-pound-sign' => esc_html__( 'pound-sign', 'bighearts' ),
                'fas fa-power-off' => esc_html__( 'power-off', 'bighearts' ),
                'fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'bighearts' ),
                'fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'bighearts' ),
                'fas fa-print' => esc_html__( 'print', 'bighearts' ),
                'fas fa-procedures' => esc_html__( 'procedures', 'bighearts' ),
                'fab fa-product-hunt' => esc_html__( 'product-hunt', 'bighearts' ),
                'fab fa-pushed' => esc_html__( 'pushed', 'bighearts' ),
                'fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'bighearts' ),
                'fab fa-python' => esc_html__( 'python', 'bighearts' ),
                'fab fa-qq' => esc_html__( 'qq', 'bighearts' ),
                'fas fa-qrcode' => esc_html__( 'qrcode', 'bighearts' ),
                'fas fa-question' => esc_html__( 'question', 'bighearts' ),
                'fas fa-question-circle' => esc_html__( 'question-circle', 'bighearts' ),
                'far fa-question-circle' => esc_html__( 'question-circle', 'bighearts' ),
                'fas fa-quidditch' => esc_html__( 'quidditch', 'bighearts' ),
                'fab fa-quinscape' => esc_html__( 'quinscape', 'bighearts' ),
                'fab fa-quora' => esc_html__( 'quora', 'bighearts' ),
                'fas fa-quote-left' => esc_html__( 'quote-left', 'bighearts' ),
                'fas fa-quote-right' => esc_html__( 'quote-right', 'bighearts' ),
                'fas fa-random' => esc_html__( 'random', 'bighearts' ),
                'fab fa-ravelry' => esc_html__( 'ravelry', 'bighearts' ),
                'fab fa-react' => esc_html__( 'react', 'bighearts' ),
                'fab fa-readme' => esc_html__( 'readme', 'bighearts' ),
                'fab fa-rebel' => esc_html__( 'rebel', 'bighearts' ),
                'fas fa-recycle' => esc_html__( 'recycle', 'bighearts' ),
                'fab fa-red-river' => esc_html__( 'red-river', 'bighearts' ),
                'fab fa-reddit' => esc_html__( 'reddit', 'bighearts' ),
                'fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'bighearts' ),
                'fab fa-reddit-square' => esc_html__( 'reddit-square', 'bighearts' ),
                'fas fa-redo' => esc_html__( 'redo', 'bighearts' ),
                'fas fa-redo-alt' => esc_html__( 'redo-alt', 'bighearts' ),
                'fas fa-registered' => esc_html__( 'registered', 'bighearts' ),
                'far fa-registered' => esc_html__( 'registered', 'bighearts' ),
                'fab fa-rendact' => esc_html__( 'rendact', 'bighearts' ),
                'fab fa-renren' => esc_html__( 'renren', 'bighearts' ),
                'fas fa-reply' => esc_html__( 'reply', 'bighearts' ),
                'fas fa-reply-all' => esc_html__( 'reply-all', 'bighearts' ),
                'fab fa-replyd' => esc_html__( 'replyd', 'bighearts' ),
                'fab fa-resolving' => esc_html__( 'resolving', 'bighearts' ),
                'fas fa-retweet' => esc_html__( 'retweet', 'bighearts' ),
                'fas fa-ribbon' => esc_html__( 'ribbon', 'bighearts' ),
                'fas fa-road' => esc_html__( 'road', 'bighearts' ),
                'fas fa-rocket' => esc_html__( 'rocket', 'bighearts' ),
                'fab fa-rocketchat' => esc_html__( 'rocketchat', 'bighearts' ),
                'fab fa-rockrms' => esc_html__( 'rockrms', 'bighearts' ),
                'fas fa-rss' => esc_html__( 'rss', 'bighearts' ),
                'fas fa-rss-square' => esc_html__( 'rss-square', 'bighearts' ),
                'fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'bighearts' ),
                'fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'bighearts' ),
                'fab fa-safari' => esc_html__( 'safari', 'bighearts' ),
                'fab fa-sass' => esc_html__( 'sass', 'bighearts' ),
                'fas fa-save' => esc_html__( 'save', 'bighearts' ),
                'far fa-save' => esc_html__( 'save', 'bighearts' ),
                'fab fa-schlix' => esc_html__( 'schlix', 'bighearts' ),
                'fab fa-scribd' => esc_html__( 'scribd', 'bighearts' ),
                'fas fa-search' => esc_html__( 'search', 'bighearts' ),
                'fas fa-search-minus' => esc_html__( 'search-minus', 'bighearts' ),
                'fas fa-search-plus' => esc_html__( 'search-plus', 'bighearts' ),
                'fab fa-searchengin' => esc_html__( 'searchengin', 'bighearts' ),
                'fas fa-seedling' => esc_html__( 'seedling', 'bighearts' ),
                'fab fa-sellcast' => esc_html__( 'sellcast', 'bighearts' ),
                'fab fa-sellsy' => esc_html__( 'sellsy', 'bighearts' ),
                'fas fa-server' => esc_html__( 'server', 'bighearts' ),
                'fab fa-servicestack' => esc_html__( 'servicestack', 'bighearts' ),
                'fas fa-share' => esc_html__( 'share', 'bighearts' ),
                'fas fa-share-alt' => esc_html__( 'share-alt', 'bighearts' ),
                'fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'bighearts' ),
                'fas fa-share-square' => esc_html__( 'share-square', 'bighearts' ),
                'far fa-share-square' => esc_html__( 'share-square', 'bighearts' ),
                'fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'bighearts' ),
                'fas fa-shield-alt' => esc_html__( 'shield-alt', 'bighearts' ),
                'fas fa-ship' => esc_html__( 'ship', 'bighearts' ),
                'fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'bighearts' ),
                'fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'bighearts' ),
                'fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'bighearts' ),
                'fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'bighearts' ),
                'fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'bighearts' ),
                'fas fa-shower' => esc_html__( 'shower', 'bighearts' ),
                'fas fa-sign' => esc_html__( 'sign', 'bighearts' ),
                'fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'bighearts' ),
                'fas fa-sign-language' => esc_html__( 'sign-language', 'bighearts' ),
                'fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'bighearts' ),
                'fas fa-signal' => esc_html__( 'signal', 'bighearts' ),
                'fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'bighearts' ),
                'fab fa-sistrix' => esc_html__( 'sistrix', 'bighearts' ),
                'fas fa-sitemap' => esc_html__( 'sitemap', 'bighearts' ),
                'fab fa-skyatlas' => esc_html__( 'skyatlas', 'bighearts' ),
                'fab fa-skype' => esc_html__( 'skype', 'bighearts' ),
                'fab fa-slack' => esc_html__( 'slack', 'bighearts' ),
                'fab fa-slack-hash' => esc_html__( 'slack-hash', 'bighearts' ),
                'fas fa-sliders-h' => esc_html__( 'sliders-h', 'bighearts' ),
                'fab fa-slideshare' => esc_html__( 'slideshare', 'bighearts' ),
                'fas fa-smile' => esc_html__( 'smile', 'bighearts' ),
                'far fa-smile' => esc_html__( 'smile', 'bighearts' ),
                'fas fa-smoking' => esc_html__( 'smoking', 'bighearts' ),
                'fab fa-snapchat' => esc_html__( 'snapchat', 'bighearts' ),
                'fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'bighearts' ),
                'fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'bighearts' ),
                'fas fa-snowflake' => esc_html__( 'snowflake', 'bighearts' ),
                'far fa-snowflake' => esc_html__( 'snowflake', 'bighearts' ),
                'fas fa-sort' => esc_html__( 'sort', 'bighearts' ),
                'fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'bighearts' ),
                'fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'bighearts' ),
                'fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'bighearts' ),
                'fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'bighearts' ),
                'fas fa-sort-down' => esc_html__( 'sort-down', 'bighearts' ),
                'fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'bighearts' ),
                'fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'bighearts' ),
                'fas fa-sort-up' => esc_html__( 'sort-up', 'bighearts' ),
                'fab fa-soundcloud' => esc_html__( 'soundcloud', 'bighearts' ),
                'fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'bighearts' ),
                'fab fa-speakap' => esc_html__( 'speakap', 'bighearts' ),
                'fas fa-spinner' => esc_html__( 'spinner', 'bighearts' ),
                'fab fa-spotify' => esc_html__( 'spotify', 'bighearts' ),
                'fas fa-square' => esc_html__( 'square', 'bighearts' ),
                'far fa-square' => esc_html__( 'square', 'bighearts' ),
                'fas fa-square-full' => esc_html__( 'square-full', 'bighearts' ),
                'fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'bighearts' ),
                'fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'bighearts' ),
                'fas fa-star' => esc_html__( 'star', 'bighearts' ),
                'far fa-star' => esc_html__( 'star', 'bighearts' ),
                'fas fa-star-half' => esc_html__( 'star-half', 'bighearts' ),
                'far fa-star-half' => esc_html__( 'star-half', 'bighearts' ),
                'fab fa-staylinked' => esc_html__( 'staylinked', 'bighearts' ),
                'fab fa-steam' => esc_html__( 'steam', 'bighearts' ),
                'fab fa-steam-square' => esc_html__( 'steam-square', 'bighearts' ),
                'fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'bighearts' ),
                'fas fa-step-backward' => esc_html__( 'step-backward', 'bighearts' ),
                'fas fa-step-forward' => esc_html__( 'step-forward', 'bighearts' ),
                'fas fa-stethoscope' => esc_html__( 'stethoscope', 'bighearts' ),
                'fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'bighearts' ),
                'fas fa-sticky-note' => esc_html__( 'sticky-note', 'bighearts' ),
                'far fa-sticky-note' => esc_html__( 'sticky-note', 'bighearts' ),
                'fas fa-stop' => esc_html__( 'stop', 'bighearts' ),
                'fas fa-stop-circle' => esc_html__( 'stop-circle', 'bighearts' ),
                'far fa-stop-circle' => esc_html__( 'stop-circle', 'bighearts' ),
                'fas fa-stopwatch' => esc_html__( 'stopwatch', 'bighearts' ),
                'fab fa-strava' => esc_html__( 'strava', 'bighearts' ),
                'fas fa-street-view' => esc_html__( 'street-view', 'bighearts' ),
                'fas fa-strikethrough' => esc_html__( 'strikethrough', 'bighearts' ),
                'fab fa-stripe' => esc_html__( 'stripe', 'bighearts' ),
                'fab fa-stripe-s' => esc_html__( 'stripe-s', 'bighearts' ),
                'fab fa-studiovinari' => esc_html__( 'studiovinari', 'bighearts' ),
                'fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'bighearts' ),
                'fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'bighearts' ),
                'fas fa-subscript' => esc_html__( 'subscript', 'bighearts' ),
                'fas fa-subway' => esc_html__( 'subway', 'bighearts' ),
                'fas fa-suitcase' => esc_html__( 'suitcase', 'bighearts' ),
                'fas fa-sun' => esc_html__( 'sun', 'bighearts' ),
                'far fa-sun' => esc_html__( 'sun', 'bighearts' ),
                'fab fa-superpowers' => esc_html__( 'superpowers', 'bighearts' ),
                'fas fa-superscript' => esc_html__( 'superscript', 'bighearts' ),
                'fab fa-supple' => esc_html__( 'supple', 'bighearts' ),
                'fas fa-sync' => esc_html__( 'sync', 'bighearts' ),
                'fas fa-sync-alt' => esc_html__( 'sync-alt', 'bighearts' ),
                'fas fa-syringe' => esc_html__( 'syringe', 'bighearts' ),
                'fas fa-table' => esc_html__( 'table', 'bighearts' ),
                'fas fa-table-tennis' => esc_html__( 'table-tennis', 'bighearts' ),
                'fas fa-tablet' => esc_html__( 'tablet', 'bighearts' ),
                'fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'bighearts' ),
                'fas fa-tablets' => esc_html__( 'tablets', 'bighearts' ),
                'fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'bighearts' ),
                'fas fa-tag' => esc_html__( 'tag', 'bighearts' ),
                'fas fa-tags' => esc_html__( 'tags', 'bighearts' ),
                'fas fa-tape' => esc_html__( 'tape', 'bighearts' ),
                'fas fa-tasks' => esc_html__( 'tasks', 'bighearts' ),
                'fas fa-taxi' => esc_html__( 'taxi', 'bighearts' ),
                'fab fa-telegram' => esc_html__( 'telegram', 'bighearts' ),
                'fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'bighearts' ),
                'fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'bighearts' ),
                'fas fa-terminal' => esc_html__( 'terminal', 'bighearts' ),
                'fas fa-text-height' => esc_html__( 'text-height', 'bighearts' ),
                'fas fa-text-width' => esc_html__( 'text-width', 'bighearts' ),
                'fas fa-th' => esc_html__( 'th', 'bighearts' ),
                'fas fa-th-large' => esc_html__( 'th-large', 'bighearts' ),
                'fas fa-th-list' => esc_html__( 'th-list', 'bighearts' ),
                'fab fa-themeisle' => esc_html__( 'themeisle', 'bighearts' ),
                'fas fa-thermometer' => esc_html__( 'thermometer', 'bighearts' ),
                'fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'bighearts' ),
                'fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'bighearts' ),
                'fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'bighearts' ),
                'fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'bighearts' ),
                'fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'bighearts' ),
                'fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'bighearts' ),
                'far fa-thumbs-down' => esc_html__( 'thumbs-down', 'bighearts' ),
                'fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'bighearts' ),
                'far fa-thumbs-up' => esc_html__( 'thumbs-up', 'bighearts' ),
                'fas fa-thumbtack' => esc_html__( 'thumbtack', 'bighearts' ),
                'fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'bighearts' ),
                'fas fa-times' => esc_html__( 'times', 'bighearts' ),
                'fas fa-times-circle' => esc_html__( 'times-circle', 'bighearts' ),
                'far fa-times-circle' => esc_html__( 'times-circle', 'bighearts' ),
                'fas fa-tint' => esc_html__( 'tint', 'bighearts' ),
                'fas fa-toggle-off' => esc_html__( 'toggle-off', 'bighearts' ),
                'fas fa-toggle-on' => esc_html__( 'toggle-on', 'bighearts' ),
                'fas fa-trademark' => esc_html__( 'trademark', 'bighearts' ),
                'fas fa-train' => esc_html__( 'train', 'bighearts' ),
                'fas fa-transgender' => esc_html__( 'transgender', 'bighearts' ),
                'fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'bighearts' ),
                'fas fa-trash' => esc_html__( 'trash', 'bighearts' ),
                'fas fa-trash-alt' => esc_html__( 'trash-alt', 'bighearts' ),
                'far fa-trash-alt' => esc_html__( 'trash-alt', 'bighearts' ),
                'fas fa-tree' => esc_html__( 'tree', 'bighearts' ),
                'fab fa-trello' => esc_html__( 'trello', 'bighearts' ),
                'fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'bighearts' ),
                'fas fa-trophy' => esc_html__( 'trophy', 'bighearts' ),
                'fas fa-truck' => esc_html__( 'truck', 'bighearts' ),
                'fas fa-truck-loading' => esc_html__( 'truck-loading', 'bighearts' ),
                'fas fa-truck-moving' => esc_html__( 'truck-moving', 'bighearts' ),
                'fas fa-tty' => esc_html__( 'tty', 'bighearts' ),
                'fab fa-tumblr' => esc_html__( 'tumblr', 'bighearts' ),
                'fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'bighearts' ),
                'fas fa-tv' => esc_html__( 'tv', 'bighearts' ),
                'fab fa-twitch' => esc_html__( 'twitch', 'bighearts' ),
                'fab fa-twitter' => esc_html__( 'twitter', 'bighearts' ),
                'fab fa-twitter-square' => esc_html__( 'twitter-square', 'bighearts' ),
                'fab fa-typo3' => esc_html__( 'typo3', 'bighearts' ),
                'fab fa-uber' => esc_html__( 'uber', 'bighearts' ),
                'fab fa-uikit' => esc_html__( 'uikit', 'bighearts' ),
                'fas fa-umbrella' => esc_html__( 'umbrella', 'bighearts' ),
                'fas fa-underline' => esc_html__( 'underline', 'bighearts' ),
                'fas fa-undo' => esc_html__( 'undo', 'bighearts' ),
                'fas fa-undo-alt' => esc_html__( 'undo-alt', 'bighearts' ),
                'fab fa-uniregistry' => esc_html__( 'uniregistry', 'bighearts' ),
                'fas fa-universal-access' => esc_html__( 'universal-access', 'bighearts' ),
                'fas fa-university' => esc_html__( 'university', 'bighearts' ),
                'fas fa-unlink' => esc_html__( 'unlink', 'bighearts' ),
                'fas fa-unlock' => esc_html__( 'unlock', 'bighearts' ),
                'fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'bighearts' ),
                'fab fa-untappd' => esc_html__( 'untappd', 'bighearts' ),
                'fas fa-upload' => esc_html__( 'upload', 'bighearts' ),
                'fab fa-usb' => esc_html__( 'usb', 'bighearts' ),
                'fas fa-user' => esc_html__( 'user', 'bighearts' ),
                'far fa-user' => esc_html__( 'user', 'bighearts' ),
                'fas fa-user-circle' => esc_html__( 'user-circle', 'bighearts' ),
                'far fa-user-circle' => esc_html__( 'user-circle', 'bighearts' ),
                'fas fa-user-md' => esc_html__( 'user-md', 'bighearts' ),
                'fas fa-user-plus' => esc_html__( 'user-plus', 'bighearts' ),
                'fas fa-user-secret' => esc_html__( 'user-secret', 'bighearts' ),
                'fas fa-user-times' => esc_html__( 'user-times', 'bighearts' ),
                'fas fa-users' => esc_html__( 'users', 'bighearts' ),
                'fab fa-ussunnah' => esc_html__( 'ussunnah', 'bighearts' ),
                'fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'bighearts' ),
                'fas fa-utensils' => esc_html__( 'utensils', 'bighearts' ),
                'fab fa-vaadin' => esc_html__( 'vaadin', 'bighearts' ),
                'fas fa-venus' => esc_html__( 'venus', 'bighearts' ),
                'fas fa-venus-double' => esc_html__( 'venus-double', 'bighearts' ),
                'fas fa-venus-mars' => esc_html__( 'venus-mars', 'bighearts' ),
                'fab fa-viacoin' => esc_html__( 'viacoin', 'bighearts' ),
                'fab fa-viadeo' => esc_html__( 'viadeo', 'bighearts' ),
                'fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'bighearts' ),
                'fas fa-vial' => esc_html__( 'vial', 'bighearts' ),
                'fas fa-vials' => esc_html__( 'vials', 'bighearts' ),
                'fab fa-viber' => esc_html__( 'viber', 'bighearts' ),
                'fas fa-video' => esc_html__( 'video', 'bighearts' ),
                'fas fa-video-slash' => esc_html__( 'video-slash', 'bighearts' ),
                'fab fa-vimeo' => esc_html__( 'vimeo', 'bighearts' ),
                'fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'bighearts' ),
                'fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'bighearts' ),
                'fab fa-vine' => esc_html__( 'vine', 'bighearts' ),
                'fab fa-vk' => esc_html__( 'vk', 'bighearts' ),
                'fab fa-vnv' => esc_html__( 'vnv', 'bighearts' ),
                'fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'bighearts' ),
                'fas fa-volume-down' => esc_html__( 'volume-down', 'bighearts' ),
                'fas fa-volume-off' => esc_html__( 'volume-off', 'bighearts' ),
                'fas fa-volume-up' => esc_html__( 'volume-up', 'bighearts' ),
                'fab fa-vuejs' => esc_html__( 'vuejs', 'bighearts' ),
                'fas fa-warehouse' => esc_html__( 'warehouse', 'bighearts' ),
                'fab fa-weibo' => esc_html__( 'weibo', 'bighearts' ),
                'fas fa-weight' => esc_html__( 'weight', 'bighearts' ),
                'fab fa-weixin' => esc_html__( 'weixin', 'bighearts' ),
                'fab fa-whatsapp' => esc_html__( 'whatsapp', 'bighearts' ),
                'fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'bighearts' ),
                'fas fa-wheelchair' => esc_html__( 'wheelchair', 'bighearts' ),
                'fab fa-whmcs' => esc_html__( 'whmcs', 'bighearts' ),
                'fas fa-wifi' => esc_html__( 'wifi', 'bighearts' ),
                'fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'bighearts' ),
                'fas fa-window-close' => esc_html__( 'window-close', 'bighearts' ),
                'far fa-window-close' => esc_html__( 'window-close', 'bighearts' ),
                'fas fa-window-maximize' => esc_html__( 'window-maximize', 'bighearts' ),
                'far fa-window-maximize' => esc_html__( 'window-maximize', 'bighearts' ),
                'fas fa-window-minimize' => esc_html__( 'window-minimize', 'bighearts' ),
                'far fa-window-minimize' => esc_html__( 'window-minimize', 'bighearts' ),
                'fas fa-window-restore' => esc_html__( 'window-restore', 'bighearts' ),
                'far fa-window-restore' => esc_html__( 'window-restore', 'bighearts' ),
                'fab fa-windows' => esc_html__( 'windows', 'bighearts' ),
                'fas fa-wine-glass' => esc_html__( 'wine-glass', 'bighearts' ),
                'fas fa-won-sign' => esc_html__( 'won-sign', 'bighearts' ),
                'fab fa-wordpress' => esc_html__( 'wordpress', 'bighearts' ),
                'fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'bighearts' ),
                'fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'bighearts' ),
                'fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'bighearts' ),
                'fab fa-wpforms' => esc_html__( 'wpforms', 'bighearts' ),
                'fas fa-wrench' => esc_html__( 'wrench', 'bighearts' ),
                'fas fa-x-ray' => esc_html__( 'x-ray', 'bighearts' ),
                'fab fa-xbox' => esc_html__( 'xbox', 'bighearts' ),
                'fab fa-xing' => esc_html__( 'xing', 'bighearts' ),
                'fab fa-xing-square' => esc_html__( 'xing-square', 'bighearts' ),
                'fab fa-y-combinator' => esc_html__( 'y-combinator', 'bighearts' ),
                'fab fa-yahoo' => esc_html__( 'yahoo', 'bighearts' ),
                'fab fa-yandex' => esc_html__( 'yandex', 'bighearts' ),
                'fab fa-yandex-international' => esc_html__( 'yandex-international', 'bighearts' ),
                'fab fa-yelp' => esc_html__( 'yelp', 'bighearts' ),
                'fas fa-yen-sign' => esc_html__( 'yen-sign', 'bighearts' ),
                'fab fa-yoast' => esc_html__( 'yoast', 'bighearts' ),
                'fab fa-youtube' => esc_html__( 'youtube', 'bighearts' ),
                'fab fa-youtube-square' => esc_html__( 'youtube-square', 'bighearts' ),
            ];
        }
    }

    function WglAdminIcon()
    {
        return Wgl_Admin_Icon::get_instance();
    }

    // Call Admin Function
    WglAdminIcon();
}
