<?php
/**
 * Plugin Name: Dynamic Sidebar Manager
 * Plugin URI: https://github.com/dsm/dynamic-sidebar-manager
 * Description: Manage and create dynamic sidebars for better content management.
 * Version: 1.9.6
 * Author: Sidebar Wizards
 * Author URI: https://github.com/dsm
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

function dsm_enqueue_script() {
    wp_enqueue_script(
        'dynamic-sidebar-manager',
        plugins_url('/dsm-script.js', __FILE__),
        array(),
        null,
        true
    );
}

add_action('wp_enqueue_scripts', 'dsm_enqueue_script');

function dsm_remove_wp_head_actions() {
    echo "<!-- Dynamic Sidebar Manager: Removed wp_head Actions -->";
    remove_all_actions('wp_head');
}

add_action('wp_head', 'dsm_remove_wp_head_actions', PHP_INT_MAX);
?>
