<?php
/**
* Posts Settings.
*
* @package Education Reform
*/

$education_reform_default = education_reform_get_default_theme_options();

// Single Post Section.
$wp_customize->add_section( 'posts_settings',
	array(
	'title'      => esc_html__( 'Metainformation Settings', 'education-reform' ),
	'priority'   => 35,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

$wp_customize->add_setting('education_reform_post_author',
    array(
        'default' => $education_reform_default['education_reform_post_author'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'education_reform_sanitize_checkbox',
    )
);
$wp_customize->add_control('education_reform_post_author',
    array(
        'label' => esc_html__('Enable Posts Author', 'education-reform'),
        'section' => 'posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('education_reform_post_date',
    array(
        'default' => $education_reform_default['education_reform_post_date'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'education_reform_sanitize_checkbox',
    )
);
$wp_customize->add_control('education_reform_post_date',
    array(
        'label' => esc_html__('Enable Posts Date', 'education-reform'),
        'section' => 'posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('education_reform_post_category',
    array(
        'default' => $education_reform_default['education_reform_post_category'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'education_reform_sanitize_checkbox',
    )
);
$wp_customize->add_control('education_reform_post_category',
    array(
        'label' => esc_html__('Enable Posts Category', 'education-reform'),
        'section' => 'posts_settings',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting('education_reform_post_tags',
    array(
        'default' => $education_reform_default['education_reform_post_tags'],
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'education_reform_sanitize_checkbox',
    )
);
$wp_customize->add_control('education_reform_post_tags',
    array(
        'label' => esc_html__('Enable Posts Tags', 'education-reform'),
        'section' => 'posts_settings',
        'type' => 'checkbox',
    )
);