<?php
/**
* Header Options.
*
* @package Education Reform
*/

$education_reform_default = education_reform_get_default_theme_options();

// Header Section.
$wp_customize->add_section( 'button_header_setting',
	array(
	'title'      => esc_html__( 'Header Settings', 'education-reform' ),
	'priority'   => 10,
	'capability' => 'edit_theme_options',
	'panel'      => 'theme_option_panel',
	)
);

$wp_customize->add_setting( 'education_reform_header_layout_phone_number',
    array(
    'default'           => $education_reform_default['education_reform_header_layout_phone_number'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'education_reform_header_layout_phone_number',
    array(
    'label'    => esc_html__( 'Header Phone Number', 'education-reform' ),
    'section'  => 'button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'education_reform_header_layout_email_address',
    array(
    'default'           => $education_reform_default['education_reform_header_layout_email_address'],
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control( 'education_reform_header_layout_email_address',
    array(
    'label'    => esc_html__( 'Header Email Address', 'education-reform' ),
    'section'  => 'button_header_setting',
    'type'     => 'text',
    )
);

$wp_customize->add_setting( 'education_reform_header_layout_button_login_link',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'education_reform_header_layout_button_login_link',
    array(
    'label'    => esc_html__( 'Header Login Link', 'education-reform' ),
    'section'  => 'button_header_setting',
    'type'     => 'url',
    )
);

$wp_customize->add_setting( 'education_reform_header_layout_button_register_link',
    array(
    'default'           => '',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control( 'education_reform_header_layout_button_register_link',
    array(
    'label'    => esc_html__( 'Header Register Link', 'education-reform' ),
    'section'  => 'button_header_setting',
    'type'     => 'url',
    )
);