<?php
/**
 * Theme functions and definitions
 *
 * @package Flexea
 */

/**
 * After setup theme hook
 */
function flexea_theme_setup(){
    /*
     * Make child theme available for translation.
     * Translations can be filed in the /languages/ directory.
     */
    load_child_theme_textdomain( 'flexea' );	
}
add_action( 'after_setup_theme', 'flexea_theme_setup' );

/**
 * Load assets.
 */

function flexea_theme_css() {
	wp_enqueue_style( 'flexea-parent-theme-style', get_template_directory_uri() . '/style.css' );
}
add_action( 'wp_enqueue_scripts', 'flexea_theme_css', 99);

require get_stylesheet_directory() . '/theme-functions/controls/class-customize.php';

/**
 * Import Options From Parent Theme
 *
 */
function flexea_parent_theme_options() {
	$atua_mods = get_option( 'theme_mods_atua' );
	if ( ! empty( $atua_mods ) ) {
		foreach ( $atua_mods as $atua_mod_k => $atua_mod_v ) {
			set_theme_mod( $atua_mod_k, $atua_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'flexea_parent_theme_options' );